/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image.gif;

import com.elluminate.util.image.gif.GifImage;
import java.awt.Image;

public class AnimationFrame {
    private Image image;
    private int width;
    private int height;
    private int leftOffset;
    private int topOffset;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private long animationTime = 0L;
    private int pixelCount = 0;
    private int frameNumber = 0;

    public AnimationFrame(Image image, int leftOffset, int topOffset, long animationTime, long animationEnd, int frameNumber) {
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
        this.animationTime = animationTime;
        this.animationEnd = animationEnd;
        this.animationStart = animationEnd - animationTime;
        this.pixelCount = this.width * this.height;
        this.frameNumber = frameNumber;
    }

    public AnimationFrame(GifImage gifImage, long animationEnd, int frameNumber) throws InterruptedException {
        this.image = gifImage.getImage();
        this.width = gifImage.getWidth();
        this.height = gifImage.getHeight();
        this.leftOffset = gifImage.getLeftOffset();
        this.topOffset = gifImage.getTopOffset();
        this.animationTime = gifImage.getDelay();
        this.animationEnd = animationEnd;
        this.animationStart = animationEnd - this.animationTime;
        this.pixelCount = gifImage.getPixelCount();
        this.frameNumber = frameNumber;
    }

    public Image getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public int getTopOffset() {
        return this.topOffset;
    }

    public long getAnimationTime() {
        return this.animationTime;
    }

    public long getAnimationEnd() {
        return this.animationEnd;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public long getAnimationStart() {
        return this.animationStart;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    public void flush() {
        this.image.flush();
    }
}

