/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.platform.Platform;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.StringUtils;
import com.elluminate.util.image.PICTHelper;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

class SIPSHelper
extends PICTHelper {
    private static final boolean IS_SNOW_LEOPARD = Platform.checkOSVersion(202, "10.6+");
    private static final boolean IS_INTEL = Platform.getArch() == 101;
    private boolean available = true;
    private String info;

    SIPSHelper() throws IOException {
        StringBuffer buf = new StringBuffer();
        String[] cmd = new String[]{"sips"};
        int status = ProcessUtils.exec(cmd, buf, buf, 2000L, true);
        if (status != 0) {
            this.available = false;
            this.info = null;
            LogSupport.message(this, "<init>", "SIPS command failed: " + status + " " + buf.toString());
        } else {
            this.available = true;
            this.info = StringUtils.before(buf.toString(), "\n");
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public BufferedImage convertToImage(File f) throws IOException {
        return this.convertToImage(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage convertToImage(File f, Dimension size) throws IOException {
        BufferedImage result = null;
        File out = null;
        try {
            out = this.convertImageFile(f, size);
            result = ImageIO.read(out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
        return result;
    }

    @Override
    public BufferedImage convertToImage(byte[] data) throws IOException {
        return this.convertToImage(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage convertToImage(byte[] data, Dimension size) throws IOException {
        BufferedImage result = null;
        File f = null;
        File out = null;
        try {
            f = PICTImporter.saveToTempFile(data, ".pict");
            out = this.convertImageFile(f, size);
            result = ImageIO.read(out);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (out != null) {
                out.delete();
            }
        }
        return result;
    }

    public String toString() {
        return super.toString() + " " + this.info;
    }

    private File convertImageFile(File f, Dimension size) throws IOException {
        String[] cmd;
        File out = File.createTempFile("ImageTemp", ".png", Platform.getTempDir());
        out.deleteOnExit();
        if (size == null) {
            cmd = IS_SNOW_LEOPARD && IS_INTEL ? new String[]{"arch", "-arch", "i386", "sips", "--setProperty", "format", "png", f.getPath(), "--out", out.getPath()} : new String[]{"sips", "--setProperty", "format", "png", f.getPath(), "--out", out.getPath()};
        } else {
            cmd = IS_SNOW_LEOPARD && IS_INTEL ? new String[]{"arch", "-arch", "i386", "sips", "--setProperty", "format", "png", "--resampleHeightWidth", "" + size.height, "" + size.width, f.getPath(), "--out", out.getPath()} : new String[]{"sips", "--setProperty", "format", "png", "--resampleHeightWidth", "" + size.height, "" + size.width, f.getPath(), "--out", out.getPath()};
            LogSupport.message(this, "convertImageFile", "Warning: PICT aspect ratio not preserved.");
        }
        StringBuffer buf = new StringBuffer();
        int status = ProcessUtils.exec(cmd, buf, buf, 60000L, true);
        if (status == -2147483647) {
            LogSupport.message(this, "convertImageFile", "Converting PICT interrupted: " + f.getName());
        } else if (status != 0 || out.length() == 0L) {
            try {
                out.delete();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            LogSupport.message(this, "convertImageFile", "Failed to convert PICT (SIPS status " + status + "): " + f.getName() + "\n" + buf.toString() + "\n======== END OUTPUT");
            throw new RuntimeException("Failed to convert PICT: " + f.getName() + " status=" + status);
        }
        return out;
    }
}

