/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;

public class ChainableImageFilter
extends ImageFilter {
    private ImageFilter link = null;

    public ChainableImageFilter() {
    }

    public ChainableImageFilter(ImageFilter prevLink) {
        this.setPreviousLink(prevLink);
    }

    public ImageFilter getPreviousLink() {
        return this.link;
    }

    public boolean isLinked() {
        return this.link != null;
    }

    public synchronized void setPreviousLink(ImageFilter prevLink) {
        if (this.link == prevLink) {
            return;
        }
        if (prevLink != null && this.link != null) {
            throw new RuntimeException("Already threaded into a chain");
        }
        this.link = prevLink;
    }

    @Override
    public ImageFilter getFilterInstance(ImageConsumer ic) {
        ImageFilter prevLink = this.link;
        ImageFilter instance = super.getFilterInstance(ic);
        if (prevLink != null) {
            instance = prevLink.getFilterInstance(instance);
        }
        return instance;
    }
}

