/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.event;

import com.elluminate.util.Debug;
import com.elluminate.util.event.URLFillErrorEventSource;
import com.elluminate.util.log.LogSupport;
import java.util.EventObject;

public class URLFillErrorEvent
extends EventObject {
    public static final int READ_ERROR = 1;
    public static final int WRITE_ERROR = 2;
    public static final int PARSE_ERROR = 3;
    public static final int OTHER_ERROR = 999;
    public static final int DISPOSITION_NONE = 0;
    public static final int DISPOSITION_CANCEL = 1;
    public static final int DISPOSITION_CONTINUE = 2;
    public static final int DISPOSITION_RETRY = 4;
    public static final int DISPOSITION_RESTART = 8;
    private static final int DISPOSITION_ALL = 15;
    private int type = 0;
    private Throwable exception = null;
    private String message = null;
    private int mask = 0;
    private int disposition = 0;

    public static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "Read Error";
            }
            case 2: {
                return "Write Error";
            }
            case 3: {
                return "Parse Error";
            }
            case 999: {
                return "Other Error";
            }
        }
        return "Unknown Error Type " + type;
    }

    public static String getDispositionName(int disp) {
        int tmp;
        if (disp == 0) {
            return "None";
        }
        StringBuffer result = new StringBuffer();
        if ((disp & 1) != 0) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append("Cancel");
        }
        if ((disp & 2) != 0) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append("Continue");
        }
        if ((disp & 4) != 0) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append("Retry");
        }
        if ((disp & 8) != 0) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append("Restart");
        }
        if ((tmp = disp & 0xFFFFFFF0) != 0) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append("0x" + Integer.toHexString(tmp));
        }
        return result.toString();
    }

    public URLFillErrorEvent(URLFillErrorEventSource source, int errType, Throwable cause, int dispMask) {
        super(source);
        this.type = errType;
        this.exception = cause;
        this.message = cause.getMessage();
        this.mask = dispMask;
    }

    public URLFillErrorEvent(URLFillErrorEventSource source, int errType, String msg, int dispMask) {
        super(source);
        this.type = errType;
        this.exception = new RuntimeException(msg);
        this.message = msg;
        this.mask = dispMask;
    }

    public URLFillErrorEvent(URLFillErrorEventSource source, int errType, Throwable cause, String msg, int dispMask) {
        super(source);
        this.type = errType;
        this.exception = cause;
        this.message = msg;
        this.mask = dispMask;
    }

    public URLFillErrorEventSource getSourceURL() {
        return (URLFillErrorEventSource)this.getSource();
    }

    public int getType() {
        return this.type;
    }

    public Throwable getCause() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public int getDispositionMask() {
        return this.mask;
    }

    public void removeDispositionFromMask(int disp) {
        this.mask &= ~disp;
    }

    public void normalizeDispositionMask() {
        if (this.mask == 0) {
            this.mask = 1;
        }
    }

    public boolean isCancelable() {
        return (this.mask & 1) != 0;
    }

    public boolean isContinuable() {
        return (this.mask & 2) != 0;
    }

    public boolean isRestartable() {
        return (this.mask & 8) != 0;
    }

    public boolean isRetryable() {
        return (this.mask & 4) != 0;
    }

    public int getDisposition() {
        return this.disposition;
    }

    public void setDisposition(int disp) {
        if (disp != 1 && disp != 2 && disp != 8 && disp != 4) {
            throw new IllegalArgumentException("Invalid disposition: " + URLFillErrorEvent.getDispositionName(disp));
        }
        if ((disp & this.mask) != disp) {
            if (this.mask != 0) {
                LogSupport.error(this, "setDisposition", "Setting disposition not allowed by mask: " + URLFillErrorEvent.getDispositionName(disp) + " vs " + URLFillErrorEvent.getDispositionName(this.mask) + "\n" + Debug.getStackTrace(new RuntimeException("Not thrown")));
            }
            return;
        }
        this.disposition = disp;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName() + "#" + this.hashCode() + " " + URLFillErrorEvent.getTypeName(this.type) + " '" + this.message + "'" + " allowed=" + URLFillErrorEvent.getDispositionName(this.mask) + " disposition=" + URLFillErrorEvent.getDispositionName(this.disposition));
        for (Throwable t = this.exception; t != null; t = t.getCause()) {
            result.append(" cause=[" + t + "]");
        }
        return result.toString();
    }
}

