/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.DES;
import com.elluminate.util.crypto.Hex;

public class ThreeDES
implements BlkCipher {
    private DES pass1 = new DES();
    private DES pass2 = new DES();
    private DES pass3 = new DES();

    @Override
    public String getName() {
        return "ThreeDES";
    }

    @Override
    public int getKeyLength() {
        return 3 * this.pass1.getKeyLength();
    }

    @Override
    public int getKeyByteLength() {
        return 3 * this.pass1.getKeyByteLength();
    }

    @Override
    public int getBlockLength() {
        return this.pass1.getBlockLength();
    }

    @Override
    public int getBlockByteLength() {
        return this.pass1.getBlockByteLength();
    }

    @Override
    public void init(byte[] key, boolean encipher) {
        int delta;
        int offset;
        byte[] subkey = new byte[8];
        if (encipher) {
            offset = 0;
            delta = 8;
        } else {
            offset = 16;
            delta = -8;
        }
        System.arraycopy(key, offset, subkey, 0, 8);
        this.pass1.init(subkey, encipher);
        System.arraycopy(key, offset += delta, subkey, 0, 8);
        this.pass2.init(subkey, !encipher);
        System.arraycopy(key, offset += delta, subkey, 0, 8);
        this.pass3.init(subkey, encipher);
    }

    @Override
    public void processBlock(byte[] plain, int plainOff, byte[] cipher, int cipherOff) {
        System.arraycopy(plain, plainOff, cipher, cipherOff, 8);
        this.pass1.processBlock(cipher, cipherOff);
        this.pass2.processBlock(cipher, cipherOff);
        this.pass3.processBlock(cipher, cipherOff);
    }

    @Override
    public void processBlock(byte[] data, int off) {
        this.pass1.processBlock(data, off);
        this.pass2.processBlock(data, off);
        this.pass3.processBlock(data, off);
    }

    public static void main(String[] args) {
        byte[] key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -121, -106, -91, -76, -61, -46, -31, -16, 76, 93, 110, 127, -128, -111, -94, -77};
        byte[] plain = new byte[]{1, 35, 69, 103, -119, -85, -51, -25};
        byte[] cipher = new byte[8];
        byte[] decode = new byte[8];
        ThreeDES des = new ThreeDES();
        des.init(key, true);
        des.processBlock(plain, 0, cipher, 0);
        des.init(key, false);
        des.processBlock(cipher, 0, decode, 0);
        System.out.println(Hex.toString(plain) + " -> " + Hex.toString(cipher) + " -> " + Hex.toString(decode));
    }
}

