/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.AES;
import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.CBCMode;
import com.elluminate.util.crypto.MD4;
import com.elluminate.util.crypto.RSALicenseDecoder;
import com.elluminate.util.crypto.SHA256;
import com.elluminate.util.crypto.SecureHash;
import com.elluminate.util.crypto.ThreeDES;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSALicenseEncoder
extends OutputStream {
    SecureRandom rnd = new SecureRandom();
    ByteArrayOutputStream str = new ByteArrayOutputStream();
    BlkCipher cipher;
    int blkSize;
    BigInteger key;
    CBCMode cbc;
    byte[] vector;
    SecureHash sha;
    boolean isOpen = true;
    byte[] result = null;
    byte format;
    BigInteger exp;
    BigInteger mod;

    public RSALicenseEncoder(BigInteger exp, BigInteger mod) {
        this(exp, mod, 2);
    }

    public RSALicenseEncoder(BigInteger exp, BigInteger mod, byte fmt) {
        this.exp = exp;
        this.mod = mod;
        this.format = fmt;
        switch (this.format) {
            case 1: {
                this.cipher = new ThreeDES();
                this.sha = new MD4();
                break;
            }
            case 2: {
                this.cipher = new AES(128);
                this.sha = new SHA256();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.blkSize = this.cipher.getBlockByteLength();
        this.key = new BigInteger(this.cipher.getKeyLength() - 1, this.rnd);
        this.cbc = new CBCMode(this.cipher, this.key.toByteArray());
        this.vector = this.cbc.createIV();
    }

    public byte getFormat() {
        return this.format;
    }

    @Override
    public void write(int value) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Write while RSALicenseEncoder is closed.");
        }
        this.str.write(value);
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        ByteArrayOutputStream bstr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bstr);
        this.result = this.str.toByteArray();
        int delta = this.result.length % this.blkSize;
        if (delta != 0) {
            int len = this.result.length + this.blkSize - delta;
            byte[] padded = new byte[len];
            System.arraycopy(this.result, 0, padded, 0, this.result.length);
            this.result = padded;
        }
        BigInteger sessionKey = this.key.modPow(this.exp, this.mod);
        switch (this.format) {
            case 1: {
                this.sha.process(this.result);
                byte[] hashBytes = this.sha.hash();
                this.cbc.encrypt(this.vector, 0, this.result, 0, this.result, 0, this.result.length);
                try {
                    this.writeBigInt(ostr, sessionKey);
                    ostr.write(this.vector);
                    ostr.write(this.result);
                    ostr.write(hashBytes);
                    ostr.close();
                }
                catch (IOException iox) {}
                break;
            }
            case 2: {
                BigInteger hash = RSALicenseDecoder.getHash(this.sha, this.result);
                BigInteger sessionHash = hash.modPow(this.exp, this.mod);
                this.cbc.encrypt(this.vector, 0, this.result, 0, this.result, 0, this.result.length);
                try {
                    ostr.write(RSALicenseDecoder.TAG_RSA2);
                    this.writeBigInt(ostr, sessionKey);
                    this.writeBigInt(ostr, sessionHash);
                    ostr.write(this.vector);
                    ostr.write(this.result);
                    ostr.close();
                    break;
                }
                catch (IOException io) {
                    // empty catch block
                }
            }
        }
        this.result = bstr.toByteArray();
    }

    public byte[] toByteArray() throws IOException {
        if (this.isOpen) {
            throw new IOException("toByteArray while RSALicenseEncoder is open.");
        }
        return this.result;
    }

    private void writeBigInt(DataOutputStream ostr, BigInteger value) throws IOException {
        byte[] data = value.toByteArray();
        ostr.writeShort(data.length);
        ostr.write(data);
    }
}

