/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;

public class DiffieHellman {
    private static String modStr = "00cdf04a0074f36673ad486bcfa2c16a7fd0588b798fc7189e59445498f6a0b7d5302bf057847658b3a091ea9dcb44413ba8eee1dc50281167ec388bf7102c0213";
    private static String genStr = "05";
    private static BigInteger mod = new BigInteger(modStr, 16);
    private static BigInteger gen = new BigInteger(genStr, 16);
    private static int cLength = mod.toString(32).length();
    private static int kLength = -1;
    private BigInteger x = new BigInteger(512, random);
    private BigInteger Y = null;
    private static Random random = new SecureRandom();
    private static MessageDigest md5;

    public DiffieHellman() {
        try {
            MessageDigest md = (MessageDigest)md5.clone();
        }
        catch (Throwable t) {
            throw new RuntimeException("No MD5 message digest available.");
        }
    }

    public static int getChallengeLength() {
        return cLength;
    }

    public static String getPaddedChallenge(String s) {
        int pad = cLength - s.length();
        if (pad < 0) {
            throw new RuntimeException("Negative pad!!!");
        }
        if (pad > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < pad; ++i) {
                buf.append(' ');
            }
            buf.append(s);
            return buf.toString();
        }
        return s;
    }

    public String getChallenge() {
        return DiffieHellman.getPaddedChallenge(gen.modPow(this.x, mod).toString(32));
    }

    public BigInteger getRawChallenge() {
        return gen.modPow(this.x, mod);
    }

    public void setResponse(String response) {
        this.Y = new BigInteger(response.trim(), 32);
    }

    public void setRawResponse(BigInteger response) {
        this.Y = response;
    }

    public BigInteger getSecret() {
        return this.Y.modPow(this.x, mod);
    }

    public static int getKeyLength() {
        if (kLength < 0) {
            try {
                MessageDigest md = (MessageDigest)md5.clone();
                byte[] junk = new byte[]{0};
                kLength = md.digest(junk).length;
            }
            catch (Exception ex) {
                throw new RuntimeException("No MD5 message digest available.");
            }
        }
        return kLength;
    }

    public static byte[] getKey(BigInteger secret, String path) {
        byte[] digest;
        try {
            MessageDigest md = (MessageDigest)md5.clone();
            md.reset();
            md.update(path.getBytes());
            md.update(secret.toByteArray());
            digest = md.digest();
        }
        catch (Exception ex) {
            throw new RuntimeException("No MD5 message digest available.");
        }
        return digest;
    }

    public byte[] getKey(String path) {
        return DiffieHellman.getKey(this.getSecret(), path);
    }

    public static String getKeyString(BigInteger secret, String path) {
        BigInteger kInt = new BigInteger(DiffieHellman.getKey(secret, path));
        return kInt.toString(32);
    }

    public String getKeyString(String path) {
        BigInteger kInt = new BigInteger(this.getKey(path));
        return kInt.toString(32);
    }

    public static boolean checkKey(byte[] key, BigInteger secret, String path) {
        BigInteger digestC = new BigInteger(DiffieHellman.getKey(secret, path));
        BigInteger digestR = new BigInteger(key);
        return digestC.equals(digestR);
    }

    public boolean checkKey(byte[] key, String path) {
        BigInteger digestC = new BigInteger(this.getKey(path));
        BigInteger digestR = new BigInteger(key);
        boolean ok = digestC.equals(digestR);
        return ok;
    }

    public static boolean checkKeyString(String digestR, BigInteger secret, String path) {
        String digestC = DiffieHellman.getKeyString(secret, path);
        return digestC.equals(digestR);
    }

    public boolean checkKeyString(String digestR, String path) {
        String digestC = this.getKeyString(path);
        return digestC.equals(digestR);
    }

    public static void main(String[] args) {
        DiffieHellman client = new DiffieHellman();
        DiffieHellman server = new DiffieHellman();
        String X = client.getChallenge();
        String Y = server.getChallenge();
        System.out.println("X   = '" + X + "'");
        System.out.println("Y   = '" + Y + "'");
        client.setResponse(Y);
        server.setResponse(X);
        String kClient = client.getKeyString("test string");
        String kServer = server.getKeyString("test string");
        System.out.println("Key = '" + kClient + "', " + server.checkKeyString(kClient, "test string"));
        System.out.println("Key = '" + kServer + "', " + client.checkKeyString(kServer, "test string"));
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            md5 = null;
        }
    }
}

