/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.CryptoException;
import com.elluminate.util.crypto.SecureHash;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;

public class CryptoFactory {
    private static String[] NO_ARGS = new String[0];
    private static HashMap blockSignerCache = new HashMap();
    private static HashMap cipherCache = new HashMap();
    private static HashMap hashCache = new HashMap();

    private CryptoFactory() {
    }

    public static BlockSignerPair getBlockSignerPair(String nm) throws CryptoException {
        CachePair pair = (CachePair)blockSignerCache.get(nm);
        if (pair == null) {
            pair = new CachePair(SecureHash.class, BlkCipher.class, nm);
            blockSignerCache.put(nm, pair);
        }
        BlockSignerPair bsp = new BlockSignerPair();
        bsp.hash = (SecureHash)pair.b1.newInstance();
        bsp.cipher = (BlkCipher)pair.b2.newInstance();
        return bsp;
    }

    public static BlkCipher getCipher(String nm) throws CryptoException {
        Builder builder = (Builder)cipherCache.get(nm);
        if (builder == null) {
            builder = new Builder(BlkCipher.class, nm);
            cipherCache.put(nm, builder);
        }
        return (BlkCipher)builder.newInstance();
    }

    public static SecureHash getHash(String nm) throws CryptoException {
        Builder builder = (Builder)cipherCache.get(nm);
        if (builder == null) {
            builder = new Builder(SecureHash.class, nm);
            cipherCache.put(nm, builder);
        }
        return (SecureHash)builder.newInstance();
    }

    public static void main(String[] args) {
        int i;
        String[] htest = new String[]{"MD4", "MD4-12", "MD5", "SHA256", "DES"};
        String[] ctest = new String[]{"DES", "ThreeDES", "AES", "AES-128", "AES-192", "AES-256", "AES-512"};
        String[] ptest = new String[]{"MD4.ThreeDES", "SHA256.AES-128", "MD5.TwoFish", "SHA256.AES-256.RSA", "RSA"};
        for (i = 0; i < htest.length; ++i) {
            CryptoFactory.hcheck(htest[i]);
        }
        for (i = 0; i < ctest.length; ++i) {
            CryptoFactory.ccheck(ctest[i]);
        }
        for (i = 0; i < ptest.length; ++i) {
            CryptoFactory.pcheck(ptest[i]);
        }
    }

    private static void hcheck(String nm) {
        SecureHash sh = null;
        try {
            sh = CryptoFactory.getHash(nm);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        if (sh != null) {
            System.out.println(nm + ":\t" + sh.getName());
        } else {
            System.out.println(nm + ":\tNot found.");
        }
    }

    private static void ccheck(String nm) {
        BlkCipher bc = null;
        try {
            bc = CryptoFactory.getCipher(nm);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        if (bc != null) {
            System.out.println(nm + ":\t" + bc.getName());
        } else {
            System.out.println(nm + ":\tNot found.");
        }
    }

    private static void pcheck(String nm) {
        BlockSignerPair pair = null;
        try {
            pair = CryptoFactory.getBlockSignerPair(nm);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (pair != null) {
            System.out.println(nm + ":\t" + pair.hash.getName() + "." + pair.cipher.getName());
        } else {
            System.out.println(nm + ":\tNot found.");
        }
    }

    public static class BlockSignerPair {
        public BlkCipher cipher;
        public SecureHash hash;
    }

    private static class Builder {
        Class cls = null;
        Constructor constructor = null;
        Object[] args = null;

        public Builder(Class api, String nm) throws CryptoException {
            String clsName = this.getName(nm);
            String[] clsArgs = this.getArgs(nm);
            Class<?> c = null;
            try {
                c = Class.forName("com.elluminate.util.crypto." + clsName);
            }
            catch (Throwable t) {
                throw new CryptoException("Unable to find class for " + nm);
            }
            this.cls = c;
            if (!api.isAssignableFrom(c)) {
                throw new CryptoException(c.getName() + " is not a " + api.getName());
            }
            this.findConstructor(clsArgs);
        }

        public Builder(Class api, Class c, String[] encoded) throws CryptoException {
            this.cls = c;
            if (!api.isAssignableFrom(c)) {
                throw new CryptoException(c.getName() + " is not a " + api.getName());
            }
            this.findConstructor(encoded);
        }

        public Builder(Class api, Class c) throws CryptoException {
            this(api, c, NO_ARGS);
        }

        public Object newInstance() {
            try {
                if (this.constructor == null) {
                    return this.cls.newInstance();
                }
                return this.constructor.newInstance(this.args);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getName(String nm) {
            int dashx = nm.indexOf(45);
            if (dashx < 0) {
                return nm;
            }
            return nm.substring(0, dashx);
        }

        private String[] getArgs(String nm) {
            int dashx = nm.indexOf(45);
            if (dashx < 0) {
                return NO_ARGS;
            }
            ArrayList<String> arglist = new ArrayList<String>();
            int prevx = dashx + 1;
            while ((dashx = nm.indexOf(45, prevx)) > 0) {
                arglist.add(nm.substring(prevx, dashx));
                prevx = dashx + 1;
            }
            arglist.add(nm.substring(prevx));
            return arglist.toArray(NO_ARGS);
        }

        private void findConstructor(String[] enc) throws CryptoException {
            Constructor<?>[] c = this.cls.getConstructors();
            for (int i = 0; i < c.length; ++i) {
                Class[] types = c[i].getParameterTypes();
                if (types.length != enc.length) continue;
                this.constructor = c[i];
                this.args = this.buildArgList(types, enc);
                return;
            }
            throw new CryptoException("Unable to find a suitable constructor.");
        }

        private Object[] buildArgList(Class[] params, String[] args) throws CryptoException {
            Object[] arglist = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                arglist[i] = this.convertArg(params[i], args[i]);
            }
            return arglist;
        }

        private Object convertArg(Class c, String v) throws CryptoException {
            if (c.equals(String.class)) {
                return v;
            }
            if (c.equals(Integer.TYPE)) {
                return new Integer(v);
            }
            if (c.equals(Long.TYPE)) {
                return new Integer(v);
            }
            if (c.equals(Short.TYPE)) {
                return new Short(v);
            }
            if (c.equals(Boolean.TYPE)) {
                return Boolean.valueOf(v);
            }
            if (c.equals(Integer.class)) {
                return new Integer(v);
            }
            if (c.equals(Long.class)) {
                return new Long(v);
            }
            if (c.equals(Short.class)) {
                return new Short(v);
            }
            if (c.equals(Boolean.class)) {
                return Boolean.valueOf(v);
            }
            throw new CryptoException("Unable to convert string to " + c.getName());
        }
    }

    public static class CachePair {
        Builder b1;
        Builder b2;

        public CachePair(Class api1, Class api2, String nm) throws CryptoException {
            String[] names = this.split(nm);
            this.b1 = new Builder(api1, names[0]);
            this.b2 = new Builder(api2, names[1]);
        }

        private String[] split(String nm) throws CryptoException {
            int idx = nm.indexOf(46);
            if (idx < 0) {
                throw new CryptoException("Invalid algorithm pair name " + nm);
            }
            return new String[]{nm.substring(0, idx), nm.substring(idx + 1)};
        }
    }
}

