/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command;

import com.elluminate.util.command.Command;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;

public abstract class CommandAdapter
implements Command {
    protected BufferedReader console = null;
    protected PrintStream out = LogSupport.getSystemOut();
    protected PrintStream err = LogSupport.getSystemErr();
    protected String desc = "No description available.";
    protected String usage = "usage: @";
    private int responseCode = -1;
    private String responseMsg = null;

    public CommandAdapter() {
        InputStreamReader reader = new InputStreamReader(System.in);
        this.console = new BufferedReader(reader);
    }

    @Override
    public synchronized void setReader(BufferedReader in) {
        this.console = in;
    }

    @Override
    public BufferedReader getReader() {
        return this.console;
    }

    @Override
    public synchronized void setOutputStream(PrintStream out) {
        this.out = out;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    public synchronized void setErrorStream(PrintStream err) {
        this.err = err;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.err;
    }

    public synchronized void setDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public synchronized void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    public String getUsage(String name) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.usage.length(); ++i) {
            char c = this.usage.charAt(i);
            if (c == '@') {
                str.append(name);
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    protected void sendResponse(int code, String msg) {
        if (msg.indexOf(10) >= 0) {
            code += 10;
            if (msg.endsWith("\n.")) {
                this.out.println(code + " " + msg);
            } else {
                this.out.println(code + " " + msg + "\n.");
            }
        } else {
            this.out.println(code + " " + msg);
        }
        this.out.flush();
    }

    protected void beginResponse(int code, String msg) {
        if (this.responseMsg != null) {
            this.sendResponse(this.responseCode, this.responseMsg);
        } else if (this.responseCode > 0) {
            this.out.println(".");
        }
        this.responseCode = code;
        this.responseMsg = msg;
    }

    protected void appendResponse(String msg) {
        if (this.responseMsg != null) {
            this.responseCode += 10;
            this.sendResponse(this.responseCode, this.responseMsg);
            this.responseMsg = null;
        }
        if (this.responseCode > 0) {
            this.out.println(msg);
        }
    }

    protected void endResponse() {
        if (this.responseMsg != null) {
            this.sendResponse(this.responseCode, this.responseMsg);
        } else if (this.responseCode > 0) {
            this.out.println(".");
        }
        this.out.flush();
        this.responseCode = -1;
        this.responseMsg = null;
    }
}

