/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.browser;

import com.elluminate.util.ProcessUtils;
import com.elluminate.util.browser.ExternalBrowser;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

abstract class AbstractUnixExternalBrowser
implements ExternalBrowser {
    protected String execCommand;

    AbstractUnixExternalBrowser() {
    }

    protected void setExecCommand(String execCommand) {
        this.execCommand = execCommand;
    }

    protected String getExecCommand() {
        return this.execCommand;
    }

    @Override
    public boolean isAvailable() {
        String path = System.getenv("PATH");
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File tool = new File(dir, this.execCommand);
                if (!tool.exists() || !tool.isFile()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void launch(String url) throws IOException {
        if (!this.isAvailable()) {
            throw new IOException("The command " + this.execCommand + " is not available to launch this browser");
        }
        ProcessUtils.ignoreProcessOutput(Runtime.getRuntime().exec(this.getExecStringArray(url)));
    }

    protected abstract String[] getExecStringArray(String var1);
}

