/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UnknownTuningParamException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class TuningParam {
    public static final int ROLE_UNKNOWN = 0;
    public static final int ROLE_CLIENT = 1;
    public static final int ROLE_PEER = 2;
    public static final int ROLE_SERVER = 3;
    private static final int N_ROLES = 4;
    private static HashSet<String> prefixes = new HashSet();
    private static HashMap<String, TuningParam> cache = new HashMap();
    private static List<ClassLoader> classloaders;
    protected static int currentRole;
    protected String name;
    protected String value;
    protected boolean isSet = false;
    protected String[] defaults = new String[4];
    protected int[] intDefaults = new int[4];
    protected long[] longDefaults = new long[4];
    protected boolean[] boolDefaults = new boolean[4];

    protected TuningParam(String nm) {
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.isSet) {
            return this.value;
        }
        return this.getDefault();
    }

    public int getIntValue() {
        throw new UnsupportedOperationException("getIntValue not supported for " + this.getClass().getName());
    }

    public long getLongValue() {
        throw new UnsupportedOperationException("getLongValue not supported for " + this.getClass().getName());
    }

    public boolean getBooleanValue() {
        throw new UnsupportedOperationException("getBooleanValue not supported for " + this.getClass().getName());
    }

    public void setValue(String s) {
        this.value = s;
        this.isSet = true;
    }

    public void setValue(int i) {
        throw new UnsupportedOperationException("setValue(int) not supported for " + this.getClass().getName());
    }

    public void setValue(long i) {
        throw new UnsupportedOperationException("setValue(long) not supported for " + this.getClass().getName());
    }

    public void setValue(boolean b) {
        throw new UnsupportedOperationException("setValue(boolean) not supported for " + this.getClass().getName());
    }

    public void setDefault(String s) {
        this.setDefaults(s, 0, 0L, false);
    }

    public void setDefault(int i) {
        throw new UnsupportedOperationException("setDefault(int) not supported for " + this.getClass().getName());
    }

    public void setDefault(long l) {
        throw new UnsupportedOperationException("setDefault(int) not supported for " + this.getClass().getName());
    }

    public void setDefault(boolean b) {
        throw new UnsupportedOperationException("setDefault(boolean) not supported for " + this.getClass().getName());
    }

    public void setDefault(int role, String s) {
        this.setDefaults(role, s, 0, 0L, false);
    }

    public void setDefault(int role, int i) {
        throw new UnsupportedOperationException("setDefault(role,int) not supported for " + this.getClass().getName());
    }

    public void setDefault(int role, long l) {
        throw new UnsupportedOperationException("setDefault(role,long) not supported for " + this.getClass().getName());
    }

    public void setDefault(int role, boolean b) {
        throw new UnsupportedOperationException("setDefault(role,boolean) not supported for " + this.getClass().getName());
    }

    protected String getDefault() {
        return this.defaults[currentRole];
    }

    protected int getIntDefault() {
        return this.intDefaults[currentRole];
    }

    protected long getLongDefault() {
        return this.longDefaults[currentRole];
    }

    protected boolean getBooleanDefault() {
        return this.boolDefaults[currentRole];
    }

    protected void setDefaults(String sv, int iv, long lv, boolean bv) {
        for (int i = 0; i < this.defaults.length; ++i) {
            this.defaults[i] = sv;
            this.intDefaults[i] = iv;
            this.longDefaults[i] = lv;
            this.boolDefaults[i] = bv;
        }
    }

    protected void setDefaults(int role, String sv, int iv, long lv, boolean bv) {
        try {
            this.defaults[role] = sv;
            this.intDefaults[role] = iv;
            this.longDefaults[role] = lv;
            this.boolDefaults[role] = bv;
        }
        catch (ArrayIndexOutOfBoundsException oobx) {
            throw new IllegalArgumentException("Invalid Tuning parameter role " + role + " in call to setDefault");
        }
    }

    public static void addSearchPrefix(String prefix) {
        prefixes.add(prefix);
    }

    public static void removeSearchPrefix(String prefix) {
        prefixes.remove(prefix);
    }

    public static void addClassLoader(ClassLoader loader) {
        if (!classloaders.contains(loader)) {
            classloaders.add(loader);
        }
    }

    public static void removeClassLoader(ClassLoader loader) {
        if (loader != ClassLoader.getSystemClassLoader()) {
            classloaders.remove(loader);
        }
    }

    public static void setRole(int newRole) {
        if (newRole < 0 || newRole >= 4) {
            throw new IllegalArgumentException("Specified role is out of range (0..4)");
        }
        currentRole = newRole;
    }

    public static TuningParam get(String nm) throws UnknownTuningParamException {
        if (cache.containsKey(nm)) {
            return cache.get(nm);
        }
        int dot = nm.lastIndexOf(46);
        String pkg = null;
        String var = null;
        if (dot > 0) {
            pkg = nm.substring(0, dot);
            var = nm.substring(dot + 1);
        } else {
            var = nm;
        }
        String suffix = TuningParam.tuningFileName(pkg);
        for (String prefix : prefixes) {
            String fqName = prefix + suffix;
            try {
                Class<?> cls = TuningParam.getClass(fqName);
                Field f = cls.getField(var);
                TuningParam p = (TuningParam)f.get(null);
                cache.put(nm, p);
                return p;
            }
            catch (ClassNotFoundException cnfx) {
            }
            catch (NoSuchFieldException nsfx) {
            }
            catch (IllegalAccessException iax) {
            }
            catch (ClassCastException ccx) {
            }
        }
        throw new UnknownTuningParamException("Unknown tuning parameter: '" + nm + "'");
    }

    private static Class<?> getClass(String nm) throws ClassNotFoundException {
        for (ClassLoader loader : classloaders) {
            try {
                Class<?> cls = loader.loadClass(nm);
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException();
    }

    private static String tuningFileName(String pkgNm) {
        if (pkgNm == null) {
            return ".Tuning";
        }
        int dot = pkgNm.lastIndexOf(46);
        String fName = dot > 0 ? pkgNm.substring(dot + 1) : pkgNm;
        fName = fName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fName.substring(1);
        return "." + pkgNm + "." + fName + "Tuning";
    }

    static {
        currentRole = 0;
        classloaders = new LinkedList<ClassLoader>();
        classloaders.add(ClassLoader.getSystemClassLoader());
    }

    public static class BoolTuningParam
    extends TuningParam {
        private boolean boolValue;

        public BoolTuningParam(String nm, boolean dft) {
            super(nm);
            this.setDefaults(dft ? "true" : "false", 0, 0L, dft);
        }

        @Override
        public boolean getBooleanValue() {
            if (this.isSet) {
                return this.boolValue;
            }
            return this.getBooleanDefault();
        }

        @Override
        public void setValue(String v) {
            this.boolValue = this.checkValue(v);
            super.setValue(v);
        }

        public void setBooleanValue(boolean v) {
            this.boolValue = v;
            super.setValue(v ? "true" : "false");
        }

        @Override
        public void setDefault(String v) {
            boolean bv = this.checkValue(v);
            this.setDefaults(v, 0, 0L, bv);
        }

        @Override
        public void setDefault(boolean bv) {
            this.setDefaults(bv ? "true" : "false", 0, 0L, bv);
        }

        @Override
        public void setDefault(int role, String v) {
            boolean bv = this.checkValue(v);
            this.setDefaults(role, v, 0, 0L, bv);
        }

        @Override
        public void setDefault(int role, boolean bv) {
            this.setDefaults(role, bv ? "true" : "false", 0, 0L, bv);
        }

        protected boolean checkValue(String v) {
            if (v.equalsIgnoreCase("true")) {
                return true;
            }
            if (v.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid value '" + v + "' for tuning parameter " + this.getName() + " (true/false)");
        }
    }

    public static class ConstIntTuningParam
    extends IntTuningParam {
        boolean setOnce = false;

        public ConstIntTuningParam(String nm, int dft, int min, int max) {
            super(nm, dft, min, max);
        }

        @Override
        public void setValue(String v) {
            if (this.setOnce) {
                return;
            }
            super.setValue(v);
            this.setOnce = true;
        }

        @Override
        public void setValue(int iv) {
            if (this.setOnce) {
                return;
            }
            super.setValue(iv);
            this.setOnce = true;
        }
    }

    public static class EnumTuningParam
    extends TuningParam {
        String[] valid;
        int intValue;

        public EnumTuningParam(String nm, String dft, String[] set) {
            super(nm);
            this.valid = new String[set.length];
            System.arraycopy(set, 0, this.valid, 0, set.length);
            this.setDefault(dft);
        }

        @Override
        public int getIntValue() {
            if (this.isSet) {
                return this.intValue;
            }
            return this.getIntDefault();
        }

        @Override
        public void setValue(String v) {
            this.intValue = this.checkValue(v);
            super.setValue(v);
        }

        @Override
        public void setValue(int iv) {
            String v = this.checkValue(iv);
            this.intValue = iv;
            super.setValue(v);
        }

        @Override
        public void setDefault(String v) {
            int iv = this.checkValue(v);
            this.setDefaults(v, iv, iv, false);
        }

        @Override
        public void setDefault(int iv) {
            String v = this.checkValue(iv);
            this.setDefaults(v, iv, iv, false);
        }

        @Override
        public void setDefault(int role, String v) {
            int iv = this.checkValue(v);
            this.setDefaults(role, v, iv, iv, false);
        }

        @Override
        public void setDefault(int role, int iv) {
            String v = this.checkValue(iv);
            this.setDefaults(role, v, iv, iv, false);
        }

        protected String checkValue(int i) {
            String v;
            try {
                v = this.valid[i];
            }
            catch (ArrayIndexOutOfBoundsException oobx) {
                throw new IllegalArgumentException("Value '" + i + "' for tuning parameter " + this.getName() + " is out of range (0.." + (this.valid.length - 1) + ")");
            }
            return v;
        }

        protected int checkValue(String v) {
            for (int i = 0; i < this.valid.length; ++i) {
                if (!v.equals(this.valid[i])) continue;
                return i;
            }
            StringBuffer list = new StringBuffer();
            int sep = 91;
            for (int i = 0; i < this.valid.length; ++i) {
                list.append((char)sep);
                list.append(this.valid[i]);
                sep = 44;
            }
            list.append(']');
            throw new IllegalArgumentException("Invalid value '" + v + "' for tuning parameter " + this.getName() + " " + list);
        }

        void read(String v) {
            this.setValue(v);
        }
    }

    public static class IntTuningParam
    extends TuningParam {
        private int intValue;
        private int minimum;
        private int maximum;

        public IntTuningParam(String nm, int dft, int min, int max) {
            super(nm);
            this.minimum = min;
            this.maximum = max;
            this.setDefaults(Integer.toString(dft), dft, dft, false);
        }

        @Override
        public int getIntValue() {
            if (this.isSet) {
                return this.intValue;
            }
            return this.getIntDefault();
        }

        @Override
        public long getLongValue() {
            return this.getIntValue();
        }

        @Override
        public void setValue(String v) {
            this.intValue = this.checkValue(v);
            super.setValue(v);
        }

        @Override
        public void setValue(int iv) {
            String v = this.checkValue(iv);
            this.intValue = iv;
            super.setValue(v);
        }

        @Override
        public void setDefault(String v) {
            int iv = this.checkValue(v);
            this.setDefaults(v, iv, iv, false);
        }

        @Override
        public void setDefault(int iv) {
            String v = this.checkValue(iv);
            this.setDefaults(v, iv, iv, false);
        }

        @Override
        public void setDefault(int role, String v) {
            int iv = this.checkValue(v);
            this.setDefaults(role, v, iv, iv, false);
        }

        @Override
        public void setDefault(int role, int iv) {
            String v = this.checkValue(iv);
            this.setDefaults(role, v, iv, iv, false);
        }

        protected String checkValue(int iv) {
            if (iv < this.minimum || iv > this.maximum) {
                throw new IllegalArgumentException("Value " + iv + " is out of range for tuning parameter " + this.getName() + " (" + this.minimum + ".." + this.maximum + ")");
            }
            return Integer.toString(iv);
        }

        private int checkValue(String v) {
            int i;
            try {
                i = Integer.parseInt(v.trim());
            }
            catch (NumberFormatException nfx) {
                throw new IllegalArgumentException("Value " + v + " could not be converted to an integer value for tuning parameter " + this.getName());
            }
            this.checkValue(i);
            return i;
        }
    }

    public static class LongTuningParam
    extends TuningParam {
        private long longValue;
        private long minimum;
        private long maximum;

        public LongTuningParam(String nm, long dft, long min, long max) {
            super(nm);
            this.minimum = min;
            this.maximum = max;
            this.setDefaults(Long.toString(dft), 0, dft, false);
        }

        @Override
        public long getLongValue() {
            if (this.isSet) {
                return this.longValue;
            }
            return this.getLongDefault();
        }

        @Override
        public void setValue(String v) {
            this.longValue = this.checkValue(v);
            super.setValue(v);
        }

        @Override
        public void setValue(long lv) {
            String v = this.checkValue(lv);
            this.longValue = lv;
            super.setValue(v);
        }

        @Override
        public void setDefault(String v) {
            long lv = this.checkValue(v);
            this.setDefaults(v, 0, lv, false);
        }

        @Override
        public void setDefault(long lv) {
            String v = this.checkValue(lv);
            this.setDefaults(v, 0, lv, false);
        }

        @Override
        public void setDefault(int role, String v) {
            long lv = this.checkValue(v);
            this.setDefaults(role, v, 0, lv, false);
        }

        @Override
        public void setDefault(int role, long lv) {
            String v = this.checkValue(lv);
            this.setDefaults(role, v, 0, lv, false);
        }

        protected String checkValue(long lv) {
            if (lv < this.minimum || lv > this.maximum) {
                throw new IllegalArgumentException("Value " + lv + " is out of range for tuning parameter " + this.getName() + " (" + this.minimum + ".." + this.maximum + ")");
            }
            return Long.toString(lv);
        }

        private long checkValue(String v) {
            long l;
            try {
                l = Long.parseLong(v.trim());
            }
            catch (NumberFormatException nfx) {
                throw new IllegalArgumentException("Value " + v + " could not be converted to a long integer value for tuning parameter " + this.getName());
            }
            this.checkValue(l);
            return l;
        }
    }
}

