/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.WorkerThread;

public class TimerResolution {
    private static Resolver resolver = null;

    private TimerResolution() {
    }

    public static long get() {
        if (resolver == null) {
            resolver = new Resolver(null);
        }
        return resolver.getResolution();
    }

    public static void compute() {
        resolver = new Resolver(null);
    }

    public static void compute(ThreadGroup grp) {
        resolver = new Resolver(grp);
    }

    static class Resolver
    implements Runnable {
        private Thread computeThread = null;
        private long resolution = -1L;

        public Resolver(ThreadGroup grp) {
            this.computeThread = new WorkerThread(grp, this);
            this.computeThread.setDaemon(true);
            this.computeThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int delta;
            long clockResolution = 100L;
            int[] msec = new int[128];
            Object lock = new Object();
            for (int i = 0; i < 3; ++i) {
                long start;
                long now = start = System.currentTimeMillis();
                while (now == start) {
                    now = System.currentTimeMillis();
                }
                long delta2 = now - start;
                if (delta2 >= clockResolution) continue;
                clockResolution = delta2;
            }
            while (true) {
                Object object = lock;
                synchronized (object) {
                    long start = System.currentTimeMillis();
                    try {
                        lock.wait(1L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    delta = (int)(System.currentTimeMillis() - start);
                }
                if (delta <= 0) continue;
                if (delta > 127) {
                    delta = 127;
                }
                int n = delta;
                msec[n] = msec[n] + 1;
                if (msec[delta] > 64) break;
            }
            long waitResolution = delta;
            Resolver resolver = this;
            synchronized (resolver) {
                this.resolution = Math.max(waitResolution, clockResolution);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getResolution() {
            while (this.resolution <= 0L) {
                Resolver resolver = this;
                synchronized (resolver) {
                    if (this.resolution <= 0L) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.resolution;
        }
    }
}

