/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelephonyUtils {
    private static final String TELE_SIP_START_SEQ = "sip:";
    private static final String TELEPHONE_NUMBER_CHARACTERS = "[-0-9*#() .]*";
    private static final String[] formatRegExp = new String[]{"1-[0-9][0-9][0-9]-[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]", "1 [0-9][0-9][0-9] [0-9][0-9][0-9] [0-9][0-9][0-9][0-9]", "1 [(][0-9][0-9][0-9][)] [0-9][0-9][0-9] [0-9][0-9][0-9][0-9]", "1 [(][0-9][0-9][0-9][)] [0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]", "[0-9][0-9][0-9]-[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]", "[02-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]", "1[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]", "[0-9][0-9][0-9] [0-9][0-9][0-9] [0-9][0-9][0-9][0-9]", "[(][0-9][0-9][0-9][)] [0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]", "[0-9][0-9][0-9][.][0-9][0-9][0-9][.][0-9][0-9][0-9][0-9]"};

    private TelephonyUtils() {
    }

    public static boolean isStringAValidSipURI(String sipURI) {
        if (sipURI == null || sipURI.equals("")) {
            return false;
        }
        try {
            String substring = sipURI.substring(0, TELE_SIP_START_SEQ.length());
            if (!TELE_SIP_START_SEQ.equalsIgnoreCase(substring)) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return sipURI.length() > TELE_SIP_START_SEQ.length();
    }

    public static String[] getTelephoneRegularExpressions() {
        return formatRegExp;
    }

    public static boolean checkTelephonyNumberIsATelephoneNumber(String number) {
        Pattern pattern = Pattern.compile(TELEPHONE_NUMBER_CHARACTERS);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }

    public static boolean isStringATelephoneNumber(String number, boolean checkForNoEntry) {
        if (number == null || number.equals("")) {
            return !checkForNoEntry;
        }
        number = number.trim();
        try {
            Pattern pattern = Pattern.compile(TELEPHONE_NUMBER_CHARACTERS);
            Matcher matcher = pattern.matcher(number);
            if (!matcher.matches()) {
                return false;
            }
            for (String regEx : formatRegExp) {
                if (!TelephonyUtils.doesStringMatchRegExpression(number, regEx)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean doesStringMatchRegExpression(String strToTest, String regExpression) {
        Pattern pattern = Pattern.compile(regExpression);
        Matcher matcher = pattern.matcher(strToTest);
        return matcher.matches();
    }

    public static boolean isStringAPin(String pin) {
        if (pin == null) {
            return true;
        }
        try {
            String regExpression = "[0-9*#,]*";
            Pattern pattern = Pattern.compile(regExpression);
            Matcher matcher = pattern.matcher(pin);
            if (!matcher.matches()) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static String normalizeTelephoneNumber(String number, boolean validateTelephoneNumbers) {
        if (number == null) {
            return number;
        }
        number = number.replaceAll("[-() .*#]", "");
        if (validateTelephoneNumbers && number.indexOf("1") != 0) {
            number = "1" + number;
        }
        return number;
    }
}

