/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import java.util.HashMap;
import java.util.Iterator;

public class ReaderWriterLock {
    private static final ObjectPool pool = ObjectPool.getInstance(LockerID.class);
    private int waitQuantum = 500;
    private LockerID writer = null;
    private HashMap readers = null;
    private int pendingWriters = 0;

    public ReaderWriterLock() {
        this.readers = new HashMap();
    }

    public ReaderWriterLock(int maxReaders) {
        int capacity = maxReaders * 2 - 1;
        if (capacity < 11) {
            capacity = 11;
        }
        this.readers = new HashMap(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReaderWriterLock readerWriterLock = this;
        synchronized (readerWriterLock) {
            Iterator it = this.readers.keySet().iterator();
            while (it.hasNext()) {
                Object cur = it.next();
                if (!(cur instanceof LockerID)) continue;
                it.remove();
                ((LockerID)cur).dispose();
            }
            if (this.writer != null) {
                this.writer.dispose();
                this.writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRead() {
        Thread key = Thread.currentThread();
        ReaderWriterLock readerWriterLock = this;
        synchronized (readerWriterLock) {
            LockerID cur;
            while (true) {
                if (this.writer == null && this.pendingWriters == 0 || this.writer != null && this.writer.getOwner() == key) {
                    cur = (LockerID)this.readers.get(key);
                    if (cur == null) {
                        cur = (LockerID)pool.alloc();
                        cur.setOwner(key);
                        this.readers.put(key, cur);
                    }
                    break;
                }
                if (this.checkDeadThreads()) continue;
                try {
                    this.wait(this.waitQuantum);
                }
                catch (InterruptedException interruptedException) {}
            }
            cur.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRead() {
        Thread key = Thread.currentThread();
        ReaderWriterLock readerWriterLock = this;
        synchronized (readerWriterLock) {
            LockerID cur = (LockerID)this.readers.get(key);
            if (cur == null) {
                throw new RuntimeException("Current thread " + key + " does not hold a read lock: " + this);
            }
            cur.decrement();
            if (cur.getCount() == 0) {
                this.readers.remove(key);
                cur.dispose();
                if (this.readers.size() == 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWrite() {
        Thread key = Thread.currentThread();
        ReaderWriterLock readerWriterLock = this;
        synchronized (readerWriterLock) {
            ++this.pendingWriters;
            try {
                while (true) {
                    if (this.readers.size() == 0 || this.readers.size() == 1 && this.readers.get(key) != null) {
                        if (this.writer == null) {
                            this.writer = (LockerID)pool.alloc();
                            this.writer.setOwner(key);
                            this.writer.increment();
                            break;
                        }
                        if (this.writer.getOwner() == key) {
                            this.writer.increment();
                            break;
                        }
                    }
                    if (this.checkDeadThreads()) continue;
                    try {
                        this.wait(this.waitQuantum);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                if (this.pendingWriters > 0) {
                    --this.pendingWriters;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockWrite() {
        Thread key = Thread.currentThread();
        ReaderWriterLock readerWriterLock = this;
        synchronized (readerWriterLock) {
            if (this.writer == null || this.writer.getOwner() != key) {
                throw new NotLockedException("Current thread " + key + " does not hold the write lock: " + this);
            }
            this.writer.decrement();
            if (this.writer.getCount() == 0) {
                this.writer.dispose();
                this.writer = null;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName() + " ");
        buf.append("nReaders=" + this.readers.size());
        buf.append(",writer=" + this.writer);
        buf.append(",readers=" + this.readers);
        return buf.toString();
    }

    private boolean checkDeadThreads() {
        boolean result = false;
        if (this.writer != null && !this.writer.getOwner().isAlive()) {
            this.writer.dispose();
            this.writer = null;
            result = true;
        }
        if (this.readers != null) {
            for (Thread t : this.readers.keySet()) {
                if (t.isAlive()) continue;
                LockerID lid = (LockerID)this.readers.remove(t);
                lid.dispose();
                result = true;
            }
        }
        return result;
    }

    private static class LockerID
    extends PooledObject {
        private Thread owner = null;
        private int count = 0;

        @Override
        public void poInit() {
            this.owner = null;
            this.count = 0;
            super.poInit();
        }

        @Override
        public void poCleanup() {
            this.owner = null;
        }

        @Override
        public void dispose() {
            this.owner = null;
            this.count = 0;
            super.dispose();
        }

        Thread getOwner() {
            return this.owner;
        }

        void setOwner(Thread t) {
            this.owner = t;
        }

        int getCount() {
            return this.count;
        }

        void increment() {
            ++this.count;
        }

        void decrement() {
            if (this.count > 0) {
                --this.count;
            }
        }

        public String toString() {
            return "[owner=" + this.owner + ",count=" + this.count + "]";
        }
    }

    public static class NotLockedException
    extends RuntimeException {
        public NotLockedException() {
        }

        public NotLockedException(String msg) {
            super(msg);
        }
    }
}

