/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

public class Rational {
    private double number;
    private double absNumber;
    private double error_bound;
    private long numerator;
    private long denominator;
    private long iteration_limit;
    private boolean rational = false;
    private static final long ITERATION_LIMIT = 10000L;
    private static final double ERROR_BOUND = 1.0E-20;

    public Rational(float input) {
        this((double)input);
    }

    public Rational(float input, long iters) {
        this((double)input, iters);
    }

    public Rational(float input, long iters, double err_bound) {
        this((double)input, iters, err_bound);
    }

    public Rational(double input) {
        this(input, 10000L, 1.0E-20);
    }

    public Rational(double input, long iters) {
        this(input, iters, 1.0E-20);
    }

    public Rational(double input, long iters, double err_bound) {
        this.number = input;
        this.iteration_limit = iters;
        this.error_bound = err_bound;
        this.evaluate();
    }

    public boolean isRational() {
        return this.rational;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public boolean testRational(float input) {
        return this.testRational((double)input);
    }

    public boolean testRational(double input) {
        this.number = input;
        this.evaluate();
        return this.rational;
    }

    private void evaluate() {
        this.absNumber = Math.abs(this.number);
        if (this.absNumber < this.error_bound) {
            this.numerator = 0L;
            this.denominator = 1L;
            this.rational = this.number > 0.0;
            return;
        }
        this.rational = false;
        if (this.absNumber > 1.0) {
            double upper_bound = Math.ceil((double)this.iteration_limit / this.absNumber);
            for (double denom = 1.0; denom <= upper_bound; denom += 1.0) {
                double y = denom * this.absNumber;
                this.numerator = (long)(y + 0.5);
                double delta = (double)this.numerator / denom - this.absNumber;
                double d = delta < 0.0 ? -delta : delta;
                if (!(d < this.error_bound)) continue;
                this.denominator = (long)denom;
                this.rational = true;
                break;
            }
        } else {
            double upper_bound = Math.ceil((double)this.iteration_limit * this.absNumber);
            double mult = 1.0 / this.absNumber;
            for (double num = 1.0; num <= upper_bound; num += 1.0) {
                double y = num * mult;
                this.denominator = (long)(y + 0.5);
                double delta = num / (double)this.denominator - this.absNumber;
                double d = delta < 0.0 ? -delta : delta;
                if (!(d < this.error_bound)) continue;
                this.numerator = (long)num;
                this.rational = true;
                break;
            }
        }
        if (this.rational && this.number < this.absNumber) {
            this.numerator = -this.numerator;
        }
    }
}

