/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class QuotedStringTokenizer
implements Enumeration {
    private String string;
    private int cursor = 0;
    private int max;
    private String delimiters;
    private char maxDelim;
    private boolean returnDelims;
    private char quote;
    private char escape;
    private int count = -1;

    public QuotedStringTokenizer(String base) {
        this(base, " \r\n\t", '\"', '\\', false);
    }

    public QuotedStringTokenizer(String base, String delims) {
        this(base, delims, '\"', '\\', false);
    }

    public QuotedStringTokenizer(String base, String delims, char escape) {
        this(base, delims, escape, escape, false);
    }

    public QuotedStringTokenizer(String base, String delims, char quote, char escape) {
        this(base, delims, quote, escape, false);
    }

    public QuotedStringTokenizer(String base, String delims, char quote, char escape, boolean returnDelims) {
        this.string = base;
        this.max = base.length();
        this.delimiters = delims;
        this.quote = quote;
        this.escape = escape;
        this.returnDelims = returnDelims;
        this.maxDelim = this.getMaxDelim(this.delimiters);
    }

    public boolean hasMoreTokens() {
        int offset = this.skipDelimiters(this.cursor, this.maxDelim, this.delimiters);
        return offset < this.max;
    }

    public boolean hasMoreTokens(String delims) {
        int offset = this.skipDelimiters(this.cursor, this.getMaxDelim(delims), delims);
        return offset < this.max;
    }

    public String nextToken() {
        if (this.count > 0) {
            --this.count;
        }
        return this.getNextToken(this.delimiters, this.maxDelim);
    }

    public String nextToken(String delim) {
        this.count = -1;
        return this.getNextToken(delim, this.getMaxDelim(delim));
    }

    private String getNextToken(String delim, int dMax) {
        int start = this.skipDelimiters(this.cursor, dMax, delim);
        StringBuffer buf = null;
        boolean escaped = false;
        boolean quoted = false;
        this.cursor = start + 1;
        if (start >= this.max) {
            throw new NoSuchElementException();
        }
        char c = this.string.charAt(start);
        if (c == this.escape) {
            escaped = true;
            buf = new StringBuffer();
        } else if (c == this.quote) {
            quoted = true;
            buf = new StringBuffer();
        } else if (this.returnDelims && c <= dMax && delim.indexOf(c) >= 0) {
            return this.string.substring(start, this.cursor);
        }
        while (this.cursor < this.max) {
            c = this.string.charAt(this.cursor);
            if (escaped) {
                buf.append(c);
                escaped = false;
            } else if (quoted) {
                if (c == this.escape) {
                    escaped = true;
                } else if (c == this.quote) {
                    quoted = false;
                } else {
                    buf.append(c);
                }
            } else if (c == this.escape) {
                if (buf == null) {
                    buf = new StringBuffer(this.string.substring(start, this.cursor));
                }
                escaped = true;
            } else if (c == this.quote) {
                if (buf == null) {
                    buf = new StringBuffer(this.string.substring(start, this.cursor));
                }
                quoted = true;
            } else {
                if (c <= dMax && delim.indexOf(c) >= 0) break;
                if (buf != null) {
                    buf.append(c);
                }
            }
            ++this.cursor;
        }
        if (escaped) {
            buf.append(this.escape);
        }
        if (buf != null) {
            return buf.toString();
        }
        return this.string.substring(start, this.cursor);
    }

    public String getRemaining(boolean skip) {
        if (skip) {
            this.cursor = this.skipDelimiters(this.cursor, this.maxDelim, this.delimiters);
        }
        if (this.cursor >= this.max) {
            return "";
        }
        return this.string.substring(this.cursor);
    }

    public int countTokens() {
        if (this.count >= 0) {
            return this.count;
        }
        int n = 0;
        int saved = this.cursor;
        while (this.hasMoreTokens()) {
            ++n;
            this.nextToken();
        }
        this.cursor = saved;
        this.count = n;
        return this.count;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    private char getMaxDelim(String delims) {
        char dMax = '\u0000';
        for (int i = 0; i < delims.length(); ++i) {
            char c = delims.charAt(i);
            if (c <= dMax) continue;
            dMax = c;
        }
        return dMax;
    }

    private int skipDelimiters(int here, int dMax, String delims) {
        if (!this.returnDelims) {
            char c;
            while (here < this.max && (c = this.string.charAt(here)) <= dMax && delims.indexOf(c) >= 0) {
                ++here;
            }
        }
        return here;
    }
}

