/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.util.zip.Checksum;

public class QuickHash
implements Checksum {
    private long hash = 0L;

    @Override
    public long getValue() {
        return this.hash;
    }

    @Override
    public void reset() {
        this.hash = 0L;
    }

    @Override
    public void update(int b) {
        this.hash = this.hash * 31L + (long)b;
    }

    @Override
    public void update(byte[] data, int start, int len) {
        for (int ix = 0; ix < len; ++ix) {
            this.hash = this.hash * 31L + (long)(data[start + ix] & 0xFF);
        }
    }

    public static long hash(byte[] data) {
        return QuickHash.hash(data, 0, data.length);
    }

    public static long hash(byte[] data, int start, int len) {
        long hash = 0L;
        for (int ix = start; ix < start + len; ++ix) {
            hash = hash * 31L + (long)(data[ix] & 0xFF);
        }
        return hash;
    }

    public static void main(String[] args) {
        QuickHash hash = new QuickHash();
        StringBuilder buf = new StringBuilder();
        try {
            for (int ix = 0; ix < args.length; ++ix) {
                int b = Integer.parseInt(args[ix], 16) & 0xFF;
                hash.update(b);
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (b < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(b));
            }
            long val = hash.getValue();
            System.err.println("QuickHash (" + args.length + " bytes): " + buf + " = " + val + " = 0x" + Long.toHexString(val));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

