/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.log.LogSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class PriorityDeadlineQueue {
    public static final long NO_DEADLINE = -1L;
    private static final long MAX_DEADLINE = 0x7FFFFFFFFFFFFBFFL;
    private QueueHead[] byBase;
    private QueueHead[] byDeadline;
    private long deadlineIncrement;
    private volatile int changeClock = 0;
    private Object lock = new Object();
    private volatile DiscardHook discardHook = null;
    private int count = 0;

    public PriorityDeadlineQueue(byte max, long inc) {
        int n = max + 1;
        this.deadlineIncrement = inc;
        this.byBase = new QueueHead[n];
        this.byDeadline = new QueueHead[n];
        for (int i = 0; i < n; ++i) {
            this.byBase[i] = this.byDeadline[i] = new QueueHead((byte)i, inc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirst(boolean remove) {
        Object o = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                if (remove) {
                    o = this.byDeadline[0].removeFirst();
                    --this.count;
                    ++this.changeClock;
                    for (int i = 0; i < this.byDeadline.length - 1 && this.byDeadline[i].getDeadline() > this.byDeadline[i + 1].getDeadline(); ++i) {
                        this.swap(this.byDeadline, i, i + 1);
                    }
                } else {
                    o = this.byDeadline[0].getFirst();
                }
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getQueuedPriority() {
        byte p = -1;
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                p = this.byDeadline[0].getPriority();
            }
        }
        return p;
    }

    public byte getEffectivePriority() {
        return this.getEffectivePriority(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getEffectivePriority(long tm) {
        byte p = -1;
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                p = this.byDeadline[0].getEffectivePriority(tm);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeadline() {
        long d = 0x7FFFFFFFFFFFFBFFL;
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                d = this.byDeadline[0].getDeadline();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evaluate(Evaluator e) {
        boolean more = true;
        long now = System.currentTimeMillis();
        QueueEntry ent = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.count == 0) {
                return;
            }
            int bx = this.nextBase(-1);
            int dx = 0;
            for (int i = 0; i < this.byDeadline.length && !this.byDeadline[i].isEmpty(); ++i) {
                this.byDeadline[i].computeEffectivePriority(now);
            }
            while (more) {
                if (ent != null) {
                    Object o = ent.getData();
                    more = e.eval((byte)bx, o);
                    if ((ent = ent.getNext()) != null) continue;
                    bx = this.nextBase(bx);
                    continue;
                }
                if (dx < this.byDeadline.length && !this.byDeadline[dx].isEmpty()) {
                    byte eff = this.byDeadline[dx].getEffectivePriority();
                    if (this.byDeadline[dx] == this.byBase[bx] || eff <= bx) {
                        Object o = this.byDeadline[dx].getFirst();
                        more = e.eval(eff, o);
                        ++dx;
                        continue;
                    }
                    ent = this.byBase[bx].getSecond();
                    if (ent != null) continue;
                    bx = this.nextBase(bx);
                    continue;
                }
                if (bx < this.byBase.length) {
                    ent = this.byBase[bx].getSecond();
                    if (ent != null) continue;
                    bx = this.nextBase(bx);
                    continue;
                }
                more = false;
            }
        }
    }

    private final int nextBase(int b) {
        while (++b < this.byBase.length && this.byBase[b].isEmpty()) {
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(byte pri, Object data) {
        boolean empty;
        if (pri < 0) {
            pri = 0;
        }
        if (pri >= this.byBase.length) {
            pri = (byte)(this.byBase.length - 1);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = empty = this.count == 0;
            if (this.byBase[pri].addLast(data)) {
                for (int i = pri; i < this.byDeadline.length; ++i) {
                    if (this.byDeadline[i].getPriority() != pri) continue;
                    long current = this.byDeadline[i].getDeadline();
                    for (int j = i - 1; j >= 0 && current < this.byDeadline[j].getDeadline(); --j) {
                        this.swap(this.byDeadline, j, j + 1);
                    }
                    break;
                }
            }
            ++this.changeClock;
            ++this.count;
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; !found && i < this.byBase.length; ++i) {
                found = this.byBase[i].isQueued(o);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean empty;
        Object object = this.lock;
        synchronized (object) {
            empty = this.count == 0;
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        boolean found = false;
        int reorderRow = -1;
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; !found && i < this.byDeadline.length; ++i) {
                Object first = this.byDeadline[i].getFirst();
                if (first == o) {
                    reorderRow = i;
                }
                found = this.byDeadline[i].findAndRemove(o);
            }
            if (found) {
                ++this.changeClock;
                --this.count;
            }
            if (reorderRow >= 0) {
                long current = this.byDeadline[reorderRow].getDeadline();
                for (int i = reorderRow + 1; i < this.byDeadline.length && this.byDeadline[i].getDeadline() < current; ++i) {
                    this.swap(this.byDeadline, i - 1, i);
                }
            }
        }
        return found;
    }

    public long getPriorityIncrementInterval() {
        return this.deadlineIncrement;
    }

    public void setPriorityIncrementInterval(long inc) {
        this.deadlineIncrement = inc;
        for (int i = 0; i < this.byBase.length; ++i) {
            this.byBase[i].setDeadlineIncrement(inc);
        }
    }

    public int getChangeClock() {
        return this.changeClock;
    }

    public void clear() {
        this.clear((byte)-127);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(byte min) {
        LinkedList discardList = null;
        if (this.discardHook != null) {
            discardList = new LinkedList();
        }
        Object object = this.lock;
        synchronized (object) {
            ++this.changeClock;
            this.count = 0;
            for (int i = 0; i < this.byBase.length; ++i) {
                if (this.byBase[i].getPriority() > min) {
                    this.byBase[i].clear(discardList);
                    continue;
                }
                this.count += this.byBase[i].count;
            }
            this.sort();
        }
        if (discardList != null) {
            Iterator i = discardList.iterator();
            while (i.hasNext()) {
                this.fireDiscardHook(i.next());
            }
        }
    }

    private final void sort() {
        int i;
        for (i = 0; i < this.byDeadline.length; ++i) {
            this.byDeadline[i] = this.byBase[i];
        }
        for (i = 1; i < this.byDeadline.length; ++i) {
            long current = this.byDeadline[i].getDeadline();
            for (int j = i - 1; j >= 0 && current < this.byDeadline[j].getDeadline(); --j) {
                this.swap(this.byDeadline, j, j + 1);
            }
        }
    }

    private final void swap(QueueHead[] list, int a, int b) {
        QueueHead tmp = list[a];
        list[a] = list[b];
        list[b] = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardHook(DiscardHook hook) {
        Object object = this.lock;
        synchronized (object) {
            this.discardHook = hook;
        }
    }

    private void fireDiscardHook(Object o) {
        DiscardHook d = this.discardHook;
        try {
            if (d != null) {
                d.itemDiscarded(o);
            }
        }
        catch (Throwable t) {
            LogSupport.exception(this, "fireDiscardHook", t, true);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" [\n");
        for (int i = 0; i < this.byBase.length; ++i) {
            buf.append("    ");
            buf.append(this.byBase[i].toString());
        }
        return buf.toString();
    }

    private void test() {
        this.populate();
        this.iterate();
        this.extract();
    }

    private void populate() {
        this.put((byte)3, "Pri 3 - 1");
        this.dump();
        this.put((byte)3, "Pri 3 - 2");
        this.dump();
        this.put((byte)3, "Pri 3 - 3");
        this.dump();
        try {
            Thread.sleep(1200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.put((byte)2, "Pri 2 - 1");
        this.dump();
        this.put((byte)2, "Pri 2 - 2");
        this.dump();
        this.put((byte)1, "Pri 1 - 1");
        this.dump();
    }

    private void iterate() {
        Evaluator eval = new Evaluator(){

            @Override
            public boolean eval(byte pri, Object o) {
                System.out.println(pri + ": " + o);
                return true;
            }
        };
        this.evaluate(eval);
    }

    private void extract() {
        while (!this.isEmpty()) {
            Object o = this.getFirst(true);
            System.out.println(o);
        }
    }

    private void dump() {
        System.out.println(this.count + " elements");
        System.out.println("  Queues:");
        for (int i = 0; i < this.byDeadline.length; ++i) {
            System.out.println("    Pri " + this.byDeadline[i].getPriority() + ", deadline " + this.byDeadline[i].getDeadline() + ", " + this.byDeadline[i].count + " items");
        }
    }

    public static void main(String[] args) {
        new PriorityDeadlineQueue(5, 1000L).test();
        System.exit(0);
    }

    public static interface DiscardHook {
        public void itemDiscarded(Object var1);
    }

    public static interface Evaluator {
        public boolean eval(byte var1, Object var2);
    }

    private static class QueueEntry
    extends PooledObject {
        private Object data;

        public QueueEntry() {
            this.poInit();
        }

        @Override
        public void poCleanup() {
            this.data = null;
        }

        public void init(Object obj) {
            this.poNext = null;
            this.data = obj;
        }

        public Object getData() {
            return this.data;
        }

        public QueueEntry getNext() {
            return (QueueEntry)this.poNext;
        }

        public void setNext(QueueEntry qe) {
            this.poNext = qe;
        }
    }

    private static class QueueHead {
        private static ObjectPool pool = ObjectPool.getInstance(QueueEntry.class);
        private QueueEntry head = null;
        private QueueEntry tail = null;
        private long base = 0L;
        private long max;
        private long deadline;
        private long increment;
        private long tQueued = 0L;
        private int count = 0;
        private byte priority;
        private byte effective;

        public QueueHead(byte pri, long inc) {
            this.deadline = this.max = 0x7FFFFFFFFFFFFBFFL + (long)pri;
            this.priority = pri;
            this.increment = inc;
            this.base = inc <= 0L ? this.max : inc * (long)pri;
        }

        public boolean addLast(Object obj) {
            boolean empty = this.head == null;
            QueueEntry ent = this.alloc(obj);
            ent.init(obj);
            this.addEntry(ent);
            return empty;
        }

        private void addEntry(QueueEntry ent) {
            if (this.head == null) {
                this.head = ent;
                this.tQueued = System.currentTimeMillis();
                this.deadline = this.tQueued + this.base;
            } else {
                this.tail.setNext(ent);
            }
            this.tail = ent;
            ent.setNext(null);
            ++this.count;
        }

        public Object getFirst() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            return this.head.getData();
        }

        public Object removeFirst() {
            QueueEntry first = this.removeEntry();
            Object data = first.getData();
            first.init(null);
            first.dispose();
            return data;
        }

        public QueueEntry getSecond() {
            if (this.head == null) {
                return null;
            }
            return this.head.getNext();
        }

        private QueueEntry removeEntry() {
            QueueEntry first = this.head;
            if (first == null) {
                throw new NoSuchElementException();
            }
            this.head = first.getNext();
            first.setNext(null);
            if (this.head == null) {
                this.tail = null;
                this.tQueued = 0L;
                this.deadline = this.max;
            } else {
                this.tQueued = System.currentTimeMillis();
                this.deadline = this.tQueued + this.base;
            }
            --this.count;
            return first;
        }

        public boolean findAndRemove(Object obj) {
            QueueEntry cur = this.head;
            QueueEntry prev = null;
            while (cur != null) {
                QueueEntry next = cur.getNext();
                if (cur.data == obj) {
                    if (prev != null) {
                        prev.setNext(next);
                    } else {
                        this.head = next;
                        if (this.head != null) {
                            this.tQueued = System.currentTimeMillis();
                            this.deadline = this.tQueued + this.base;
                        } else {
                            this.tQueued = 0L;
                            this.deadline = this.max;
                        }
                    }
                    if (this.tail == cur) {
                        this.tail = prev;
                    }
                    cur.dispose();
                    --this.count;
                    return true;
                }
                prev = cur;
                cur = next;
            }
            return false;
        }

        public boolean isQueued(Object obj) {
            for (QueueEntry cur = this.head; cur != null; cur = cur.getNext()) {
                if (cur.data != obj) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public void clear(Collection list) {
            while (this.head != null) {
                QueueEntry ent = this.removeEntry();
                if (list != null) {
                    list.add(ent.getData());
                }
                ent.dispose();
            }
        }

        public long getDeadline() {
            return this.deadline;
        }

        public byte getPriority() {
            return this.priority;
        }

        public byte getEffectivePriority(long now) {
            this.computeEffectivePriority(now);
            return this.effective;
        }

        public byte getEffectivePriority() {
            return this.effective;
        }

        public void computeEffectivePriority(long now) {
            long delta = now - this.tQueued;
            this.effective = (byte)((long)this.priority - delta / this.increment);
            if (this.effective < 0) {
                this.effective = 0;
            }
        }

        public void setDeadlineIncrement(long inc) {
            this.increment = inc;
            this.base = (long)this.priority * inc;
        }

        private QueueEntry alloc(Object obj) {
            QueueEntry ent = (QueueEntry)pool.alloc();
            ent.data = obj;
            return ent;
        }

        public String toString() {
            boolean first = true;
            StringBuffer result = new StringBuffer(256);
            result.append(super.toString() + "pri=" + this.priority + ", deadline=" + this.deadline + ", count=" + this.count + " {");
            for (QueueEntry cur = this.head; cur != null; cur = cur.getNext()) {
                if (!first) {
                    result.append(",");
                }
                first = false;
                result.append(cur.data);
            }
            result.append("}");
            return result.toString();
        }
    }
}

