/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.PriorityDeadlineQueue;
import com.elluminate.util.PriorityScheduler;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;

public class MTPriorityQueue {
    private static final long DFT_PRI_INC = 2000000000000L;
    public static final long DONT_WAIT = -1L;
    public static final long WAIT_FOREVER = 0L;
    public static final long ABORT_IF_BUSY = -2L;
    public static final String DEFAULT_NAME = "PriorityQueue";
    private QueuedProcessor processor = null;
    private PriorityScheduler scheduler = null;
    private PriorityDeadlineQueue queue = null;
    private ProcessingThread[] threadPool = null;
    private int poolSize = 0;
    private volatile int threadPriority = 5;
    private long threadStackSize = 0L;
    private ThreadGroup group = null;
    private String name = null;
    private boolean daemon = false;
    private byte priorityLimit = 0;
    private byte priorityDefault = 0;
    private long priorityInc = 2000000000000L;
    private volatile boolean running = false;
    private volatile boolean shutdown = false;
    private volatile boolean enabled = true;
    private volatile boolean restartable = false;
    private Runnable idle = null;
    private boolean isIdle = true;
    private long timeBecameIdle = 0L;
    private long lastIdleTime = 0L;
    private volatile long idleInterval = 5000L;
    private volatile boolean idleWhenDelayed = false;

    public MTPriorityQueue(QueuedProcessor proc) {
        this(DEFAULT_NAME, proc, null, 1);
    }

    public MTPriorityQueue(QueuedProcessor proc, int nThreads) {
        this(DEFAULT_NAME, proc, null, nThreads);
    }

    public MTPriorityQueue(QueuedProcessor proc, PriorityScheduler sched) {
        this(DEFAULT_NAME, proc, sched, 1);
    }

    public MTPriorityQueue(QueuedProcessor proc, PriorityScheduler sched, int nThreads) {
        this(DEFAULT_NAME, proc, sched, nThreads);
    }

    public MTPriorityQueue(String nm, QueuedProcessor proc) {
        this(nm, proc, null, 1);
    }

    public MTPriorityQueue(String nm, QueuedProcessor proc, int nThreads) {
        this(nm, proc, null, nThreads);
    }

    public MTPriorityQueue(String nm, QueuedProcessor proc, PriorityScheduler sched) {
        this(nm, proc, sched, 1);
    }

    public MTPriorityQueue(String nm, QueuedProcessor proc, PriorityScheduler sched, int nThreads) {
        this.name = nm;
        this.processor = proc;
        this.scheduler = sched;
        this.poolSize = nThreads;
    }

    public void setDaemon(boolean on) {
        if (this.threadPool != null) {
            throw new IllegalThreadStateException("Processing thread pool has been started.");
        }
        this.daemon = on;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setRestartable(boolean on) {
        this.restartable = on;
    }

    public QueuedProcessor getProcessor() {
        return this.processor;
    }

    public PriorityScheduler getScheduler() {
        return this.scheduler;
    }

    public void setThreadGroup(ThreadGroup grp) {
        this.group = grp;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    public int getThreadStackSize() {
        return (int)this.threadStackSize;
    }

    public void setThreadStackSize(int size) {
        this.threadStackSize = size;
    }

    public void setPriorityRange(byte limit) {
        if (this.queue != null) {
            throw new IllegalStateException("MTPriorityQueue priority range must be set before any data is processed");
        }
        this.priorityLimit = limit;
    }

    public byte getPriorityRange() {
        return this.priorityLimit;
    }

    public void setDefaultPriority(byte dft) {
        if (dft < 0) {
            throw new IllegalArgumentException("Default priority " + dft + " is less than 0");
        }
        if (dft > this.priorityLimit) {
            throw new IllegalArgumentException("Default priority " + dft + " is greater than the max of " + this.priorityLimit);
        }
        this.priorityDefault = dft;
    }

    public byte getDefaultPriority() {
        return this.priorityDefault;
    }

    public long getPriorityIncrementInterval() {
        return this.priorityInc;
    }

    public void setPriorityIncrementInterval(long msecs) {
        this.priorityInc = msecs;
        if (this.queue != null) {
            this.queue.setPriorityIncrementInterval(msecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTask(Runnable task) {
        Debug.lockEnter(this, "setidleTask", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            this.idle = task;
            if (!this.enabled) {
                return;
            }
            if (this.idle == null) {
                return;
            }
            this.checkQueue();
            this.startThreads();
            this.notify();
        }
        Debug.lockLeave(this, "setidleTask", null, this);
    }

    public Runnable getIdleTask() {
        return this.idle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleInterval(long interval) {
        this.idleInterval = interval;
        if (this.idle != null) {
            Debug.lockEnter(this, "setIdleInterval", null, this);
            MTPriorityQueue mTPriorityQueue = this;
            synchronized (mTPriorityQueue) {
                if (!this.enabled) {
                    return;
                }
                if (this.idle == null) {
                    return;
                }
                this.checkQueue();
                this.startThreads();
                this.notify();
            }
            Debug.lockLeave(this, "setIdleInterval", null, this);
        }
    }

    public long getIdleInterval() {
        return this.idleInterval;
    }

    public long getIdleTime() {
        long t0 = this.timeBecameIdle;
        if (!this.isIdle || t0 < 1L) {
            return 0L;
        }
        return System.currentTimeMillis() - t0;
    }

    public void setIdleWhenDelayed(boolean whenDelayed) {
        this.idleWhenDelayed = whenDelayed;
    }

    public boolean isIdleWhenDelayed() {
        return this.idleWhenDelayed;
    }

    public boolean isProcessingThread() {
        ProcessingThread[] pool = this.threadPool;
        if (pool == null) {
            return false;
        }
        for (int ix = 0; ix < pool.length; ++ix) {
            if (pool[ix] != Thread.currentThread()) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setContext(Object data) {
        ProcessingThread[] pool = this.threadPool;
        if (pool != null) {
            for (int ix = 0; ix < pool.length; ++ix) {
                ProcessingThread pt = pool[ix];
                if (pt != Thread.currentThread()) continue;
                pt.setContext(data);
                return;
            }
        }
        throw new RuntimeException("Not processing thread");
    }

    public boolean isProcessing() {
        ProcessingThread[] pool = this.threadPool;
        if (pool == null) {
            return false;
        }
        for (int ix = 0; ix < pool.length; ++ix) {
            ProcessingThread pt = pool[ix];
            if (pt == null || !pt.isAlive()) continue;
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return !this.isIdle;
    }

    public boolean process(Object o) {
        return this.process(o, this.priorityDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Object o, byte priority) {
        if (this.shutdown) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        if (priority < 0) {
            priority = 0;
        }
        if (priority > this.priorityLimit) {
            priority = this.priorityLimit;
        }
        Debug.lockEnter(this, "process", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.queue == null) {
                this.checkQueue();
            }
            this.queue.put(priority, o);
            if (this.threadPool == null || !this.running && this.restartable) {
                this.startThreads();
            }
            this.notify();
        }
        Debug.lockLeave(this, "process", null, this);
        return true;
    }

    public void remove(Object o) {
        PriorityDeadlineQueue q = this.queue;
        if (q != null) {
            q.remove(o);
        }
    }

    public boolean contains(Object o) {
        PriorityDeadlineQueue q = this.queue;
        if (q == null) {
            return false;
        }
        return q.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object get() {
        Object next = null;
        long now = System.currentTimeMillis();
        while (next == null && this.running) {
            MTPriorityQueue mTPriorityQueue;
            int q = -1;
            byte priority = this.priorityDefault;
            Object candidate = null;
            int oldClock = 0;
            Debug.lockEnter(this, "get", null, this);
            try {
                mTPriorityQueue = this;
                synchronized (mTPriorityQueue) {
                    if (this.scheduler == null) {
                        candidate = this.queue.getFirst(true);
                        if (candidate != null) {
                            Object object = candidate;
                            return object;
                        }
                        oldClock = this.queue.getChangeClock();
                    } else {
                        now = System.currentTimeMillis();
                        candidate = this.queue.getFirst(false);
                        priority = this.queue.getEffectivePriority(now);
                        oldClock = this.queue.getChangeClock();
                    }
                }
            }
            finally {
                Debug.lockLeave(this, "get", null, this);
            }
            if (candidate != null) {
                long delay = this.scheduler.getProcessDelay(priority, candidate, now);
                if (delay <= 0L) {
                    Debug.lockEnter(this, "get", null, this);
                    try {
                        mTPriorityQueue = this;
                        synchronized (mTPriorityQueue) {
                            if (this.queue.getChangeClock() != oldClock) {
                                continue;
                            }
                            this.queue.getFirst(true);
                            return candidate;
                        }
                    }
                    finally {
                        Debug.lockLeave(this, "get", null, this);
                        continue;
                    }
                }
                this.idleNotify();
                if (this.isIdle && this.idleWhenDelayed && this.idle != null) {
                    long target = System.currentTimeMillis() + delay;
                    long idleDelay2 = this.runIdleTask(false);
                    delay = target - System.currentTimeMillis();
                    delay = Math.min(delay, idleDelay2);
                }
                try {
                    Debug.lockEnter(this, "get", null, this);
                    MTPriorityQueue target = this;
                    synchronized (target) {
                        if (delay > 0L && this.queue.getChangeClock() == oldClock) {
                            this.wait(delay);
                        }
                    }
                    Debug.lockLeave(this, "get", null, this);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            if (this.shutdown) {
                this.runIdleTask(true);
                MTPriorityQueue ex = this;
                synchronized (ex) {
                    this.running = false;
                    this.notifyAll();
                    continue;
                }
            }
            if (this.idle != null) {
                this.idleNotify();
                long idleDelay = this.runIdleTask(false);
                try {
                    Debug.lockEnter(this, "get", null, this);
                    MTPriorityQueue idleDelay2 = this;
                    synchronized (idleDelay2) {
                        if (this.queue.getChangeClock() == oldClock) {
                            this.wait(idleDelay);
                        }
                    }
                    Debug.lockLeave(this, "get", null, this);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            this.idleNotify();
            try {
                Debug.lockEnter(this, "get", null, this);
                MTPriorityQueue idleDelay = this;
                synchronized (idleDelay) {
                    if (this.queue.getChangeClock() == oldClock) {
                        this.wait(120000L);
                    }
                }
                Debug.lockLeave(this, "get", null, this);
            }
            catch (InterruptedException ex) {}
        }
        if (this.running) return next;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Debug.lockEnter(this, "start", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.running) {
                return;
            }
            this.checkQueue();
            this.startThreads();
            this.notify();
        }
        Debug.lockLeave(this, "start", null, this);
    }

    private void startThreads() {
        if (this.threadPool == null || this.threadPool.length != this.poolSize) {
            this.threadPool = new ProcessingThread[this.poolSize];
        }
        this.running = true;
        for (int ix = 0; ix < this.threadPool.length; ++ix) {
            if (this.threadPool[ix] != null) {
                if (this.threadPool[ix].isAlive()) continue;
                this.threadPool[ix] = null;
            }
            ProcessingThreadBody body = new ProcessingThreadBody(ix);
            ProcessingThread t = this.createProcessingThread(this.group, body, this.name, ix);
            if (this.daemon) {
                t.setDaemon(true);
            }
            t.start();
            this.threadPool[ix] = t;
        }
    }

    private void checkQueue() {
        if (this.queue == null) {
            this.queue = new PriorityDeadlineQueue(this.priorityLimit, this.priorityInc);
            this.queue.setDiscardHook(new PriorityDeadlineQueue.DiscardHook(){

                @Override
                public void itemDiscarded(Object o) {
                    MTPriorityQueue.this.processor.discard(o);
                }
            });
        }
    }

    public void stop() {
        this.stop(false);
    }

    public boolean stopIfIdle() {
        this.stop(false, -2L);
        return !this.running;
    }

    public void stop(boolean drain) {
        if (drain) {
            this.stop(drain, 0L);
        } else {
            this.stop(drain, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop(boolean drain, long wait) {
        block32: {
            if (drain) {
                this.shutdown = true;
            } else {
                Debug.lockEnter(this, "stop", null, this);
                var4_3 = this;
                synchronized (var4_3) {
                    if (wait != -2L) ** break block29
                    if (this.isIdle) ** break block30
                }
                Debug.lockLeave(this, "stop", null, this);
                return;
                {
                    if (this.queue != null) ** break block31
                }
                Debug.lockLeave(this, "stop", null, this);
                return;
                {
                    if (this.queue.isEmpty()) ** break block29
                }
                Debug.lockLeave(this, "stop", null, this);
                return;
                {
                    this.clear();
                    this.running = false;
                    break block32;
                    {
                        catch (Throwable var5_5) {
                            throw var5_5;
                        }
                    }
                }
                {
                    finally {
                        Debug.lockLeave(this, "stop", null, this);
                    }
                }
            }
        }
        if (this.isProcessingThread()) {
            return;
        }
        target = System.currentTimeMillis() + wait;
        pool = null;
        Debug.lockEnter(this, "stop", null, this);
        var7_8 = this;
        synchronized (var7_8) {
            pool = this.threadPool;
            this.notifyAll();
        }
        Debug.lockLeave(this, "stop", null, this);
        if (pool == null) {
            return;
        }
        waiting = true;
        while (waiting) {
            if (wait == -1L) {
                waiting = false;
                continue;
            }
            if (wait == 0L) {
                waiting = false;
                for (ix = 0; ix < pool.length; ++ix) {
                    try {
                        if (pool[ix] == null) continue;
                        pool[ix].join();
                        continue;
                    }
                    catch (InterruptedException ex) {
                        waiting = true;
                        continue;
                    }
                    catch (Exception ex) {
                        waiting = true;
                        pool[ix] = null;
                    }
                }
                continue;
            }
            delay = target - System.currentTimeMillis();
            waiting = false;
            for (ix = 0; ix < pool.length && delay > 0L; ++ix) {
                try {
                    if (pool[ix] != null) {
                        pool[ix].join(delay);
                    }
                }
                catch (InterruptedException ex) {
                    waiting = true;
                }
                catch (Exception ex) {
                    waiting = true;
                    pool[ix] = null;
                }
                delay = target - System.currentTimeMillis();
            }
        }
    }

    public void stop(byte minPriority) {
        this.stop(minPriority, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(byte minPriority, long wait) {
        Debug.lockEnter(this, "stop", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.queue != null) {
                this.queue.clear(minPriority);
            }
        }
        Debug.lockLeave(this, "stop", null, this);
        this.stop(true, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Debug.lockEnter(this, "clear", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.queue != null) {
                this.queue.clear();
            }
        }
        Debug.lockLeave(this, "clear", null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAndInterrupt() {
        Debug.lockEnter(this, "clear", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.queue != null) {
                this.queue.clear();
            }
            if (this.threadPool != null) {
                for (int ix = 0; ix < this.threadPool.length; ++ix) {
                    if (this.threadPool[ix] == null || !this.threadPool[ix].isActive()) continue;
                    this.threadPool[ix].interrupt();
                }
            }
        }
        Debug.lockLeave(this, "clear", null, this);
    }

    public boolean isEmpty() {
        PriorityDeadlineQueue q = this.queue;
        if (q == null) {
            return true;
        }
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStatus() {
        StringBuffer result = new StringBuffer(4096);
        Debug.lockEnter(this, "dumpStatus", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            result.append(this.toString() + "\n");
            result.append("Queues:  ");
            result.append(this.queue.toString());
            result.append("\nThread Pool:\n");
            if (this.threadPool != null) {
                for (int ix = 0; ix < this.threadPool.length; ++ix) {
                    result.append("  " + ix + ": " + this.threadPool[ix] + "\n");
                }
            }
        }
        Debug.lockLeave(this, "dumpStatus", null, this);
        LogSupport.message(this, "dumpStatus", result.toString());
    }

    public String toString() {
        long t = System.currentTimeMillis();
        return super.toString() + " " + this.name + " proc=" + this.processor + " sched=" + this.scheduler + " idle=" + this.idle + " idleInterval=" + this.idleInterval + (this.idleWhenDelayed ? " idleWhenDelayed" : "") + " sinceIdleTask=" + (t - this.lastIdleTime) + " prio=" + this.threadPriority + " #threads=" + this.poolSize + " tgrp=" + this.group + " pool=[" + this.getPoolStatus() + "]" + (this.isIdle ? " idle for " + (t - this.timeBecameIdle) : "") + (this.running ? " running" : " stopped") + (this.shutdown ? " shutdown" : "");
    }

    private String getPoolStatus() {
        ProcessingThread[] pool = this.threadPool;
        if (pool == null) {
            return "<<null>>";
        }
        StringBuffer result = new StringBuffer(256);
        for (int ix = 0; ix < pool.length; ++ix) {
            if (ix > 0) {
                result.append(',');
            }
            ProcessingThread cur = pool[ix];
            result.append(cur);
        }
        return result.toString();
    }

    private ProcessingThread createProcessingThread(ThreadGroup grp, ProcessingThreadBody body, String baseName, int idx) {
        if (this.threadStackSize > 0L) {
            return new ProcessingThread(grp, body, baseName + " #" + (idx + 1), this.threadStackSize);
        }
        return new ProcessingThread(grp, body, baseName + " #" + (idx + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runIdleTask(boolean force) {
        Runnable task = null;
        Debug.lockEnter(this, "runIdleTask", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.idle == null) {
                return this.idleInterval;
            }
            if (!this.isIdle && !force) {
                return this.idleInterval;
            }
            long dt = this.lastIdleTime + this.idleInterval - System.currentTimeMillis();
            if (!force && dt > 0L) {
                return dt;
            }
            task = this.idle;
            this.lastIdleTime = System.currentTimeMillis();
        }
        Debug.lockLeave(this, "runIdleTask", null, this);
        if (task != null) {
            try {
                task.run();
            }
            catch (Throwable t) {
                LogSupport.exception(this, "runIdleTask", t, true);
            }
        }
        return this.idleInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idleNotify() {
        Debug.lockEnter(this, "idleNotify", null, this);
        MTPriorityQueue mTPriorityQueue = this;
        synchronized (mTPriorityQueue) {
            if (this.isIdle) {
                return;
            }
            Thread t = Thread.currentThread();
            if (t instanceof ProcessingThread) {
                ((ProcessingThread)t).setIdle(true);
                if (this.threadPool != null) {
                    for (int ix = 0; ix < this.threadPool.length; ++ix) {
                        ProcessingThread pt = this.threadPool[ix];
                        if (pt == null || pt.isIdle()) continue;
                        return;
                    }
                }
            }
            this.isIdle = true;
            this.timeBecameIdle = System.currentTimeMillis();
        }
        Debug.lockLeave(this, "idleNotify", null, this);
        try {
            this.processor.idle();
        }
        catch (Throwable ex) {
            LogSupport.exception(this, "idleNotify", ex, true);
        }
    }

    private class ProcessingThread
    extends WorkerThread {
        ProcessingThreadBody body;

        private ProcessingThread(ThreadGroup grp, ProcessingThreadBody body, String name) {
            super(grp, (Runnable)body, name, MTPriorityQueue.this.threadPriority);
            this.body = null;
            this.body = body;
        }

        private ProcessingThread(ThreadGroup grp, ProcessingThreadBody body, String name, long stack) {
            super(grp, (Runnable)body, name, stack, MTPriorityQueue.this.threadPriority);
            this.body = null;
            this.body = body;
        }

        public boolean isIdle() {
            return this.body == null ? true : this.body.idle;
        }

        public void setIdle(boolean idle) {
            this.body.idle = idle;
        }

        public boolean isActive() {
            return this.body == null ? false : this.body.active;
        }

        public Object getContext() {
            return this.body == null ? null : this.body.context;
        }

        public void setContext(Object ctx) {
            this.body.context = ctx;
        }

        int getSlotNum() {
            return this.body == null ? -1 : this.body.slot;
        }

        @Override
        public String toString() {
            return super.toString() + " slot=" + this.getSlotNum() + " context=" + this.getContext() + (this.isIdle() ? " idle" : "") + (this.isActive() ? " active" : "") + (this.isInterrupted() ? " interrupted" : "") + (!this.isAlive() ? " *** DEAD ***" : "");
        }
    }

    private class ProcessingThreadBody
    implements Runnable {
        volatile boolean active = false;
        volatile boolean idle = false;
        int slot = -1;
        volatile Object context = null;

        ProcessingThreadBody(int slot) {
            this.slot = slot;
        }

        public String toString() {
            return super.toString() + " thread: " + Thread.currentThread().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int tp = Thread.currentThread().getPriority();
            Debug.lockEnter(this, "run", null, MTPriorityQueue.this);
            MTPriorityQueue mTPriorityQueue = MTPriorityQueue.this;
            synchronized (mTPriorityQueue) {
            }
            Debug.lockLeave(this, "run", null, MTPriorityQueue.this);
            Object o = null;
            try {
                while (MTPriorityQueue.this.running) {
                    if (tp != MTPriorityQueue.this.threadPriority) {
                        try {
                            Thread.currentThread().setPriority(MTPriorityQueue.this.threadPriority);
                            tp = MTPriorityQueue.this.threadPriority;
                        }
                        catch (Throwable t) {
                            MTPriorityQueue.this.threadPriority = tp;
                            LogSupport.message(this, "run", "Could not change thread priority:\n" + t);
                        }
                    }
                    if ((o = MTPriorityQueue.this.get()) == null) continue;
                    if (MTPriorityQueue.this.scheduler != null) {
                        MTPriorityQueue.this.scheduler.processingNotify(o);
                    }
                    try {
                        Debug.lockEnter(this, "run", null, MTPriorityQueue.this);
                        try {
                            MTPriorityQueue t = MTPriorityQueue.this;
                            synchronized (t) {
                                Thread.interrupted();
                                this.active = true;
                                this.idle = false;
                                MTPriorityQueue.this.isIdle = false;
                                MTPriorityQueue.this.lastIdleTime = 0L;
                                MTPriorityQueue.this.timeBecameIdle = 0L;
                            }
                        }
                        finally {
                            Debug.lockLeave(this, "run", null, MTPriorityQueue.this);
                        }
                        MTPriorityQueue.this.processor.process(o, this.context);
                        this.active = false;
                    }
                    catch (Throwable t) {
                        this.active = false;
                        LogSupport.exception(this, "run", t, true, "While processing: " + o);
                    }
                    o = null;
                }
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
            finally {
                if (MTPriorityQueue.this.running) {
                    LogSupport.message(this, "run", "Unexpected termination of processing thread: " + this);
                    if (o != null) {
                        LogSupport.message(this, "run", "  while processing: " + o);
                    }
                }
            }
            this.context = null;
            Thread curThread = Thread.currentThread();
            Debug.lockEnter(this, "run", null, MTPriorityQueue.this);
            try {
                MTPriorityQueue mTPriorityQueue2 = MTPriorityQueue.this;
                synchronized (mTPriorityQueue2) {
                    boolean lastOneOut = false;
                    ProcessingThread[] pool = MTPriorityQueue.this.threadPool;
                    if (pool != null && this.slot < pool.length && this.slot >= 0 && pool[this.slot] == curThread) {
                        pool[this.slot] = null;
                        lastOneOut = true;
                        for (int i = 0; i < pool.length; ++i) {
                            if (pool[i] == null) continue;
                            lastOneOut = false;
                            break;
                        }
                    }
                    if (lastOneOut && MTPriorityQueue.this.queue != null) {
                        MTPriorityQueue.this.queue.clear();
                    }
                }
            }
            finally {
                Debug.lockLeave(this, "run", null, MTPriorityQueue.this);
            }
        }
    }
}

