/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.CircularWorkQueue;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerPool;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;

public class LightweightTimerQueue
implements Runnable {
    public static final int SIZE_INCREMENT = 16;
    private Thread thread = null;
    private Object heapLock = new Object();
    private LightweightTimer[] heap = null;
    private int heapSize = 0;
    private boolean dumpQueue = false;
    private CircularWorkQueue wQueue = null;
    private WorkerPool wPool = null;
    private boolean running = true;

    public LightweightTimerQueue() {
        this(16, 256, 4, "LightweightTimer", null);
    }

    public LightweightTimerQueue(ThreadGroup grp) {
        this(16, 256, 4, "LightweightTimer", grp);
    }

    public LightweightTimerQueue(int initial, int wqSize, int wpSize, String wpName, ThreadGroup grp) {
        this.thread = new WorkerThread(this, wpName + "Queue", 6);
        this.heap = new LightweightTimer[initial];
        this.wQueue = new CircularWorkQueue(wqSize);
        this.wPool = new WorkerPool(wpName + "Worker", this.wQueue, wpSize, grp);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.heapLock;
        synchronized (object) {
            this.dumpQueue = true;
            this.heapLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LightweightTimer getNextTask() {
        LightweightTimer task = null;
        Debug.lockEnter(this, "getNextTask", "heapLock", this.heapLock);
        Object object = this.heapLock;
        synchronized (object) {
            while (this.running) {
                if (this.dumpQueue) {
                    for (int i = 0; i < this.heapSize; ++i) {
                        LogSupport.message(this, "run", this.heap[i].toString());
                    }
                    this.dumpQueue = false;
                }
                if (this.heapSize == 0) {
                    try {
                        this.heapLock.wait();
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                long now = System.currentTimeMillis();
                task = this.heap[0];
                long delay = task.runAt - now;
                if (delay <= 0L) {
                    if (this.heapSize > 1) {
                        this.heap[0] = this.heap[--this.heapSize];
                        this.heap[0].heapIndex = 0;
                        this.heapPushDown(0);
                    } else {
                        this.heapSize = 0;
                    }
                    this.heap[this.heapSize] = null;
                    task.heapIndex = -1;
                    break;
                }
                task = null;
                try {
                    this.heapLock.wait(delay);
                }
                catch (InterruptedException ex) {}
            }
        }
        Debug.lockLeave(this, "getNextTask", "heapLock", this.heapLock);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(LightweightTimer t, long at, long interval) {
        Debug.lockEnter(this, "scheduleTask", "heapLock", this.heapLock);
        Object object = this.heapLock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            if (t.heapIndex >= 0) {
                this.cancelTask(t);
            }
            t.runAt = at;
            t.interval = interval;
            if (this.heap.length == this.heapSize) {
                LightweightTimer[] reheap = new LightweightTimer[this.heap.length + 16];
                System.arraycopy(this.heap, 0, reheap, 0, this.heapSize);
                this.heap = reheap;
            }
            this.heap[this.heapSize] = t;
            t.heapIndex = this.heapSize;
            this.heapPushUp(this.heapSize);
            ++this.heapSize;
            if (t.heapIndex == 0) {
                this.heapLock.notify();
            }
        }
        Debug.lockLeave(this, "scheduleTask", "heapLock", this.heapLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelTask(LightweightTimer t) {
        boolean cancelled = false;
        Debug.lockEnter(this, "cancelTask", "heapLock", this.heapLock);
        Object object = this.heapLock;
        synchronized (object) {
            if (t.heapIndex >= 0) {
                int last;
                int curr = t.heapIndex;
                if ((last = --this.heapSize) > curr) {
                    this.heap[curr] = this.heap[last];
                    this.heap[curr].heapIndex = curr;
                    this.heapPushDown(curr);
                    if (curr == 0) {
                        this.heapLock.notify();
                    }
                }
                this.heap[last] = null;
                t.heapIndex = -1;
                t.runAt = -1L;
                t.interval = 0L;
                cancelled = true;
            } else if (t.interval > 0L) {
                t.runAt = -1L;
                t.interval = 0L;
                cancelled = true;
            }
        }
        Debug.lockLeave(this, "cancelTask", "heapLock", this.heapLock);
        return cancelled;
    }

    private void heapPushDown(int i) {
        int l = i + i + 1;
        int r = l + 1;
        int min = i;
        if (l < this.heapSize && this.heap[l].runAt < this.heap[min].runAt) {
            min = l;
        }
        if (r < this.heapSize && this.heap[r].runAt < this.heap[min].runAt) {
            min = r;
        }
        if (min != i) {
            LightweightTimer t = this.heap[i];
            this.heap[i] = this.heap[min];
            this.heap[min] = t;
            this.heap[i].heapIndex = i;
            this.heap[min].heapIndex = min;
            this.heapPushDown(min);
        }
    }

    private void heapPushUp(int i) {
        if (i == 0) {
            return;
        }
        int p = (i - 1) / 2;
        if (this.heap[p].runAt > this.heap[i].runAt) {
            LightweightTimer t = this.heap[p];
            this.heap[p] = this.heap[i];
            this.heap[i] = t;
            this.heap[p].heapIndex = p;
            this.heap[i].heapIndex = i;
            this.heapPushUp(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted() && this.running) {
            LightweightTimer task = this.getNextTask();
            if (task == null) continue;
            this.execute(task);
            Object object = this.heapLock;
            synchronized (object) {
                long delta = task.interval;
                if (delta > 0L) {
                    long at;
                    long now = System.currentTimeMillis();
                    for (at = task.runAt; at <= now; at += delta) {
                    }
                    this.scheduleTask(task, at, delta);
                }
            }
        }
        this.thread = null;
    }

    public void execute(LightweightTimer timer) {
        try {
            switch (timer.context) {
                case 0: {
                    this.wQueue.execute(timer, (short)1);
                    break;
                }
                case 1: {
                    this.wQueue.execute(timer);
                    break;
                }
                case 2: {
                    SwingRunnerSupport.invokeLater(timer);
                }
            }
        }
        catch (Throwable t) {
            LogSupport.proxyException(timer.forGroup, timer.forThread, this, "execute", t, true);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.heapLock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                for (int i = 0; i < this.heapSize; ++i) {
                    this.heap[i].runAt = -1L;
                    this.heap[i].interval = 0L;
                    this.heap[i].heapIndex = -1;
                    this.heap[i] = null;
                }
                this.heapSize = 0;
                this.thread.notify();
            }
        }
    }
}

