/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.LightweightTimerQueue;
import com.elluminate.util.log.LogSupport;

public class LightweightTimer
implements Runnable {
    public static final byte CONTEXT_WORKER_STRICT = 0;
    public static final byte CONTEXT_WORKER = 1;
    public static final byte CONTEXT_SWING = 2;
    private static Object queueLock = new Object();
    private static LightweightTimerQueue defaultQueue = null;
    private LightweightTimerQueue queue = null;
    byte context;
    private Runnable target = null;
    String forThread = null;
    String forGroup = null;
    long runAt = 0L;
    long interval = 0L;
    int heapIndex = -1;

    public LightweightTimer(Runnable r) {
        this(1, r);
    }

    public LightweightTimer(byte kind, Runnable r) {
        Thread t = Thread.currentThread();
        LightweightTimer.forceStart();
        this.queue = defaultQueue;
        this.context = kind;
        this.forThread = t.getName();
        this.forGroup = t.getThreadGroup().getName();
        if (r == null) {
            throw new RuntimeException("Null Runnable supplied to LightweightTimer constuctor");
        }
        this.target = r;
    }

    public LightweightTimer(LightweightTimerQueue q, byte kind, Runnable r) {
        Thread t = Thread.currentThread();
        this.queue = q;
        this.context = kind;
        this.forThread = t.getName();
        this.forGroup = t.getThreadGroup().getName();
        if (r == null) {
            throw new RuntimeException("Null Runnable supplied to LightweightTimer constuctor");
        }
        this.target = r;
    }

    public long getRunTime() {
        return this.runAt;
    }

    public void invoke() {
        this.queue.execute(this);
    }

    public boolean isScheduled() {
        return this.heapIndex >= 0 || this.interval > 0L;
    }

    public void scheduleAt(long time) {
        this.forThread = Thread.currentThread().getName();
        this.queue.cancelTask(this);
        this.queue.scheduleTask(this, time, 0L);
    }

    public void scheduleIn(long delta) {
        this.forThread = Thread.currentThread().getName();
        this.scheduleAt(System.currentTimeMillis() + delta);
    }

    public void scheduleEvery(long delta) {
        this.forThread = Thread.currentThread().getName();
        this.queue.cancelTask(this);
        this.queue.scheduleTask(this, System.currentTimeMillis() + delta, delta);
    }

    public boolean cancel() {
        boolean cancelled = this.queue.cancelTask(this);
        return cancelled;
    }

    @Override
    public void run() {
        try {
            this.target.run();
        }
        catch (Throwable t) {
            LogSupport.proxyException(this.forGroup, this.forThread, this, "run", t, true, "Executing timer");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("[");
        buf.append(this.target.getClass().getName());
        switch (this.context) {
            case 1: {
                buf.append(",WORKER,");
                break;
            }
            case 2: {
                buf.append(",SWING,");
            }
        }
        if (this.heapIndex < 0) {
            buf.append("unscheduled,");
        } else if (this.interval > 0L) {
            buf.append("every ");
            buf.append(this.interval);
            buf.append(",");
            buf.append(this.runAt);
            buf.append(",");
        } else {
            buf.append("at ");
            buf.append(this.runAt);
            buf.append(",");
        }
        buf.append(this.forThread);
        buf.append('.');
        buf.append(this.forGroup);
        buf.append("]");
        return buf.toString();
    }

    public static boolean forceStart() {
        return LightweightTimer.forceStart(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceStart(ThreadGroup grp) {
        Object object = queueLock;
        synchronized (object) {
            if (defaultQueue == null) {
                defaultQueue = new LightweightTimerQueue(grp);
            }
        }
        return defaultQueue.isRunning();
    }

    public static void dumpQueue() {
        LightweightTimer.forceStart(null);
        defaultQueue.dump();
    }
}

