/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;

public class JWSUtils {
    private static boolean loadedOK;
    private static Class jctrl;
    private static Class cctrl;
    private static Class cwin;
    private static Class helper;
    private static Method setControllerMethod;
    private static Method displayVersionMethod;
    private static Method displayHelpMethod;
    private static Method showConsoleIfEnabledMethod;
    private static Method getControllerMethod;
    private static Method getConsoleMethod;
    private static Method setConsoleMethod;
    private static Method createConsoleMethod;
    private static Method isConsoleVisibleMethod;
    private static Method showConsoleMethod;
    private static Method appendMethod;
    private static PrintStream tapStream;

    public static boolean isConsoleAvailable() {
        return loadedOK;
    }

    public static void showConsole() {
        if (!loadedOK) {
            return;
        }
        try {
            Object controller = null;
            Object console = null;
            controller = getControllerMethod.invoke(null, new Object[0]);
            console = getConsoleMethod.invoke(controller, new Object[0]);
            if (console == null) {
                console = createConsoleMethod.invoke(null, controller);
                setConsoleMethod.invoke(controller, console);
                setControllerMethod.invoke(null, controller);
                Object vis = isConsoleVisibleMethod.invoke(console, new Object[0]);
                showConsoleMethod.invoke(console, Boolean.TRUE);
                Runnable redir = new Runnable(){

                    @Override
                    public void run() {
                        if (tapStream == null) {
                            tapStream = new PrintStream(new RedirectStream(), true);
                            LogSupport.addSystemTap(tapStream);
                        }
                        try {
                            String s = displayVersionMethod.invoke(null, new Object[0]) + "\n";
                            if (s != null) {
                                tapStream.println(s);
                            }
                            if ((s = displayHelpMethod.invoke(null, new Object[0]) + "\n") != null) {
                                tapStream.println(s);
                            }
                        }
                        catch (Exception ex) {
                            LogSupport.message(this, "run", Debug.getStackTrace(ex));
                        }
                        LogSupport.replayHistory(tapStream);
                    }
                };
                LightweightTimer t = new LightweightTimer(2, redir);
                t.scheduleIn(200L);
            } else {
                Object vis = isConsoleVisibleMethod.invoke(console, new Object[0]);
                showConsoleMethod.invoke(console, Boolean.TRUE);
            }
        }
        catch (Throwable ignored) {
            LogSupport.message(JWSUtils.class, "showConsole", Debug.getStackTrace(ignored));
        }
    }

    public static File getCacheDir() {
        File jar = JWSUtils.getJarForClass(JWSUtils.class);
        if (jar == null) {
            return null;
        }
        String parent = jar.getParent();
        if (parent == null) {
            return null;
        }
        File result = new File(parent);
        if (!result.isDirectory()) {
            return null;
        }
        return result;
    }

    public static File getJarForClass(Class c) {
        File result = null;
        try {
            int ref;
            URL classURL = c.getResource("/" + c.getName().replace('.', '/') + ".class");
            if (!"jar".equalsIgnoreCase(classURL.getProtocol())) {
                return null;
            }
            String path = classURL.getFile();
            if (path == null) {
                return null;
            }
            int hash = path.indexOf(35);
            if (hash >= 0) {
                path = path.substring(0, hash);
            }
            if ((ref = path.lastIndexOf(63)) >= 0) {
                path = path.substring(0, ref);
            }
            if (!path.startsWith("file:")) {
                return null;
            }
            int pos = (path = path.substring(5)).indexOf(33);
            if (pos < 0 || pos >= path.length()) {
                return null;
            }
            path = URLDecoder.decode(path.substring(0, pos), "US-ASCII");
            result = new File(path);
        }
        catch (Throwable t) {
            LogSupport.exception(JWSUtils.class, "getCacheDir", t, true);
            result = null;
        }
        return result;
    }

    static {
        block2: {
            loadedOK = false;
            jctrl = null;
            cctrl = null;
            cwin = null;
            helper = null;
            setControllerMethod = null;
            displayVersionMethod = null;
            displayHelpMethod = null;
            showConsoleIfEnabledMethod = null;
            getControllerMethod = null;
            getConsoleMethod = null;
            setConsoleMethod = null;
            createConsoleMethod = null;
            isConsoleVisibleMethod = null;
            showConsoleMethod = null;
            appendMethod = null;
            tapStream = null;
            try {
                jctrl = Class.forName("com.sun.javaws.util.JavawsConsoleController");
                cctrl = Class.forName("com.sun.deploy.util.ConsoleController");
                cwin = Class.forName("com.sun.deploy.util.ConsoleWindow");
                helper = Class.forName("com.sun.deploy.util.ConsoleHelper");
                setControllerMethod = helper.getMethod("setConsoleController", cctrl);
                displayVersionMethod = helper.getMethod("displayVersion", new Class[0]);
                displayHelpMethod = helper.getMethod("displayHelp", new Class[0]);
                getControllerMethod = jctrl.getMethod("getInstance", new Class[0]);
                getConsoleMethod = jctrl.getMethod("getConsole", new Class[0]);
                setConsoleMethod = jctrl.getMethod("setConsole", cwin);
                createConsoleMethod = cwin.getMethod("create", cctrl);
                isConsoleVisibleMethod = cwin.getMethod("isConsoleVisible", new Class[0]);
                showConsoleMethod = cwin.getMethod("showConsole", Boolean.TYPE);
                appendMethod = cwin.getMethod("append", String.class);
                loadedOK = true;
            }
            catch (Throwable t) {
                loadedOK = false;
                if (!UtilDebug.JWS_CONSOLE.show()) break block2;
                LogSupport.message(JWSUtils.class, "<clinit>", Debug.getStackTrace(t));
            }
        }
    }

    private static class RedirectStream
    extends OutputStream {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1024);
        Object[] appendArgs = new Object[1];

        RedirectStream() {
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.buf.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.buf.write(b, off, len);
        }

        @Override
        public synchronized void flush() throws IOException {
            this.buf.flush();
            byte[] data = this.buf.toByteArray();
            this.buf.reset();
            String str = new String(data);
            Object controller = null;
            Object console = null;
            try {
                controller = getControllerMethod.invoke(null, new Object[0]);
                console = getConsoleMethod.invoke(controller, new Object[0]);
                appendMethod.invoke(console, str);
            }
            catch (Throwable t) {
                throw new IOException("Failed to send to console: " + t);
            }
        }
    }
}

