/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.I18n;
import com.elluminate.util.StringUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class I18nMessage {
    private static final String STRING_ENCODER_ESCAPES = ":,()";
    private I18n i18n = null;
    private Class cls = null;
    private String className = null;
    private String msgName = null;
    private String[] arguments = null;
    private String formatted = null;
    private String unformatted = null;

    public I18nMessage(Object context, String msg, String ... args) {
        this.className = context == null ? null : (context instanceof Class ? ((Class)context).getName() : (context instanceof String ? (String)context : context.getClass().getName()));
        this.msgName = msg;
        if (args == null) {
            this.arguments = new String[0];
        } else {
            this.arguments = new String[args.length];
            System.arraycopy(args, 0, this.arguments, 0, args.length);
        }
    }

    public I18nMessage(Object context, String msg) {
        this(context, msg, null);
    }

    public I18nMessage() {
        this(null, "", null);
    }

    public I18nMessage(String msg) {
        this(null, msg, null);
    }

    public I18nMessage(String msg, String[] args) {
        this(null, msg, args);
    }

    public I18nMessage(DataInputStream istr) throws IOException {
        this.className = istr.readUTF();
        if (this.className.length() == 0) {
            this.className = null;
        }
        this.msgName = istr.readUTF();
        int count = istr.readShort();
        this.arguments = new String[count];
        for (int i = 0; i < count; ++i) {
            this.arguments[i] = istr.readUTF();
        }
    }

    public String toString() {
        if (this.formatted == null) {
            this.doFormat();
        }
        return this.formatted;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof I18nMessage) {
            return this.getUnformattedString().equals(((I18nMessage)obj).getUnformattedString());
        }
        return false;
    }

    public int hashCode() {
        return this.getUnformattedString().hashCode();
    }

    public static I18nMessage read(DataInputStream istr) throws IOException {
        return new I18nMessage(istr);
    }

    public void write(DataOutputStream ostr) throws IOException {
        if (this.className != null) {
            ostr.writeUTF(this.className);
        } else {
            ostr.writeUTF("");
        }
        ostr.writeUTF(this.msgName);
        ostr.writeShort(this.arguments.length);
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) {
                ostr.writeUTF("");
                continue;
            }
            ostr.writeUTF(this.arguments[i]);
        }
    }

    public String getUnformattedString() {
        if (this.unformatted == null) {
            StringBuffer result = new StringBuffer();
            result.append(this.className);
            result.append(":");
            result.append(this.msgName);
            result.append("(");
            for (int ix = 0; ix < this.arguments.length; ++ix) {
                if (ix > 0) {
                    result.append(",");
                }
                result.append(this.arguments[ix]);
            }
            result.append(")");
            this.unformatted = result.toString();
        }
        return this.unformatted;
    }

    public String encodeToString() {
        StringBuffer result = new StringBuffer();
        result.append(StringUtils.escape(this.className, STRING_ENCODER_ESCAPES));
        result.append(":");
        result.append(StringUtils.escape(this.msgName, STRING_ENCODER_ESCAPES));
        result.append("(");
        for (int ix = 0; ix < this.arguments.length; ++ix) {
            if (ix > 0) {
                result.append(",");
            }
            result.append(StringUtils.escape(this.arguments[ix], STRING_ENCODER_ESCAPES));
        }
        result.append(")");
        return result.toString();
    }

    public static I18nMessage decodeFromString(String encoded) {
        int pos = 0;
        ArrayList<String> args = new ArrayList<String>();
        int idx = StringUtils.indexOfEscaped(encoded, ":");
        if (idx < 0) {
            throw new IllegalArgumentException("Malformed encoding, no message: " + encoded);
        }
        String cName = StringUtils.unescape(encoded.substring(0, idx));
        pos = idx + 1;
        if ((idx = StringUtils.indexOfEscaped(encoded, "(", pos)) < 0) {
            throw new IllegalArgumentException("Malformed encoding at " + pos + ", no argument list: " + encoded);
        }
        String msg = StringUtils.unescape(encoded.substring(pos, idx));
        pos = idx + 1;
        if ((idx = StringUtils.indexOfEscaped(encoded, ")", pos)) < 0) {
            throw new IllegalArgumentException("Malformed encoding at " + pos + ", argument list not terminated: " + encoded);
        }
        if (idx < encoded.length() - 1) {
            throw new IllegalArgumentException("Malformed encoding at " + idx + ", unexpected text: " + encoded);
        }
        String argList = StringUtils.unescape(encoded.substring(pos, idx));
        pos = 0;
        while (pos < argList.length()) {
            idx = StringUtils.indexOfEscaped(argList, ")", pos);
            if (idx >= 0) continue;
            args.add(StringUtils.unescape(argList.substring(pos)));
        }
        String[] argStrings = args.toArray(new String[args.size()]);
        return new I18nMessage(cName, msg, argStrings);
    }

    Class getContext() {
        if (this.cls == null && this.className != null) {
            try {
                this.cls = Class.forName(this.className);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return this.cls;
    }

    String getMessageName() {
        return this.msgName;
    }

    private void doFormat() {
        if (this.cls == null && this.className != null) {
            try {
                this.cls = Class.forName(this.className);
            }
            catch (Throwable t) {
                this.fallback("Context class " + this.className + " not found.");
                return;
            }
        }
        if (this.i18n == null && this.cls != null) {
            this.i18n = I18n.create(this.cls);
        }
        if (this.i18n != null) {
            try {
                this.formatted = this.i18n.getFormattedString(this.msgName, (Object[])this.arguments);
            }
            catch (Throwable t) {
                this.fallback("Message not found in Strings.properties.");
                return;
            }
        }
        try {
            this.formatted = MessageFormat.format(this.msgName, this.arguments);
        }
        catch (Throwable t) {
            this.fallback("Error formatting message: " + t);
        }
    }

    private void fallback(String reason) {
        Object[] args = new String[this.arguments.length + 2];
        StringBuffer format = new StringBuffer();
        args[0] = this.msgName;
        args[1] = reason;
        System.arraycopy(this.arguments, 0, args, 2, this.arguments.length);
        format.append("Unable to localize message: {0}(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                format.append(',');
            }
            format.append('{');
            format.append(i + 2);
            format.append('}');
        }
        format.append(")\n  {1}");
        this.formatted = MessageFormat.format(format.toString(), args);
    }
}

