/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.EncodingException;

public class Base64 {
    private static final char[] BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static byte[] decode(String encoded) throws EncodingException {
        int nChars = encoded.length();
        int nBase64 = 0;
        block9: for (int i = 0; i < nChars; ++i) {
            char c = encoded.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                default: {
                    ++nBase64;
                }
            }
        }
        if (nBase64 % 4 != 0) {
            throw new EncodingException("Invalid length of BASE64 encoded value: " + nChars);
        }
        int nBytes = nBase64 / 4 * 3;
        int nWritten = 0;
        int block = 0;
        int blockLen = 0;
        if (encoded.endsWith("==")) {
            nBytes -= 2;
        } else if (encoded.endsWith("=")) {
            --nBytes;
        }
        byte[] raw = new byte[nBytes];
        block10: for (int i = 0; i < nChars; ++i) {
            char c = encoded.charAt(i);
            int v = 0;
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            if (c >= 'A' && c <= 'Z') {
                v = c - 65;
            } else if (c >= 'a' && c <= 'z') {
                v = c - 97 + 26;
            } else if (c >= '0' && c <= '9') {
                v = c - 48 + 52;
            } else if (c == '+') {
                v = 62;
            } else if (c == '/') {
                v = 63;
            } else {
                if (c == '=' && nWritten == nBytes) break;
                throw new EncodingException("Invalid character '" + c + "' in BASE64 encoded value.");
            }
            block |= v << 6 * (3 - blockLen++);
            switch (blockLen) {
                case 1: {
                    continue block10;
                }
                case 2: {
                    raw[nWritten++] = (byte)(block >> 16 & 0xFF);
                    continue block10;
                }
                case 3: {
                    raw[nWritten++] = (byte)(block >> 8 & 0xFF);
                    continue block10;
                }
                case 4: {
                    blockLen = 0;
                    raw[nWritten++] = (byte)(block & 0xFF);
                    block = 0;
                }
            }
        }
        return raw;
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        Base64.encode(raw, encoded);
        return encoded.toString();
    }

    public static String encode(byte[] raw, int len) {
        StringBuffer encoded = new StringBuffer();
        Base64.encode(raw, len, encoded);
        return encoded.toString();
    }

    public static void encode(byte[] raw, StringBuffer encoded) {
        Base64.encode(raw, -1, encoded);
    }

    public static void encode(byte[] raw, int len, StringBuffer encoded) {
        int line = 0;
        for (int i = 0; i < raw.length; i += 3) {
            int left = Math.min(raw.length - i, 3);
            int block = 0;
            for (int c = 0; c < left; ++c) {
                int mask = raw[i + c] & 0xFF;
                block |= mask << (2 - c) * 8;
            }
            switch (left) {
                case 1: {
                    encoded.append(BASE64[block >> 18 & 0x3F]);
                    encoded.append(BASE64[block >> 12 & 0x3F]);
                    encoded.append("==");
                    break;
                }
                case 2: {
                    encoded.append(BASE64[block >> 18 & 0x3F]);
                    encoded.append(BASE64[block >> 12 & 0x3F]);
                    encoded.append(BASE64[block >> 6 & 0x3F]);
                    encoded.append("=");
                    break;
                }
                default: {
                    encoded.append(BASE64[block >> 18 & 0x3F]);
                    encoded.append(BASE64[block >> 12 & 0x3F]);
                    encoded.append(BASE64[block >> 6 & 0x3F]);
                    encoded.append(BASE64[block & 0x3F]);
                }
            }
            if ((line += 4) < len || len <= 0) continue;
            encoded.append('\n');
            line = 0;
        }
    }
}

