/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import java.util.StringTokenizer;
import java.util.Vector;

public final class VersionSupport {
    private static final String PREFIX_FLAG = "*";
    private static final String GREATER_FLAG = "+";

    private VersionSupport() {
    }

    public static boolean matchVersion(String testVersion, String vsVersion) {
        if (testVersion == null || testVersion.equals("")) {
            return false;
        }
        if (vsVersion == null || vsVersion.equals("")) {
            return true;
        }
        Vector test = VersionSupport.parseVersion(testVersion);
        StringTokenizer parser = new StringTokenizer(vsVersion);
        block0: while (parser.hasMoreTokens()) {
            int ix;
            boolean prefix = false;
            boolean greater = false;
            String vsText = parser.nextToken();
            if (vsText.equals(PREFIX_FLAG) || vsText.equals(GREATER_FLAG)) {
                return true;
            }
            if (vsText.endsWith(PREFIX_FLAG)) {
                vsText = vsText.substring(0, vsText.length() - 1);
                prefix = true;
            } else if (vsText.endsWith(GREATER_FLAG)) {
                vsText = vsText.substring(0, vsText.length() - 1);
                greater = true;
            }
            Vector vs = VersionSupport.parseVersion(vsText);
            Vector testCopy = (Vector)test.clone();
            while (testCopy.size() < vs.size()) {
                testCopy.addElement("0");
            }
            if (!prefix) {
                while (vs.size() < testCopy.size()) {
                    vs.addElement("");
                }
            }
            if (greater) {
                for (ix = 0; ix < vs.size(); ++ix) {
                    int cmp = VersionSupport.compareTuples((String)testCopy.elementAt(ix), (String)vs.elementAt(ix));
                    if (cmp > 0) {
                        return true;
                    }
                    if (cmp < 0) continue block0;
                    if (ix != vs.size() - 1) continue;
                    return true;
                }
                continue;
            }
            for (ix = 0; ix < vs.size() && VersionSupport.compareTuples((String)testCopy.elementAt(ix), (String)vs.elementAt(ix)) == 0; ++ix) {
                if (ix != vs.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    private static Vector parseVersion(String version) {
        Vector<String> result = new Vector<String>();
        StringTokenizer parser = new StringTokenizer(version, ".-_");
        while (parser.hasMoreTokens()) {
            result.addElement(parser.nextToken());
        }
        return result;
    }

    private static int compareTuples(String lhs, String rhs) {
        try {
            int ilhs = Integer.parseInt(lhs);
            int irhs = Integer.parseInt(rhs);
            if (ilhs < irhs) {
                return -1;
            }
            if (ilhs > irhs) {
                return 1;
            }
        }
        catch (NumberFormatException ex) {
            return lhs.compareTo(rhs);
        }
        return 0;
    }
}

