/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import com.elluminate.platform.PlatformAPI;
import com.elluminate.platform.PlatformApp;
import com.elluminate.platform.PlatformDebug;
import com.elluminate.platform.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public class GenericPlatform
implements PlatformAPI {
    private static HashMap ExtToMime = new HashMap();
    private static HashMap MimeToExt = new HashMap();
    private Runtime runtime = Runtime.getRuntime();
    protected final I18n i18n = I18n.create(this, false);
    protected int platform = 0;
    protected int opSystem = 0;
    protected int version = 0;
    protected int release = 0;
    protected int bugfix = 0;
    protected boolean hasBugFix = false;
    protected String patchLevel = null;
    protected int arch = 0;
    protected int byteOrder = 0;
    protected boolean addressable64 = false;
    protected String details = "";
    protected PlatformApp application = null;

    private static void extMap(String ext, String mime) {
        ExtToMime.put(ext, mime);
        MimeToExt.put(mime, ext);
    }

    public GenericPlatform() {
        String level;
        String info = System.getProperty("os.version");
        if (info != null) {
            String val;
            StringTokenizer parser = new StringTokenizer(info, ".-_,: ");
            if (parser.hasMoreTokens()) {
                val = parser.nextToken();
                try {
                    this.version = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    this.version = 0;
                }
            }
            if (parser.hasMoreTokens()) {
                val = parser.nextToken();
                try {
                    this.release = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    this.release = 0;
                }
            }
            if (parser.hasMoreTokens()) {
                val = parser.nextToken();
                try {
                    this.bugfix = Integer.parseInt(val);
                    this.hasBugFix = true;
                }
                catch (NumberFormatException ex) {
                    this.bugfix = 0;
                }
            }
        }
        if ((level = System.getProperty("sun.os.patch.level")) != null && !"".equals(level) && !"unknown".equalsIgnoreCase(level)) {
            this.patchLevel = level;
            if (!this.hasBugFix && this.bugfix == 0) {
                StringTokenizer patchParser = new StringTokenizer(level);
                while (patchParser.hasMoreTokens()) {
                    String val = patchParser.nextToken();
                    try {
                        int levelVal;
                        this.bugfix = levelVal = Integer.parseInt(val);
                        break;
                    }
                    catch (Throwable t) {
                    }
                }
            }
        }
        if ((info = System.getProperty("os.name")).equalsIgnoreCase("SunOS")) {
            this.platform = 3;
            if (this.version >= 5) {
                this.opSystem = 250;
            }
        } else if (info.equalsIgnoreCase("Linux")) {
            this.platform = 3;
            this.opSystem = 300;
        }
        if ((info = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH)) != null) {
            if (info.equalsIgnoreCase("x86") || info.equalsIgnoreCase("i386") || info.equalsIgnoreCase("i586") || info.equalsIgnoreCase("i686") || info.equalsIgnoreCase("x86_64") || info.equalsIgnoreCase("amd64")) {
                this.arch = 101;
            } else if (info.equalsIgnoreCase("ppc") || info.equalsIgnoreCase("ppc64") || info.equalsIgnoreCase("powerpc")) {
                this.arch = 102;
            } else if (info.startsWith("sparc")) {
                this.arch = 103;
            }
            if (info.equalsIgnoreCase("x86_64") || info.equalsIgnoreCase("amd64") || info.equalsIgnoreCase("ppc64")) {
                this.addressable64 = true;
            } else {
                String archModel = System.getProperty("sun.arch.data.model");
                if (archModel != null && "64".equals(archModel)) {
                    this.addressable64 = true;
                }
            }
        }
        this.byteOrder = (info = System.getProperty("sun.cpu.endian")) == null ? (this.arch == 101 ? 602 : (this.arch == 102 || this.arch == 103 ? 601 : 0)) : ("little".equals(info = info.toLowerCase(Locale.ENGLISH)) ? 602 : ("big".equals(info) ? 601 : 0));
        if (PlatformDebug.GENERAL.show()) {
            LogSupport.message(this, "<init>", "Initialized Platform data for os=" + System.getProperty("os.name") + " version=" + System.getProperty("os.version") + " patch=" + System.getProperty("sun.os.patch.level") + " arch=" + System.getProperty("os.arch") + " byteOrder=" + System.getProperty("sun.cpu.endian"));
        }
    }

    @Override
    public String getDeviceCode() {
        switch (this.getPlatform()) {
            case 1: {
                return "DW";
            }
            case 2: {
                return "DM";
            }
            case 3: {
                return "DL";
            }
        }
        return "D?";
    }

    @Override
    public int getPlatform() {
        return this.platform;
    }

    @Override
    public int getOS() {
        return this.opSystem;
    }

    @Override
    public int getArch() {
        return this.arch;
    }

    @Override
    public int getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public String getPlatformName() {
        return this.getPlatformName(this.getPlatform());
    }

    @Override
    public String getArchName() {
        return this.getArchName(this.getArch());
    }

    @Override
    public String getOSName() {
        return this.getOSName(this.getOS());
    }

    @Override
    public boolean is64BitAddressable() {
        return this.addressable64;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getRelease() {
        return this.release;
    }

    @Override
    public int getBugfix() {
        return this.bugfix;
    }

    @Override
    public String getPatch() {
        return this.patchLevel;
    }

    @Override
    public String getVersionString() {
        String result = this.version + "." + this.release;
        if (this.hasBugFix) {
            result = result + "." + this.bugfix;
        }
        if (this.patchLevel != null) {
            result = result + " " + this.patchLevel;
        }
        return result;
    }

    @Override
    public String getInfo() {
        StringBuffer result = new StringBuffer(64);
        int os = this.getOS();
        int arch = this.getArch();
        result.append(this.getOSName(os));
        if (os == 0) {
            result.append(" (" + System.getProperty("os.name", "N/A") + ")");
        }
        result.append(" " + this.getVersionString());
        result.append(" " + this.getArchName(arch));
        if (arch == 0) {
            result.append(" (" + System.getProperty("os.arch", "N/A") + ")");
        }
        if (this.is64BitAddressable()) {
            result.append(" 64-bit");
        }
        return result.toString();
    }

    @Override
    public String getDetailedInfo() {
        return this.details;
    }

    @Override
    public String getJavaInfo() {
        String jws;
        String jc;
        String jvm;
        String jre;
        String vendor;
        StringBuffer result = new StringBuffer(64);
        result.append("Java " + System.getProperty("java.version", "???"));
        if (this.is64BitAddressable()) {
            result.append(" 64-bit");
        }
        if ((vendor = System.getProperty("java.vendor")) != null) {
            result.append(" " + vendor);
        }
        if ((jre = System.getProperty("java.runtime.version")) != null) {
            result.append(" JRE=" + jre);
        }
        if ((jvm = System.getProperty("java.vm.version")) != null) {
            result.append(" JVM=" + jvm);
        }
        if ((jc = System.getProperty("java.compiler")) != null) {
            result.append(" JITC=" + jc);
        }
        if ((jws = System.getProperty("javawebstart.version")) != null) {
            result.append(" JWS=" + jws);
        }
        return result.toString();
    }

    @Override
    public int getCPUCount() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable t) {
            return -1;
        }
    }

    @Override
    public long getCPUFrequency(int index) {
        return -1L;
    }

    @Override
    public void setApplication(PlatformApp app) {
        this.application = app;
    }

    @Override
    public void applicationInit() {
    }

    @Override
    public String getMimeType(File f) {
        if (f.isDirectory()) {
            throw new RuntimeException("Attempted to use directory " + f + " as a file.");
        }
        return this.getMimeTypeInternal(f.getName());
    }

    @Override
    public String getMimeType(String name) {
        return this.getMimeTypeInternal(name);
    }

    @Override
    public String getSuffix(String mime) {
        return this.getExtensionFromMimeInternal(mime);
    }

    @Override
    public File getDefaultDir() {
        File f = null;
        String home = System.getProperty("user.home", System.getProperty("user.dir", "/"));
        if (home != null) {
            f = new File(home);
        }
        return f;
    }

    @Override
    public File getTempDir() {
        String prop = System.getProperty("java.io.tmpdir");
        if (prop != null) {
            return new File(prop);
        }
        prop = System.getProperty("user.home");
        if (prop != null) {
            File f = new File(prop, ".tmpdir");
            f.mkdirs();
            return f;
        }
        File f = new File("/tmp");
        f.mkdirs();
        return f;
    }

    @Override
    public File getPreferencesDir() {
        String prop = System.getProperty("user.home");
        if (prop != null) {
            return new File(prop);
        }
        return null;
    }

    @Override
    public File getLogRelPathRoot() {
        File f = null;
        String home = System.getProperty("user.home", System.getProperty("user.dir", "/"));
        if (home != null) {
            f = new File(home);
        }
        return f;
    }

    @Override
    public String getNativePath(File path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot make native path from null File object.");
        }
        return path.toString();
    }

    @Override
    public String getNativePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot make native path from null String object.");
        }
        return path;
    }

    @Override
    public String cleanFilename(String filename, boolean visible) {
        return filename;
    }

    @Override
    public String filterFilename(String filename) {
        return filename;
    }

    @Override
    public String getMemoryStatus() {
        long totalMem = this.runtime.totalMemory();
        long freeMem = this.runtime.freeMemory();
        long usedMem = totalMem - freeMem;
        double percent = (double)usedMem / (double)totalMem;
        return this.i18n.getString(StringsProperties.GENERICPLATFORM_MEMORYDISPLAY, new Double(percent), new Long(usedMem), new Long(totalMem));
    }

    @Override
    public String getExtendedMemoryStatus() {
        String heapsize = System.getProperty("jnlpx.heapsize");
        if (heapsize == null) {
            heapsize = "unknown";
        }
        Number max = null;
        try {
            Method getMax = this.runtime.getClass().getMethod("maxMemory", new Class[0]);
            max = (Number)getMax.invoke((Object)this.runtime, new Object[0]);
        }
        catch (Throwable ignored) {
            max = new Integer(-1);
        }
        return this.i18n.getString(StringsProperties.GENERICPLATFORM_EXTENDEDMEMORYDISPLAY, this.getMemoryStatus(), max, heapsize);
    }

    @Override
    public File findAppByMIME(String mimeType) {
        return null;
    }

    @Override
    public File findAppByExtension(String extension) {
        return null;
    }

    @Override
    public File findAppByReference(String appRef) {
        File app = new File(appRef);
        return app.exists() ? app : null;
    }

    @Override
    public boolean launchApp(File app) {
        return false;
    }

    @Override
    public boolean launchApp(File app, File document) {
        return false;
    }

    @Override
    public boolean openFile(File file) {
        return false;
    }

    String getMimeTypeInternal(String name) {
        String ext = FileSysUtils.getExtensionString(name);
        String mime = null;
        if (ext != null && (mime = (String)ExtToMime.get(ext = ext.toLowerCase(Locale.ENGLISH))) != null) {
            return mime;
        }
        return "application/octet-stream";
    }

    String getExtensionFromMimeInternal(String mime) {
        String ext = (String)MimeToExt.get(mime = mime.toLowerCase(Locale.ENGLISH));
        if (ext != null) {
            return ext;
        }
        return "";
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected String getPlatformName(int plat) {
        String result = null;
        switch (plat) {
            case 1: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WINPLATFORMNAME);
                break;
            }
            case 2: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_MACPLATFORMNAME);
                break;
            }
            case 3: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_UNIXPLATFORMNAME);
                break;
            }
            default: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_GENERICPLATFORMNAME);
            }
        }
        return result;
    }

    protected String getArchName(int arch) {
        String result = null;
        switch (arch) {
            case 102: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_PPCARCHNAME);
                break;
            }
            case 101: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_X86ARCHNAME);
                break;
            }
            case 103: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_SPARCARCHNAME);
                break;
            }
            default: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_GENERICARCHNAME);
            }
        }
        return result;
    }

    protected String getOSName(int os) {
        String result = null;
        switch (os) {
            case 202: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_MACXOS);
                break;
            }
            case 400: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WIN95OS);
                break;
            }
            case 401: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WIN98OS);
                break;
            }
            case 402: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WINMEOS);
                break;
            }
            case 403: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WINNTOS);
                break;
            }
            case 404: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WIN2KOS);
                break;
            }
            case 405: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WINXPOS);
                break;
            }
            case 406: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WINVISTAOS);
                break;
            }
            case 407: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_WIN7OS);
                break;
            }
            case 250: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_SOLARISOS);
                break;
            }
            case 300: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_LINUXOS);
                break;
            }
            default: {
                result = this.i18n.getString(StringsProperties.GENERICPLATFORM_GENERICOS);
            }
        }
        return result;
    }

    @Override
    public int usingScreenReader() {
        if (PlatformDebug.PRETEND_USING_SCREEN_READER.isEnabled()) {
            return 1;
        }
        return -1;
    }

    static {
        GenericPlatform.extMap("apf", "image/apf");
        GenericPlatform.extMap("asf", "video/x-ms-asf");
        GenericPlatform.extMap("asx", "video/x-ms-asf");
        GenericPlatform.extMap("asx", "video/x-ms-asf-plugin");
        GenericPlatform.extMap("asf", "video/x-ms-asf-plugin");
        GenericPlatform.extMap("avi", "video/x-msvideo");
        GenericPlatform.extMap("bmp", "image/bmp");
        GenericPlatform.extMap("cur", "image/cur");
        GenericPlatform.extMap("gif", "image/gif");
        GenericPlatform.extMap("ico", "image/ico");
        GenericPlatform.extMap("jpeg", "image/jpeg");
        GenericPlatform.extMap("jpg", "image/jpeg");
        GenericPlatform.extMap("jpg2", "image/jpeg2000");
        GenericPlatform.extMap("jp2", "image/jpeg2000");
        GenericPlatform.extMap("mov", "video/quicktime");
        GenericPlatform.extMap("m4a", "audio/x-m4a");
        GenericPlatform.extMap("m4b", "audio/x-m4b");
        GenericPlatform.extMap("m4v", "video/x-m4v");
        GenericPlatform.extMap("mpe", "video/mpeg");
        GenericPlatform.extMap("mpeg", "video/mpeg");
        GenericPlatform.extMap("mpega", "audio/mpeg");
        GenericPlatform.extMap("mpg", "video/mpeg");
        GenericPlatform.extMap("mpga", "audio/mpeg");
        GenericPlatform.extMap("mp2", "audio/mpeg");
        GenericPlatform.extMap("mp3", "audio/mpeg");
        GenericPlatform.extMap("mp4", "video/mp4");
        GenericPlatform.extMap("odp", "application/vnd.sun.xml.impress");
        GenericPlatform.extMap("pcx", "image/pcx");
        GenericPlatform.extMap("pct", "image/pict");
        GenericPlatform.extMap("pbm", "image/x-portable-bitmap");
        GenericPlatform.extMap("pgm", "image/x-portable-graymap");
        GenericPlatform.extMap("pnm", "image/x-portable-anymap");
        GenericPlatform.extMap("ppm", "image/x-portable-pixmap");
        GenericPlatform.extMap("pict", "image/pict");
        GenericPlatform.extMap("png", "image/png");
        GenericPlatform.extMap("psd", "image/psd");
        GenericPlatform.extMap("qt", "video/quicktime");
        GenericPlatform.extMap("ra", "audio/x-realaudio");
        GenericPlatform.extMap("ram", "audio/x-pn-realaudio");
        GenericPlatform.extMap("rm", "application/vnd.rn-realmedia");
        GenericPlatform.extMap("rm", "audio/x-pn-realaudio");
        GenericPlatform.extMap("rpm", "audio/x-pn-realaudio-plugin");
        GenericPlatform.extMap("swf", "application/x-shockwave-flash");
        GenericPlatform.extMap("tga", "image/targa");
        GenericPlatform.extMap("tif", "image/tiff");
        GenericPlatform.extMap("tiff", "image/tiff");
        GenericPlatform.extMap("ppt", "application/x-ms-powerpoint");
        GenericPlatform.extMap("ppts", "application/x-ms-powerpoint");
        GenericPlatform.extMap("pptx", "application/x-ms-powerpoint");
        GenericPlatform.extMap("sxi", "application/vnd.sun.xml.impress");
        GenericPlatform.extMap("wav", "audio/x-wav");
        GenericPlatform.extMap("wbmp", "image/vnd.wap.wbmp");
        GenericPlatform.extMap("wma", "audio/x-ms-wma");
        GenericPlatform.extMap("wmv", "video/x-ms-wmv");
    }
}

