/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.httpCommon.AuthenticateHandler;
import com.elluminate.net.httpCommon.HttpHeaderParser;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthScheme;
import com.elluminate.net.httpCommon.StringsProperties;
import com.elluminate.util.I18n;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class ProxyAuthenticator
implements AuthenticateHandler {
    private I18n i18n = I18n.create(this);
    private ProxyAuthScheme scheme = null;

    public boolean checkResponse(NetHttpResponse resp) throws IOException {
        if (this.scheme == null && resp.getCode() == 407) {
            HttpHeaderParser.parseAuth(resp, this);
            if (this.scheme == null) {
                throw new IOException(this.i18n.getString(StringsProperties.PROXYAUTHENTICATOR_NOSUPPORTEDSCHEME));
            }
            return true;
        }
        if (this.scheme != null) {
            return this.scheme.checkResponse(resp);
        }
        return false;
    }

    public void authenticate(NetHttpRequest req) throws IOException {
        if (this.scheme != null) {
            this.scheme.authenticate(req);
        }
    }

    public boolean disconnectRequired() {
        if (this.scheme != null) {
            return this.scheme.disconnectRequired();
        }
        return false;
    }

    @Override
    public boolean scheme(String name, HashMap args) {
        Object inst;
        Class<?> cls;
        String path = this.getClass().getName();
        int lastDot = path.lastIndexOf(".");
        ProxyAuthScheme check = null;
        path = path.substring(0, lastDot);
        name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase(Locale.ENGLISH);
        path = path + "." + name + "ProxyAuthScheme";
        try {
            cls = Class.forName(path);
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
        try {
            inst = cls.newInstance();
        }
        catch (Exception ex) {
            return true;
        }
        try {
            check = (ProxyAuthScheme)inst;
        }
        catch (ClassCastException ex) {
            return true;
        }
        if (!check.setArgs(args)) {
            return true;
        }
        if (this.scheme == null) {
            this.scheme = check;
        } else if (check.getStrength() > this.scheme.getStrength()) {
            this.scheme = check;
        }
        return true;
    }
}

