/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.NetDebug;
import com.elluminate.net.httpCommon.AsyncHttpRequest;
import com.elluminate.net.httpCommon.HttpRequestRecvListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class NetHttpRequest
extends AsyncHttpRequest {
    public static final int REQ_NONE = -1;
    public static final int REQ_PING = 0;
    public static final int REQ_INIT = 1;
    public static final int REQ_JOIN = 2;
    public static final int REQ_READ = 3;
    public static final int REQ_WRITE = 4;
    public static final int REQ_DATA = 5;
    public static final int REQ_CLOSE = 6;
    public static final String[] REQUESTS = new String[]{"/jinx/ping", "/jinx/init", "/jinx/join/", "/jinx/read/", "/jinx/write/", "/jinx/data/", "/jinx/close/"};
    private String path = null;
    private int req = -1;
    private int session = -1;
    private int sequence = 0;

    public NetHttpRequest() {
    }

    public NetHttpRequest(String target, int port, int method, int request, int session, int seq, int len, boolean done, int httpVer) {
        this.init(target, port, method, request, session, seq, len, done, httpVer);
    }

    public NetHttpRequest(String target, int port, int method, String path, int len, boolean done, int httpVer) {
        this.init(target, port, method, path, len, done, httpVer);
    }

    public NetHttpRequest(DataInputStream istr) throws IOException {
        this.init(istr);
    }

    public NetHttpRequest(AsyncEndpoint ep, HttpRequestRecvListener lst) {
        this.init(ep, lst);
    }

    public void init(String target, int port, int method, int request, int session, int seq, int len, boolean done, int httpVer) {
        this.init(method, target, port, NetHttpRequest.makeURI(method, target, port, NetHttpRequest.makePath(request, session, seq)), len, done, httpVer, true, NetDebug.HTTP_HDR.show());
        this.path = NetHttpRequest.makePath(request, session, seq);
        this.setup(request, session, seq);
    }

    public void init(String target, int port, int method, String path, int len, boolean done, int httpVer) {
        this.init(method, target, port, NetHttpRequest.makeURI(method, target, port, path), len, done, httpVer, true, NetDebug.HTTP_HDR.show());
        this.path = path;
        this.setup(-1, -1, -1);
    }

    @Override
    public void init(DataInputStream istr, boolean debug) throws IOException {
        super.init(istr, debug);
        this.validate();
    }

    public void init(DataInputStream istr) throws IOException {
        this.init(istr, NetDebug.HTTP_HDR.show());
    }

    public void init(AsyncEndpoint ep, HttpRequestRecvListener lst) {
        this.init(ep, NetDebug.HTTP_HDR.show(), lst);
    }

    private void setup(int request, int session, int seq) {
        this.req = request;
        this.session = session;
        this.sequence = seq;
        this.setHeader("Cache-Control", "no-store");
        if (this.length > 0) {
            this.setHeader("Content-Type", "image/jpeg");
        }
    }

    @Override
    protected void evaluateHeaders() throws IOException {
        super.evaluateHeaders();
        this.validate();
    }

    public void validate() throws IOException {
        String token = super.getURI();
        if (token.startsWith("/")) {
            this.path = token;
        } else {
            try {
                URL url = new URL(token);
                this.path = url.getFile();
            }
            catch (MalformedURLException ex) {
                throw new IOException("Invalid URL in request: '" + token + "'");
            }
        }
        for (int i = 0; i < REQUESTS.length; ++i) {
            if (!this.path.startsWith(REQUESTS[i])) continue;
            this.req = i;
            if (this.req <= 1) break;
            StringTokenizer pathParser = null;
            String pathArgs = null;
            pathArgs = this.path.substring(REQUESTS[i].length());
            pathParser = new StringTokenizer(pathArgs, "/");
            if (!pathParser.hasMoreTokens()) {
                throw new IOException("Unknown JINX request '" + this.path + "'\n  Missing session.");
            }
            try {
                this.session = Integer.parseInt(pathParser.nextToken());
            }
            catch (Exception ex) {
                throw new IOException("Unknown JINX request '" + this.path + "'\n  Invalid session.");
            }
            if (!pathParser.hasMoreTokens()) {
                throw new IOException("Unknown JINX request '" + this.path + "'\n  Missing sequence.");
            }
            try {
                this.sequence = Integer.parseInt(pathParser.nextToken());
            }
            catch (Exception ex) {
                throw new IOException("Unknown JINX request '" + this.path + "'\n  Invalid sequence.");
            }
            if (!pathParser.hasMoreTokens()) break;
            throw new IOException("Unknown JINX request '" + this.path + "'\n  Garbage follows sequence.");
        }
        if (this.req < 0) {
            throw new IOException("Unknown JINX request '" + this.path + "'");
        }
    }

    private static String makeURI(int cmd, String to, int on, String path) {
        StringBuffer hdr = new StringBuffer();
        if (cmd != 3) {
            hdr.append("http://");
        }
        if (to != null) {
            hdr.append(to);
            hdr.append(":");
            hdr.append(on);
        }
        if (cmd != 3) {
            hdr.append(path);
        }
        return hdr.toString();
    }

    private static String makePath(int req, int session, int seq) {
        String tmpPath = REQUESTS[req];
        if (req > 1) {
            tmpPath = tmpPath + session + "/" + seq;
        }
        return tmpPath;
    }

    public int getRequest() {
        return this.req;
    }

    public int getSession() {
        return this.session;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getPath() {
        return this.path;
    }
}

