/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.ProxyAuthDataStore;
import com.elluminate.net.ProxyAuthRealm;
import com.elluminate.net.httpCommon.AuthenticateHandler;
import com.elluminate.net.httpCommon.HttpHeaderParser;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthScheme;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;

public class DigestProxyAuthScheme
implements ProxyAuthScheme,
AuthenticateHandler {
    private static final byte QOP_INVALID = -1;
    private static final byte QOP_NONE = 0;
    private static final byte QOP_AUTH = 1;
    private String realm = null;
    private String algorithm = null;
    private String auth = null;
    private ProxyAuthData authData = null;
    private String nonce = null;
    private String opaque = null;
    private byte qop = (byte)-1;
    private String lastNonce = null;
    private int lastNonceCount = 0;
    private MessageDigest md5 = null;
    private Random rnd = new Random();
    private boolean disconnect = true;

    @Override
    public boolean setArgs(HashMap args) {
        int chkQop;
        String chkOpaque;
        String chkNonce;
        String chkAlgorithm;
        String chkRealm;
        block8: {
            String qopValue;
            block7: {
                if (this.md5 == null) {
                    try {
                        this.md5 = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException ex) {
                        return false;
                    }
                }
                chkRealm = (String)args.get("realm");
                chkAlgorithm = (String)args.get("algorithm");
                chkNonce = (String)args.get("nonce");
                chkOpaque = (String)args.get("opaque");
                chkQop = -1;
                if (chkAlgorithm == null) {
                    chkAlgorithm = "MD5";
                }
                if (!chkAlgorithm.equals("MD5") && !chkAlgorithm.equals("MD5-sess")) {
                    return false;
                }
                qopValue = (String)args.get("qop");
                if (qopValue != null) break block7;
                if (!this.algorithm.equals("MD5")) break block8;
                chkQop = 0;
                break block8;
            }
            StringTokenizer t = new StringTokenizer(qopValue, ",");
            while (t.hasMoreTokens()) {
                String option = t.nextToken();
                if (!option.equals("auth")) continue;
                chkQop = 1;
                break;
            }
        }
        if (chkQop == -1) {
            return false;
        }
        this.realm = chkRealm;
        this.algorithm = chkAlgorithm;
        this.nonce = chkNonce;
        this.opaque = chkOpaque;
        this.qop = (byte)chkQop;
        return true;
    }

    @Override
    public int getStrength() {
        return 20;
    }

    @Override
    public boolean checkResponse(NetHttpResponse resp) throws IOException {
        switch (resp.getCode()) {
            case 407: {
                HttpHeaderParser.parseAuth(resp, this);
                if (this.authData != null) {
                    ProxyAuthDataStore.voidAuthData(this.authData);
                    this.authData = null;
                }
                this.disconnect = true;
                this.auth = null;
                return true;
            }
            case 200: {
                HashMap args;
                String hdr = resp.getHeader("proxy-authentication-info");
                if (hdr != null && (args = HttpHeaderParser.parseArgList(hdr)).containsKey("nextnonce")) {
                    this.nonce = (String)args.get("nextnonce");
                }
                this.disconnect = false;
                break;
            }
            default: {
                this.disconnect = false;
            }
        }
        return false;
    }

    @Override
    public void authenticate(NetHttpRequest req) throws IOException {
        if (this.authData == null) {
            this.authData = ProxyAuthDataStore.getAuthData("basic", new ProxyAuthRealm(this.realm));
        }
        this.auth = this.getDigestAuth(req);
        req.setHeader("Proxy-Authorization", this.auth);
    }

    @Override
    public boolean disconnectRequired() {
        return this.disconnect;
    }

    private String getDigestAuth(NetHttpRequest req) throws IOException {
        StringBuffer authHdr = new StringBuffer("Digest ");
        String cnonce = new BigInteger(64, this.rnd).toString(16);
        String user = this.authData.getUser();
        String pass = this.authData.getPass();
        authHdr.append("username=\"");
        authHdr.append(user);
        authHdr.append("\",realm=\"");
        authHdr.append(this.realm);
        authHdr.append("\",nonce=\"");
        authHdr.append(this.nonce);
        authHdr.append("\",uri=\"");
        authHdr.append(req.getURI());
        authHdr.append("\"");
        if (this.opaque != null) {
            authHdr.append(",opaque=\"");
            authHdr.append(this.opaque);
            authHdr.append("\"");
        }
        String nc = this.getNC(this.nonce);
        if (this.qop == 1) {
            authHdr.append(",qop=\"auth\",nc=");
            authHdr.append(nc);
            authHdr.append(",cnonce=\"");
            authHdr.append(cnonce);
            authHdr.append("\"");
        }
        String A1 = user + ":" + this.realm + ":" + pass;
        if (this.algorithm.equals("MD5-sess")) {
            A1 = this.H(A1) + ":" + this.nonce + ":" + cnonce;
        }
        String A2 = NetHttpRequest.COMMANDS[req.getMethod()] + ":" + req.getURI();
        String HA1 = this.H(A1);
        String HA2 = this.H(A2);
        String digest = this.qop == 1 ? this.KD(HA1, this.nonce + ":" + nc + ":" + cnonce + ":auth:" + HA2) : this.KD(HA1, this.nonce + ":" + HA2);
        authHdr.append(",response=\"");
        authHdr.append(digest);
        authHdr.append("\"");
        return authHdr.toString();
    }

    private String H(String arg) {
        byte[] inBytes;
        this.md5.reset();
        try {
            inBytes = arg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ex) {
            inBytes = arg.getBytes();
        }
        byte[] outBytes = this.md5.digest(inBytes);
        StringBuffer outBuf = new StringBuffer(32);
        for (int i = 0; i < outBytes.length; ++i) {
            byte b = outBytes[i];
            outBuf.append(Character.forDigit(b >> 4 & 0xF, 16));
            outBuf.append(Character.forDigit(b & 0xF, 16));
        }
        return outBuf.toString();
    }

    private String KD(String secret, String data) {
        return this.H(secret + ":" + data);
    }

    private String getNC(String nonce) {
        StringBuffer nc = new StringBuffer(8);
        this.lastNonceCount = nonce.equals(this.lastNonce) ? ++this.lastNonceCount : 1;
        this.lastNonce = nonce;
        for (int i = 7; i >= 0; --i) {
            int digit = this.lastNonceCount >> 4 * i & 0xF;
            nc.append(Character.forDigit(digit, 16));
        }
        return nc.toString();
    }

    @Override
    public boolean scheme(String name, HashMap args) {
        if (!name.equals("digest")) {
            return true;
        }
        if (!this.setArgs(args)) {
            return true;
        }
        String stale = (String)args.get("stale");
        if ((stale == null || stale.equalsIgnoreCase("false")) && this.authData != null) {
            ProxyAuthDataStore.voidAuthData(this.authData);
            this.authData = null;
        }
        return false;
    }
}

