/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.ConnectionHandler;
import com.elluminate.net.Endpoint;
import com.elluminate.net.http.HttpServerConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import java.util.LinkedList;

public class HttpConnectionHandler
implements ConnectionHandler {
    private static final byte[] LTAG = new byte[]{112, 111, 115, 116, 32};
    private static final byte[] UTAG = new byte[]{80, 79, 83, 84, 32};

    @Override
    public boolean isUniversal() {
        return false;
    }

    @Override
    public boolean check(Endpoint ep) {
        try {
            return this.isHttp(ep);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public void accept(Endpoint ep, LinkedList queue) {
        DataOutputStream out;
        DataInputStream in;
        try {
            in = new DataInputStream(ep.getInputStream());
            out = new DataOutputStream(ep.getOutputStream());
        }
        catch (IOException ex) {
            try {
                ep.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return;
        }
        HttpServerConnection c = new HttpServerConnection(queue, ep, in, out);
        c.setDaemon(true);
        c.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHttp(Endpoint e) throws IOException {
        byte[] actual = new byte[5];
        int timeout = e.getSoTimeout();
        int n = 0;
        int nRead = 0;
        PushbackInputStream in = (PushbackInputStream)e.getInputStream();
        e.setSoTimeout(2000);
        try {
            for (n = 0; n < LTAG.length; ++n) {
                int c = in.read();
                if (c < 0) {
                    boolean bl = false;
                    return bl;
                }
                actual[nRead++] = (byte)c;
                if (c == LTAG[n] || c == UTAG[n]) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedIOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            in.unread(actual, 0, nRead);
            e.setSoTimeout(timeout);
        }
        return true;
    }
}

