/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.AsyncConnectionHandler;
import com.elluminate.net.AsyncConnectionListener;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.http.AsyncHttpServerConnection;
import java.io.IOException;
import java.io.InterruptedIOException;

public class HttpAsyncConnectionHandler
implements AsyncConnectionHandler {
    private static final byte[] LTAG = new byte[]{112, 111, 115, 116, 32};
    private static final byte[] UTAG = new byte[]{80, 79, 83, 84, 32};
    private static final int REQ_TIMEOUT = 5000;
    AsyncConnectionHandler nextHandler = null;

    @Override
    public boolean isUniversal() {
        return false;
    }

    @Override
    public void process(AsyncEndpoint aep, AsyncConnectionListener lst) {
        new Tester(aep, lst);
    }

    @Override
    public void setNext(AsyncConnectionHandler next) {
        this.nextHandler = next;
    }

    class Tester
    extends AsyncIOAdapter {
        AsyncEndpoint endpoint;
        AsyncConnectionListener listener;
        int savedTimeout;
        int off = 0;
        int len = HttpAsyncConnectionHandler.access$000().length;
        byte[] buffer = new byte[this.len];

        public Tester(AsyncEndpoint ep, AsyncConnectionListener lst) {
            this.endpoint = ep;
            this.listener = lst;
            try {
                this.savedTimeout = this.endpoint.getTimeout();
                this.endpoint.setTimeout(5000);
                int n = this.endpoint.beginRead(this.buffer, this.off, this.len, this);
                if (n > 0 && this.check(n)) {
                    if (this.len == 0) {
                        ep.unread(this.buffer, 0, this.off);
                        this.endpoint.setTimeout(this.savedTimeout);
                        new AsyncHttpServerConnection(this.endpoint, this.listener);
                    } else {
                        this.endpoint.beginRead(this.buffer, this.off, this.len, this);
                    }
                }
            }
            catch (IOException iox) {
                this.listener.asyncException(this.endpoint, iox);
            }
        }

        @Override
        public void readComplete(AsyncIORequest req) {
            try {
                int n = req.finishRequest();
                if (this.check(n)) {
                    if (this.len == 0) {
                        this.endpoint.setTimeout(this.savedTimeout);
                        new AsyncHttpServerConnection(this.endpoint, this.listener);
                    } else {
                        this.endpoint.beginRead(this.buffer, this.off, this.len, this);
                    }
                }
            }
            catch (InterruptedIOException iiox) {
                this.endpoint.unread(this.buffer, 0, this.off);
                this.endpoint.setTimeout(this.savedTimeout);
                if (HttpAsyncConnectionHandler.this.nextHandler != null) {
                    HttpAsyncConnectionHandler.this.nextHandler.process(this.endpoint, this.listener);
                } else {
                    this.listener.asyncException(this.endpoint, (IOException)iiox);
                }
                return;
            }
            catch (IOException iox) {
                this.listener.asyncException(this.endpoint, iox);
                return;
            }
        }

        public boolean check(int n) {
            for (int i = 0; i < n; ++i) {
                char c = (char)this.buffer[this.off];
                if (c == LTAG[this.off] || c == UTAG[this.off]) {
                    ++this.off;
                    --this.len;
                    continue;
                }
                this.off += n - i;
                this.endpoint.setTimeout(this.savedTimeout);
                this.endpoint.unread(this.buffer, 0, this.off);
                if (HttpAsyncConnectionHandler.this.nextHandler != null) {
                    HttpAsyncConnectionHandler.this.nextHandler.process(this.endpoint, this.listener);
                } else {
                    this.endpoint.beginClose(null);
                }
                return false;
            }
            return true;
        }
    }
}

