/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.Endpoint;
import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpDataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;

public class ConnectionInputStream
extends InputStream {
    private static final long MAX_ATTACH_WAIT = 30000L;
    private byte[] buf = new byte[1];
    private Endpoint endpoint = null;
    private HttpDataHandler handler = null;

    public ConnectionInputStream(Endpoint ep, HttpDataHandler handler) {
        this.endpoint = ep;
        this.handler = handler;
    }

    @Override
    public int read() throws IOException {
        int nread = this.read(this.buf, 0, 1);
        if (nread <= 0) {
            return -1;
        }
        return this.buf[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int nRead = 0;
        if (this.handler.isClosed()) {
            throw new SocketException("Connection closed.");
        }
        int timeout = this.endpoint.getSoTimeout();
        long timeoutAt = 0L;
        long attachLimit = 0L;
        long now = 0L;
        if (timeout > 0) {
            now = System.currentTimeMillis();
            timeoutAt = now + (long)timeout;
        }
        while ((timeout == 0 || now < timeoutAt) && nRead == 0) {
            HttpConnection connection;
            Object lock;
            Object object = lock = this.handler.getReadLock();
            synchronized (object) {
                while (this.handler.getReadConnection() == null && !this.handler.isClosed()) {
                    try {
                        long delay;
                        if (now == 0L) {
                            now = System.currentTimeMillis();
                            attachLimit = now + 30000L;
                        }
                        if ((delay = timeout == 0 ? attachLimit - now : timeoutAt - now) <= 0L) {
                            throw new InterruptedIOException();
                        }
                        lock.wait(delay);
                    }
                    catch (InterruptedException ex) {
                        throw new InterruptedIOException();
                    }
                }
                if (this.handler.isClosed()) {
                    throw new SocketException("Connection closed.");
                }
                connection = this.handler.getReadConnection();
            }
            if (timeout > 0) {
                nRead = connection.read(buffer, off, len, (int)(timeoutAt - now));
                continue;
            }
            nRead = connection.read(buffer, off, len, 0);
        }
        return nRead;
    }
}

