/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.AbstractAsyncEndpoint;
import com.elluminate.net.AsyncConnectionListener;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIOHandler;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.AsyncIORequestImpl;
import com.elluminate.net.EndpointOptions;
import com.elluminate.net.NetDebug;
import com.elluminate.net.http.AsyncHttpServerConnection;
import com.elluminate.net.http.AsyncHttpSessionListener;
import com.elluminate.net.http.CircularBuffer;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.crypto.Hex;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;

public class AsyncHttpSession {
    public static final int HD_BUF_LEN = 65536;
    public static final int START_TIMEOUT = 5000;
    public static final int IDLE_TIMEOUT = 5000;
    private static final byte SS_WAIT_INIT = 0;
    private static final byte SS_WAIT_JOIN = 1;
    private static final byte SS_JOIN_AUTH = 2;
    private static final byte SS_DONE = 3;
    private static HashMap sessionMap = new HashMap();
    private static Random rnd = new SecureRandom();
    private Object lock = new Object();
    private volatile byte setupState = 0;
    private int sessionID;
    private AsyncConnectionListener listener;
    private ConnectionInfo info;
    private int mode = 0;
    private AsyncHttpSessionListener initListener = null;
    private LightweightTimer joinTimeout;
    private DiffieHellman auth = null;
    private boolean closed = false;
    private IOException pendingException = null;
    private SessionEndpoint endpoint = null;

    protected AsyncHttpSession(int id, AsyncEndpoint initial, AsyncConnectionListener lst) {
        this.sessionID = id;
        this.listener = lst;
        this.info = new ConnectionInfo(initial.getInetAddress(), initial.getPort(), initial.getLocalAddress(), initial.getLocalPort());
        this.auth = new DiffieHellman();
        this.joinTimeout = new LightweightTimer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncHttpSessionListener lst = null;
                Object object = AsyncHttpSession.this.lock;
                synchronized (object) {
                    if (AsyncHttpSession.this.mode == 0) {
                        AsyncHttpSession.this.setupState = (byte)3;
                        AsyncHttpSession.this.mode = 1;
                        AsyncHttpSession.this.endpoint = new HDSessionEndpoint(AsyncHttpSession.this.info);
                        lst = AsyncHttpSession.this.initListener;
                    }
                }
                if (lst != null) {
                    lst.setMode(AsyncHttpSession.this.mode);
                    lst.setDHResponse(AsyncHttpSession.this.auth.getChallenge());
                    AsyncHttpSession.this.listener.asyncAccept(AsyncHttpSession.this.endpoint);
                }
            }
        });
        this.joinTimeout.scheduleIn(5000L);
    }

    public int getID() {
        return this.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionListener(AsyncHttpSessionListener lst) {
        Object object = this.lock;
        synchronized (object) {
            this.initListener = lst;
            this.setupState = 1;
        }
    }

    public void setResponse(String dhResponse) {
        this.auth.setResponse(dhResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedJoin() {
        AsyncHttpSessionListener lst;
        Object object = this.lock;
        synchronized (object) {
            lst = this.initListener;
        }
        if (lst != null && this.setupState == 1) {
            this.setupState = (byte)2;
            lst.setDHResponse(this.auth.getChallenge());
        }
    }

    public void joinFailed(IOException iox) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(NetHttpRequest req, byte[] key) {
        boolean authenticated = this.auth.checkKey(key, req.getPath());
        AsyncHttpSessionListener lst = null;
        if (!authenticated) {
            return false;
        }
        if (req.getRequest() == 2) {
            Object object = this.lock;
            synchronized (object) {
                if (this.setupState != 2) {
                    authenticated = false;
                } else {
                    this.setupState = (byte)3;
                    this.mode = 2;
                    this.endpoint = new FDSessionEndpoint(this.info);
                    lst = this.initListener;
                    this.joinTimeout.cancel();
                }
            }
        }
        if (lst != null) {
            lst.setMode(this.mode);
            this.listener.asyncAccept(this.endpoint);
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readAttach(AsyncHttpServerConnection connection, int len) {
        if (this.endpoint == null) {
            LogSupport.error(this, "readAttach", "readAttach without endpoint");
            return;
        }
        try {
            this.endpoint.readAttach(connection, len);
        }
        catch (IOException iox) {
            HashMap hashMap = sessionMap;
            synchronized (hashMap) {
                sessionMap.remove(new Integer(this.sessionID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAttach(AsyncHttpServerConnection connection, int len) {
        if (this.endpoint == null) {
            LogSupport.error(this, "writedAttach", "writeAttach without endpoint");
            return;
        }
        try {
            this.endpoint.writeAttach(connection, len);
        }
        catch (IOException iox) {
            HashMap hashMap = sessionMap;
            synchronized (hashMap) {
                sessionMap.remove(new Integer(this.sessionID));
            }
        }
    }

    int bytesAvailable() {
        if (this.endpoint == null) {
            return 0;
        }
        return this.endpoint.bytesAvailable();
    }

    void close() {
        if (this.endpoint != null) {
            this.endpoint.beginClose(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncHttpSession getInstance(AsyncEndpoint ep, AsyncConnectionListener lst) {
        AsyncHttpSession session;
        HashMap hashMap = sessionMap;
        synchronized (hashMap) {
            int id = AsyncHttpSession.getNextID();
            session = new AsyncHttpSession(id, ep, lst);
            sessionMap.put(new Integer(id), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncHttpSession findInstance(int id) {
        AsyncHttpSession session = null;
        HashMap hashMap = sessionMap;
        synchronized (hashMap) {
            session = (AsyncHttpSession)sessionMap.get(new Integer(id));
        }
        return session;
    }

    private static int getNextID() {
        int id;
        while (sessionMap.containsKey(new Integer(id = rnd.nextInt() & Integer.MAX_VALUE))) {
        }
        return id;
    }

    class Attachment {
        private AsyncHttpServerConnection connection;
        private int len;
        private EndpointOptions attachedOpts = null;
        private EndpointOptions detachedOpts = new EndpointOptions();

        public Attachment(EndpointOptions opts) {
            this.attachedOpts = opts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attach(AsyncHttpServerConnection c, int n) throws IOException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.connection != null) {
                    throw new IllegalStateException();
                }
                this.connection = c;
                this.len = n;
            }
            AsyncEndpoint ep = c.getEndpoint();
            this.detachedOpts.get(ep);
            this.attachedOpts.set(ep);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncEndpoint getEndpoint() {
            AsyncEndpoint ep = null;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.connection != null) {
                    ep = this.connection.getEndpoint();
                }
            }
            return ep;
        }

        public int getLength() {
            return this.len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean transfer(int n) {
            boolean detach = false;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                this.len -= n;
                detach = this.len == 0;
            }
            if (detach) {
                this.detach();
            }
            return detach;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            AsyncHttpServerConnection c;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                c = this.connection;
                this.connection = null;
                this.len = 0;
            }
            if (c == null) {
                return;
            }
            try {
                this.detachedOpts.set(c.getEndpoint());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            c.detach();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            AsyncHttpServerConnection c;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                c = this.connection;
                this.connection = null;
                this.len = 0;
            }
            if (c != null) {
                c.close();
            }
        }
    }

    class ConnectionInfo {
        InetAddress remoteAddr;
        int remotePort;
        InetAddress localAddr;
        int localPort;

        public ConnectionInfo(InetAddress ra, int rp, InetAddress la, int lp) {
            this.remoteAddr = ra;
            this.remotePort = rp;
            this.localAddr = la;
            this.localPort = lp;
        }
    }

    class FDSessionEndpoint
    extends SessionEndpoint {
        private AsyncIORequestImpl pendingRead;
        private AsyncIORequestImpl pendingWrite;

        public FDSessionEndpoint(ConnectionInfo inf) {
            super(inf);
            this.pendingRead = null;
            this.pendingWrite = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int beginReadImpl(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.activeRead != null) {
                    throw new IllegalStateException("multiple simultaneous async read operations");
                }
                if (AsyncHttpSession.this.closed) {
                    throw new IOException("Endpoint is closed");
                }
                if (AsyncHttpSession.this.pendingException != null) {
                    throw AsyncHttpSession.this.pendingException;
                }
                this.activeRead = AsyncIORequestImpl.getReadReq(this, buffer, off, len, this, lst);
            }
            IOException iox = null;
            int n = 0;
            try {
                n = this.actualRead(this.activeRead, buffer, off, len);
            }
            catch (IOException x) {
                iox = x;
            }
            if (n > 0 || iox != null) {
                AsyncIORequestImpl req;
                Object object2 = AsyncHttpSession.this.lock;
                synchronized (object2) {
                    req = this.activeRead;
                    this.activeRead = null;
                }
                req.dispose();
            }
            if (iox != null) {
                throw iox;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int beginWrite(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.activeWrite != null) {
                    throw new IllegalStateException("multiple simultaneous async write operations");
                }
                if (AsyncHttpSession.this.closed) {
                    throw new IOException("Endpoint is closed");
                }
                if (AsyncHttpSession.this.pendingException != null) {
                    throw AsyncHttpSession.this.pendingException;
                }
                this.activeWrite = AsyncIORequestImpl.getWriteReq(this, buffer, off, len, this, lst);
            }
            IOException iox = null;
            int n = 0;
            try {
                n = this.actualWrite(this.activeWrite, buffer, off, len);
            }
            catch (IOException x) {
                iox = x;
            }
            if (n > 0 || iox != null) {
                AsyncIORequestImpl req;
                Object object2 = AsyncHttpSession.this.lock;
                synchronized (object2) {
                    req = this.activeWrite;
                    this.activeWrite = null;
                }
                req.dispose();
            }
            if (iox != null) {
                throw iox;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
            AsyncEndpoint ep = null;
            IOException iox = null;
            int nRead = 0;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                ep = this.in.getEndpoint();
                if (ep == null) {
                    this.pendingRead = req;
                }
            }
            if (ep == null) {
                return 0;
            }
            int n = Math.min(len, this.in.getLength());
            try {
                nRead = ep.beginRead(buf, off, n, this.listener);
                if (nRead > 0) {
                    if (NetDebug.HTTP_DATA.show()) {
                        LogSupport.message(this, "actualRead(" + ep + ")", Hex.toString(buf, off, nRead));
                    }
                    this.in.transfer(nRead);
                }
            }
            catch (IOException x) {
                iox = x;
                this.in.detach();
            }
            if (iox != null) {
                throw iox;
            }
            return nRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
            AsyncEndpoint ep;
            IOException iox = null;
            int nWritten = 0;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                ep = this.out.getEndpoint();
                if (ep == null) {
                    this.pendingWrite = req;
                }
            }
            if (ep == null) {
                return 0;
            }
            int n = Math.min(len, this.out.getLength());
            try {
                nWritten = ep.beginWrite(buf, off, n, this.listener);
                if (nWritten > 0) {
                    if (NetDebug.HTTP_DATA.show()) {
                        LogSupport.message(this, "actualWrite(" + ep + ")", Hex.toString(buf, off, nWritten));
                    }
                    this.out.transfer(nWritten);
                }
            }
            catch (IOException x) {
                iox = x;
                this.out.detach();
            }
            if (iox != null) {
                throw iox;
            }
            return nWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processReadAttach(AsyncHttpServerConnection c, int len) throws IOException {
            AsyncIORequestImpl req;
            int n = 0;
            IOException iox = null;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                req = this.pendingWrite;
                this.pendingWrite = null;
            }
            if (req != null) {
                try {
                    n = this.actualWrite(req, req.getBuffer(), req.getOffset(), req.getLength());
                }
                catch (IOException x) {
                    iox = x;
                }
                if (n > 0 || iox != null) {
                    object = AsyncHttpSession.this.lock;
                    synchronized (object) {
                        req = this.activeWrite;
                        this.activeWrite = null;
                    }
                    if (iox != null) {
                        req.fail(iox);
                    } else {
                        req.complete(n);
                    }
                    req.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processWriteAttach(AsyncHttpServerConnection c, int len) throws IOException {
            AsyncIORequestImpl req;
            int n = 0;
            IOException iox = null;
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                req = this.pendingRead;
                this.pendingRead = null;
            }
            if (req != null) {
                try {
                    n = this.actualRead(req, req.getBuffer(), req.getOffset(), req.getLength());
                }
                catch (IOException x) {
                    iox = x;
                }
                if (n > 0 || iox != null) {
                    object = AsyncHttpSession.this.lock;
                    synchronized (object) {
                        req = this.activeRead;
                        this.activeRead = null;
                    }
                    if (iox != null) {
                        req.fail(iox);
                    } else {
                        req.complete(n);
                    }
                    req.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readDone(AsyncIORequest req) {
            int n = 0;
            IOException iox = null;
            AsyncIORequestImpl r = null;
            try {
                n = req.finishRequest();
                this.in.transfer(n);
            }
            catch (IOException x) {
                iox = x;
                this.in.detach();
            }
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                r = this.activeRead;
                this.activeRead = null;
            }
            if (iox != null) {
                r.fail(iox);
            } else if (n > 0) {
                r.complete(n);
            } else {
                LogSupport.error(this, "readDone", "0 byte read completion.");
            }
            r.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeDone(AsyncIORequest req) {
            int n = 0;
            IOException iox = null;
            AsyncIORequestImpl r = null;
            try {
                n = req.finishRequest();
                this.out.transfer(n);
            }
            catch (IOException x) {
                iox = x;
                this.out.detach();
            }
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                r = this.activeWrite;
                this.activeWrite = null;
            }
            if (iox != null) {
                r.fail(iox);
            } else {
                r.complete(n);
            }
            r.dispose();
        }
    }

    class HDSessionEndpoint
    extends SessionEndpoint {
        private CircularBuffer inBuffer;
        private CircularBuffer outBuffer;
        private byte[] inXfer;
        private byte[] outXfer;
        private CircularBuffer.BlockedReadHook readHook;
        private CircularBuffer.BlockedWriteHook writeHook;
        private CircularBuffer.BlockedReadHook copyOutHook;
        private CircularBuffer.BlockedWriteHook copyInHook;
        private int copyInOff;
        private int copyInLen;
        private long lastTransaction;
        private long readTimeout;
        private LightweightTimer readWatchdog;

        public HDSessionEndpoint(ConnectionInfo inf) {
            super(inf);
            this.inBuffer = new CircularBuffer(65536);
            this.outBuffer = new CircularBuffer(65536);
            this.inXfer = new byte[1024];
            this.outXfer = new byte[1024];
            this.copyInOff = 0;
            this.copyInLen = 0;
            this.readTimeout = 0L;
            this.inBuffer.setExceptionMode(1);
            this.inBuffer.setDiagnosticName("recv");
            this.outBuffer.setExceptionMode(2);
            this.outBuffer.setDiagnosticName("xmit");
            this.readHook = new CircularBuffer.BlockedReadHook(){

                @Override
                public void readAvailable() {
                    HDSessionEndpoint.this.resumeRead();
                }
            };
            this.writeHook = new CircularBuffer.BlockedWriteHook(){

                @Override
                public void writeAvailable() {
                    HDSessionEndpoint.this.resumeWrite();
                }
            };
            this.copyOutHook = new CircularBuffer.BlockedReadHook(){

                @Override
                public void readAvailable() {
                    HDSessionEndpoint.this.copyOut();
                }
            };
            this.copyInHook = new CircularBuffer.BlockedWriteHook(){

                @Override
                public void writeAvailable() {
                    HDSessionEndpoint.this.resumeCopyIn();
                }
            };
            this.readWatchdog = new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    HDSessionEndpoint.this.checkTimeout();
                }
            });
            this.readWatchdog.scheduleEvery(10000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int beginReadImpl(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.activeRead != null) {
                    throw new IllegalStateException("multiple simultaneous async read operations");
                }
                if (AsyncHttpSession.this.closed) {
                    throw new IOException("Endpoint is closed");
                }
                if (AsyncHttpSession.this.pendingException != null) {
                    throw AsyncHttpSession.this.pendingException;
                }
                this.activeRead = AsyncIORequestImpl.getReadReq(this, buffer, off, len, this, lst);
            }
            IOException iox = null;
            int n = 0;
            try {
                n = this.actualRead(this.activeRead, buffer, off, len);
            }
            catch (IOException x) {
                iox = x;
            }
            if (n > 0 || iox != null) {
                AsyncIORequestImpl req;
                Object object2 = AsyncHttpSession.this.lock;
                synchronized (object2) {
                    req = this.activeRead;
                    this.activeRead = null;
                }
                req.dispose();
            } else if (this.options.getSoTimeout() > 0) {
                Object object3 = AsyncHttpSession.this.lock;
                synchronized (object3) {
                    this.readTimeout = System.currentTimeMillis() + (long)this.options.getSoTimeout();
                }
            }
            if (iox != null) {
                throw iox;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int beginWrite(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.activeWrite != null) {
                    throw new IllegalStateException("multiple simultaneous async write operations");
                }
                if (AsyncHttpSession.this.closed) {
                    throw new IOException("Endpoint is closed");
                }
                if (AsyncHttpSession.this.pendingException != null) {
                    throw AsyncHttpSession.this.pendingException;
                }
                this.activeWrite = AsyncIORequestImpl.getWriteReq(this, buffer, off, len, this, lst);
            }
            IOException iox = null;
            int n = 0;
            try {
                n = this.actualWrite(this.activeWrite, buffer, off, len);
            }
            catch (IOException x) {
                iox = x;
            }
            if (n > 0 || iox != null) {
                AsyncIORequestImpl req;
                Object object2 = AsyncHttpSession.this.lock;
                synchronized (object2) {
                    req = this.activeWrite;
                    this.activeWrite = null;
                }
                req.dispose();
            }
            if (iox != null) {
                throw iox;
            }
            return n;
        }

        @Override
        public int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
            return this.inBuffer.read(buf, off, len, this.readHook);
        }

        @Override
        public int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
            return this.outBuffer.write(buf, off, len, this.writeHook);
        }

        @Override
        protected int bytesAvailable() {
            this.lastTransaction = System.currentTimeMillis();
            this.checkTimeout();
            return this.outBuffer.nBytesReadable();
        }

        @Override
        protected void processReadAttach(AsyncHttpServerConnection c, int len) throws IOException {
            this.copyOut();
        }

        @Override
        protected void processWriteAttach(AsyncHttpServerConnection c, int len) throws IOException {
            this.copyIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyIn() {
            AsyncEndpoint ep = this.in.getEndpoint();
            boolean done = false;
            while (!done && this.in.getLength() > 0) {
                int nBytes = Math.min(this.in.getLength(), this.inXfer.length);
                try {
                    if (!ep.beginReadFully(this.inXfer, 0, nBytes, this.listener)) break;
                    Object object = AsyncHttpSession.this.lock;
                    synchronized (object) {
                        this.copyInOff = 0;
                        this.copyInLen = nBytes;
                    }
                    done = this.doCopyIn();
                    if (this.copyInLen <= 0) continue;
                }
                catch (IOException iox) {
                    this.inBuffer.post(iox);
                    this.in.detach();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readDone(AsyncIORequest req) {
            try {
                boolean done = false;
                this.readTimeout = 0L;
                req.finishRequest();
                Object object = AsyncHttpSession.this.lock;
                synchronized (object) {
                    this.copyInOff = 0;
                    this.copyInLen = req.getLength();
                }
                done = this.doCopyIn();
                if (this.copyInLen == 0 && !done) {
                    this.copyIn();
                }
            }
            catch (IOException iox) {
                this.inBuffer.post(iox);
                this.in.detach();
                return;
            }
        }

        private void resumeCopyIn() {
            boolean done = this.doCopyIn();
            if (this.copyInLen == 0 && !done) {
                this.copyIn();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doCopyIn() {
            boolean done = false;
            try {
                int n;
                while (this.copyInLen > 0 && !done && (n = this.inBuffer.write(this.inXfer, this.copyInOff, this.copyInLen, this.copyInHook)) > 0) {
                    Object object = AsyncHttpSession.this.lock;
                    synchronized (object) {
                        this.copyInOff += n;
                        this.copyInLen -= n;
                    }
                    done = this.in.transfer(n);
                }
            }
            catch (IOException iox) {
                LogSupport.exception(this, "resumeCopyIn", iox, true);
            }
            return done;
        }

        private void copyOut() {
            AsyncEndpoint ep = this.out.getEndpoint();
            while (this.out.getLength() > 0) {
                int nBytes = Math.min(this.out.getLength(), this.outXfer.length);
                try {
                    int n = this.outBuffer.read(this.outXfer, 0, nBytes, this.copyOutHook);
                    if (n <= 0 || !ep.beginWriteFully(this.outXfer, 0, n, this.listener)) break;
                    if (!this.out.transfer(n)) continue;
                }
                catch (IOException iox) {
                    this.outBuffer.post(iox);
                    this.out.detach();
                }
                break;
            }
        }

        @Override
        protected void writeDone(AsyncIORequest req) {
            try {
                req.finishRequest();
                if (this.out.transfer(req.getLength())) {
                    return;
                }
            }
            catch (IOException iox) {
                this.outBuffer.post(iox);
                this.out.detach();
                return;
            }
            this.copyOut();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resumeRead() {
            int nRead = 0;
            IOException iox = null;
            AsyncIORequestImpl req = this.activeRead;
            if (req == null) {
                return;
            }
            try {
                nRead = this.actualRead(req, req.getBuffer(), req.getOffset(), req.getLength());
            }
            catch (IOException x) {
                iox = x;
            }
            if (iox != null || nRead > 0) {
                Object object = AsyncHttpSession.this.lock;
                synchronized (object) {
                    this.readTimeout = 0L;
                    req = this.activeRead;
                    this.activeRead = null;
                }
                if (iox != null) {
                    req.fail(iox);
                } else {
                    req.complete(nRead);
                }
                req.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resumeWrite() {
            int nWritten = 0;
            IOException iox = null;
            AsyncIORequestImpl req = this.activeWrite;
            if (req == null) {
                return;
            }
            try {
                nWritten = this.actualWrite(req, req.getBuffer(), req.getOffset(), req.getLength());
            }
            catch (IOException x) {
                iox = x;
            }
            if (iox != null || nWritten > 0) {
                Object object = AsyncHttpSession.this.lock;
                synchronized (object) {
                    req = this.activeWrite;
                    this.activeWrite = null;
                }
                if (iox != null) {
                    req.fail(iox);
                } else {
                    req.complete(nWritten);
                }
                req.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTimeout() {
            long now = System.currentTimeMillis();
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                if (this.readTimeout > 0L && this.readTimeout < now) {
                    this.inBuffer.post(new InterruptedIOException());
                } else if (this.lastTransaction + 5000L < now) {
                    this.inBuffer.post(new IOException("HTTP Request idle timeout."));
                }
            }
        }
    }

    abstract class SessionEndpoint
    extends AbstractAsyncEndpoint
    implements AsyncIOHandler {
        protected EndpointOptions options = new EndpointOptions();
        protected AsyncIORequestImpl activeRead = null;
        protected AsyncIORequestImpl activeWrite = null;
        protected Attachment in = new Attachment(this.options);
        protected Attachment out = new Attachment(this.options);
        protected ConnectionInfo connectionInfo;
        protected AsyncIOListener listener;

        public SessionEndpoint(ConnectionInfo inf) {
            this.connectionInfo = inf;
            this.listener = new AsyncIOAdapter(){

                @Override
                public void readComplete(AsyncIORequest req) {
                    SessionEndpoint.this.readDone(req);
                }

                @Override
                public void writeComplete(AsyncIORequest req) {
                    SessionEndpoint.this.writeDone(req);
                }
            };
        }

        @Override
        public boolean actualClose(AsyncIORequestImpl req) throws IOException {
            AsyncHttpSession.this.closed = true;
            this.shutdown(null);
            return true;
        }

        @Override
        public boolean actualConnect(AsyncIORequestImpl req, InetAddress addr, int port) throws IOException {
            return false;
        }

        @Override
        public void beginConnect(InetAddress addr, int port, AsyncIOListener lst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.connectionInfo.remoteAddr;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.connectionInfo.localAddr;
        }

        @Override
        public int getLocalPort() {
            return this.connectionInfo.localPort;
        }

        @Override
        public int getPort() {
            return this.connectionInfo.remotePort;
        }

        @Override
        public int getLinger() throws SocketException {
            return this.options.getSoLinger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLinger(int linger) throws SocketException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                this.options.setSoLinger(linger > 0, linger);
                AsyncEndpoint aep = this.out.getEndpoint();
                if (aep != null) {
                    aep.setLinger(linger);
                }
            }
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.options.getTcpNoDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                this.options.setTcpNoDelay(on);
                AsyncEndpoint aep = this.out.getEndpoint();
                if (aep != null) {
                    aep.setTcpNoDelay(on);
                }
            }
        }

        @Override
        public int getTimeout() {
            return this.options.getSoTimeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeout(int timeout) {
            Object object = AsyncHttpSession.this.lock;
            synchronized (object) {
                this.options.setSoTimeout(timeout);
                AsyncEndpoint aep = this.in.getEndpoint();
                if (aep != null) {
                    aep.setTimeout(timeout);
                }
            }
        }

        private void readAttach(AsyncHttpServerConnection c, int len) throws IOException {
            try {
                this.out.attach(c, len);
                this.processReadAttach(c, len);
            }
            catch (IOException iox) {
                if (AsyncHttpSession.this.endpoint != null) {
                    AsyncHttpSession.this.endpoint.shutdown(iox);
                }
                throw iox;
            }
        }

        protected abstract void processReadAttach(AsyncHttpServerConnection var1, int var2) throws IOException;

        private void writeAttach(AsyncHttpServerConnection c, int len) throws IOException {
            try {
                this.in.attach(c, len);
                this.processWriteAttach(c, len);
            }
            catch (IOException iox) {
                if (AsyncHttpSession.this.endpoint != null) {
                    AsyncHttpSession.this.endpoint.shutdown(iox);
                }
                throw iox;
            }
        }

        protected abstract void processWriteAttach(AsyncHttpServerConnection var1, int var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown(IOException iox) {
            HashMap hashMap = sessionMap;
            synchronized (hashMap) {
                sessionMap.remove(new Integer(AsyncHttpSession.this.getID()));
            }
            this.in.close();
            this.out.close();
            AsyncHttpSession.this.pendingException = iox;
        }

        protected int bytesAvailable() {
            return 0;
        }

        protected abstract void readDone(AsyncIORequest var1);

        protected abstract void writeDone(AsyncIORequest var1);
    }
}

