/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncServerEndpoint;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointListener;
import com.elluminate.net.ThreadedAsyncEndpoint;
import com.elluminate.util.CircularWorkQueue;
import com.elluminate.util.WorkerPool;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.io.InterruptedIOException;

public class ThreadedAsyncServerEndpoint
extends AsyncServerEndpoint {
    private EndpointListener lst;
    private Thread thread;
    private volatile boolean isOpen = true;
    private static CircularWorkQueue queue = new CircularWorkQueue(512);
    private static WorkerPool pool = new WorkerPool("ThreadedAsyncEndpointWorker", queue, 8);
    private Runnable closer = new Runnable(){

        @Override
        public void run() {
            try {
                ThreadedAsyncServerEndpoint.this.listener.asyncClose(ThreadedAsyncServerEndpoint.this);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            ThreadedAsyncServerEndpoint.this.doListen();
        }
    };

    @Override
    public void parseProtocols(String protocols) throws IOException {
        this.lst = new EndpointListener(protocols, this.port, this.backlog, this.bindAddr);
        this.thread = new Thread(this.runnable, "ThreadedAsyncServerEndpoint listener");
        this.thread.start();
    }

    @Override
    public void beginClose() {
        this.isOpen = false;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListen() {
        while (this.isOpen) {
            try {
                Endpoint ep;
                try {
                    ep = this.lst.accept();
                }
                catch (InterruptedIOException ix) {
                    continue;
                }
                catch (IOException t) {
                    queue.execute(new ExRun(t));
                    while (this.isOpen) {
                        ThreadedAsyncServerEndpoint threadedAsyncServerEndpoint = this;
                        synchronized (threadedAsyncServerEndpoint) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ix) {
                                // empty catch block
                            }
                        }
                    }
                    continue;
                }
                ThreadedAsyncEndpoint aep = new ThreadedAsyncEndpoint(ep);
                queue.execute(new AcceptRun(aep));
            }
            catch (Throwable throwable) {}
        }
        queue.execute(this.closer);
    }

    class AcceptRun
    implements Runnable {
        AsyncEndpoint aep;

        public AcceptRun(AsyncEndpoint ep) {
            this.aep = ep;
        }

        @Override
        public void run() {
            try {
                ThreadedAsyncServerEndpoint.this.listener.asyncAccept(this.aep);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
        }
    }

    class ExRun
    implements Runnable {
        IOException iox;

        public ExRun(IOException x) {
            this.iox = x;
        }

        @Override
        public void run() {
            try {
                ThreadedAsyncServerEndpoint.this.listener.asyncException(ThreadedAsyncServerEndpoint.this, this.iox);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
        }
    }
}

