/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AbstractEndpointSecurity;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.AsyncSecureRequest;
import com.elluminate.net.AsyncSecurityListener;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.net.EndpointSecurityException;
import com.elluminate.net.FilterAsyncEndpoint;
import com.elluminate.net.NetDebug;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.net.ThreadedAsyncEndpoint;
import com.elluminate.platform.Platform;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;

public class AsyncEndpointSecurity
extends AbstractEndpointSecurity {
    private static boolean enabled = true;

    private AsyncEndpointSecurity() {
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isAvailable() {
        try {
            AsyncEndpointSecurity.setup();
            if (Platform.checkJavaVersion("1.4*")) {
                return enabled;
            }
            if (Platform.checkJavaVersion("1.5+")) {
                return createEngine != null;
            }
            return AbstractEndpointSecurity.isAvailable();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void isSecureCaller(AsyncEndpoint aep, AsyncSecurityListener asl) {
        SSLCheck check = new SSLCheck(aep, asl);
        check.execute();
    }

    public static AsyncEndpoint secureServer(AsyncEndpoint aep, File keystore, char[] keypass, File truststore, char[] trustpass, boolean authClient, AsyncSecurityListener asl) throws IOException, FileNotFoundException, EndpointSecurityException {
        if (aep.isSecure()) {
            throw new EndpointSecurityException("Endpoint is already secure.");
        }
        AsyncEndpoint actual = aep;
        while (actual instanceof FilterAsyncEndpoint) {
            actual = ((FilterAsyncEndpoint)actual).real;
        }
        if (actual instanceof ThreadedAsyncEndpoint) {
            ThreadedAsyncEndpoint tae = (ThreadedAsyncEndpoint)actual;
            tae.ep = EndpointSecurity.secureServer(tae.ep, keystore, keypass, truststore, trustpass, authClient);
            String alg = EndpointSecurity.getCipher(tae.ep);
            tae.secure = true;
            new AsyncSecureRequest(aep, asl).dispatch(alg);
            return aep;
        }
        SSLContext context = AsyncEndpointSecurity.getContext(keystore, keypass, truststore, trustpass);
        Object engine = AsyncEndpointSecurity.getSSLEngine(context);
        return AsyncEndpointSecurity.getServerEndpoint(aep, engine, authClient, asl);
    }

    public static AsyncEndpoint secureClient(AsyncEndpoint aep, AsyncSecurityListener asl) throws IOException, EndpointSecurityException {
        if (aep.isSecure()) {
            throw new EndpointSecurityException("Endpoint is already secure.");
        }
        if (aep instanceof ThreadedAsyncEndpoint) {
            ThreadedAsyncEndpoint tae = (ThreadedAsyncEndpoint)aep;
            tae.ep = EndpointSecurity.secureClient(tae.ep, tae.getCalledName(), tae.getCalledPort());
            String alg = EndpointSecurity.getCipher(tae.ep);
            tae.secure = true;
            new AsyncSecureRequest(aep, asl).dispatch(alg);
            return tae;
        }
        SSLContext context = AsyncEndpointSecurity.getDefaultContext();
        Object engine = AsyncEndpointSecurity.getSSLEngine(context);
        return AsyncEndpointSecurity.getClientEndpoint(aep, engine, asl);
    }

    public static void verifyDestination(AsyncEndpoint aep, String calledName, SSLTargetQuery query) throws EndpointSecurityException {
        X509Certificate[] chain;
        if (!aep.isSecure()) {
            return;
        }
        if (aep instanceof ThreadedAsyncEndpoint) {
            ThreadedAsyncEndpoint tae = (ThreadedAsyncEndpoint)aep;
            EndpointSecurity.verifyDestination(tae.ep, calledName, query);
            return;
        }
        if (!asyncSSLEndpointCls.isInstance(aep)) {
            return;
        }
        try {
            chain = (X509Certificate[])getAsyncCertChain.invoke((Object)aep, emptyArgs);
            if (chain == null) {
                throw new EndpointSecurityException("Unable to get the certificate chain.");
            }
        }
        catch (Throwable t) {
            throw new EndpointSecurityException("Unable to get the certificate chain.");
        }
        AsyncEndpointSecurity.verifyDestination(aep.getInetAddress(), chain, calledName, query);
    }

    private static Object getSSLEngine(Object factory) throws EndpointSecurityException {
        if (createEngine == null) {
            throw new EndpointSecurityException("AsyncEndpointSecurity is not available.");
        }
        try {
            Object engine = createEngine.invoke(factory, emptyArgs);
            return engine;
        }
        catch (IllegalAccessException iax) {
            throw new EndpointSecurityException("Unable to create ssl engine - " + iax.getMessage());
        }
        catch (InvocationTargetException itx) {
            throw new EndpointSecurityException(itx.getCause().getMessage());
        }
    }

    private static AsyncEndpoint getClientEndpoint(AsyncEndpoint real, Object engine, AsyncSecurityListener asl) throws EndpointSecurityException {
        Object[] args = new Object[]{real, engine, asl};
        try {
            return (AsyncEndpoint)clientAsyncSSLEndpoint.newInstance(args);
        }
        catch (InstantiationException ix) {
            throw new EndpointSecurityException(ix.getCause().getMessage());
        }
        catch (IllegalAccessException iax) {
            throw new EndpointSecurityException("Unable to create ssl endpoint - " + iax.getMessage());
        }
        catch (InvocationTargetException itx) {
            throw new EndpointSecurityException(itx.getCause().getMessage());
        }
    }

    private static AsyncEndpoint getServerEndpoint(AsyncEndpoint real, Object engine, boolean authClient, AsyncSecurityListener asl) throws EndpointSecurityException {
        Object[] args = new Object[]{real, engine, new Boolean(authClient), asl};
        try {
            return (AsyncEndpoint)serverAsyncSSLEndpoint.newInstance(args);
        }
        catch (InstantiationException ix) {
            throw new EndpointSecurityException(ix.getCause().getMessage());
        }
        catch (IllegalAccessException iax) {
            throw new EndpointSecurityException("Unable to create ssl endpoint - " + iax.getMessage());
        }
        catch (InvocationTargetException itx) {
            throw new EndpointSecurityException(itx.getCause().getMessage());
        }
    }

    static class SSLCheck
    extends AsyncIOAdapter {
        AsyncSecurityListener asl;
        AsyncEndpoint aep;
        int timeout;
        int off = 0;
        int len = 0;
        int checking = 0;
        byte[] buffer;
        int[][] signatures = new int[][]{AbstractEndpointSecurity.TLSv1_HANDSHAKE, AbstractEndpointSecurity.SSLv3_HANDSHAKE, AbstractEndpointSecurity.SSLv2_HANDSHAKE};
        int nActive = this.signatures.length;

        public SSLCheck(AsyncEndpoint aep, AsyncSecurityListener asl) {
            this.aep = aep;
            this.asl = asl;
            for (int i = 0; i < this.signatures.length; ++i) {
                if (this.signatures[i].length <= this.len) continue;
                this.len = this.signatures[i].length;
            }
            this.buffer = new byte[this.len];
        }

        @Override
        public void readComplete(AsyncIORequest req) {
            try {
                int n = req.finishRequest();
                do {
                    if (this.processRead(n)) continue;
                    return;
                } while ((n = this.aep.beginRead(this.buffer, this.off, this.len, this)) > 0);
            }
            catch (Throwable t) {
                this.report(false);
            }
        }

        public void execute() {
            int n = 0;
            try {
                this.timeout = this.aep.getTimeout();
                this.aep.setTimeout(2000);
                while ((n = this.aep.beginRead(this.buffer, this.off, this.len, this)) > 0) {
                    if (this.processRead(n)) continue;
                    return;
                }
            }
            catch (Throwable t) {
                this.report(false);
            }
        }

        private void report(boolean value) {
            this.aep.setTimeout(this.timeout);
            this.aep.unread(this.buffer, 0, this.off);
            try {
                this.asl.isSecureCallerComplete(this.aep, value);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "report", t, true);
            }
        }

        private boolean processRead(int n) {
            while (n > 0) {
                int c = this.buffer[this.off] & 0xFF;
                for (int i = 0; i < this.signatures.length; ++i) {
                    if (this.signatures[i] != null) {
                        if (NetDebug.SSL_CALLER.show()) {
                            LogSupport.message(this, "processRead", "Checking signature " + i + ": sig=" + this.signatures[i][this.off] + ", read=" + c);
                        }
                        if (!AbstractEndpointSecurity.checkSignature(c, this.signatures[i][this.off])) {
                            if (NetDebug.SSL_CALLER.show()) {
                                LogSupport.message(this, "processRead", "Aborting signature " + i);
                            }
                            this.signatures[i] = null;
                            --this.nActive;
                            if (this.nActive != 0) continue;
                            if (NetDebug.SSL_CALLER.show()) {
                                LogSupport.message(this, "processRead", "No matching signature found.");
                            }
                            this.len -= n;
                            this.off += n;
                            this.report(false);
                            return false;
                        }
                        if (this.off != this.signatures[i].length - 1) continue;
                        if (NetDebug.SSL_CALLER.show()) {
                            LogSupport.message(this, "processRead", "Matched signature " + i);
                        }
                        this.len -= n;
                        this.off += n;
                        this.report(true);
                        return false;
                    }
                    if (!NetDebug.SSL_CALLER.show()) continue;
                    LogSupport.message(this, "processRead", "Skipping signature " + i);
                }
                --n;
                --this.len;
                ++this.off;
            }
            return true;
        }
    }
}

