/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.StringsProperties;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class QuizRequestException
extends QuizException {
    private static I18n i18n = I18n.create(QuizRequestException.class);
    private static final short NONE = 0;
    private short who = (short)-32767;
    private short state = 0;
    private String message = "";

    public QuizRequestException(byte reason) {
        this(reason, 0L, -32767);
    }

    public QuizRequestException(byte reason, long id) {
        this(reason, id, -32767);
    }

    public QuizRequestException(byte reason, long id, short arg) {
        this(reason, id, arg, null);
    }

    public QuizRequestException(byte reason, String message) {
        this(reason, 0L, 0, message);
    }

    public QuizRequestException(byte reason, long id, String message) {
        this(reason, id, 0, message);
    }

    public QuizRequestException(byte reason, long id, short arg, String message) {
        this.reason = reason;
        this.id = id;
        String string = this.message = message == null ? "" : message;
        if (reason == 97) {
            this.who = arg;
        } else if (reason == 101) {
            this.state = arg;
        }
    }

    public QuizRequestException(ChannelDataEvent e) throws IOException {
        this(e.getCommand(), e.read(), true);
    }

    public QuizRequestException(byte cmd, DataInputStream in, boolean close) throws IOException {
        this.reason = cmd;
        this.request = in.readByte();
        this.id = in.readLong();
        this.message = in.readUTF();
        if (this.reason == 97) {
            this.who = in.readShort();
        } else if (this.reason == 101) {
            this.state = in.readShort();
        }
        if (close) {
            in.close();
        }
    }

    @Override
    public void encode(DataOutputStream out, boolean close) {
        try {
            out.writeByte(this.request);
            out.writeLong(this.id);
            out.writeUTF(this.message);
            if (this.reason == 97) {
                out.writeShort(this.who);
            } else if (this.reason == 101) {
                out.writeShort(this.state);
            }
            if (close) {
                out.close();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encode", (Throwable)ex, (boolean)true);
        }
    }

    public short getAddress() {
        return this.who;
    }

    public String getName() {
        if (this.who == -32767) {
            return i18n.getStringLegacy("QuizRequestException.nobody");
        }
        if (this.clients == null) {
            return Short.toString(this.who);
        }
        ClientInfo ci = this.clients.get(this.who);
        if (ci == null) {
            return i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_NOTFOUND) + "(" + this.who + ")";
        }
        return ci.getDisplayName();
    }

    public short getState() {
        return this.state;
    }

    public String getStateName() {
        switch (this.state) {
            case 0: {
                return "Idle";
            }
            case 1: {
                return "Setup";
            }
            case 2: {
                return "Testing";
            }
            case 3: {
                return "Cleanup";
            }
            case 4: {
                return "Done";
            }
            case 5: {
                return "Review";
            }
        }
        return "Unknown state " + this.state;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        String msg = "";
        switch (this.reason) {
            case 100: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_NOACCESS);
                break;
            }
            case 98: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_NOACCESS);
                break;
            }
            case 97: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_LOCKED, new Object[]{this.getName()});
                break;
            }
            case 99: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_NOTFOUND);
                break;
            }
            case 101: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_INVALIDSTATE, new Object[]{this.getStateName()});
                break;
            }
            case 102: {
                msg = i18n.getString((PropertiesEnum)StringsProperties.QUIZREQUESTEXCEPTION_NOSTUDENTS);
            }
        }
        String extra = super.getMessage();
        if (extra != null) {
            if (!msg.equals("")) {
                msg = msg + "\n  ";
            }
            msg = msg + extra;
        }
        return msg;
    }
}

