/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizInvalidException;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.QuizReadException;
import com.elluminate.groupware.quiz.QuizStats;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.groupware.quiz.Responses;
import com.elluminate.groupware.quiz.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class Quiz
extends QuizPart
implements Cloneable {
    private static I18n i18n = I18n.create(Quiz.class);
    private String me = null;
    private long id = 0L;
    private ArrayList questions = new ArrayList();
    private Responses markingGuide = null;
    private HashMap participants = new HashMap();
    private QuizStats stats = null;
    private Date dateGiven = null;
    private byte state = 0;

    public Quiz() {
        this(i18n.getString((PropertiesEnum)StringsProperties.QUIZ_DEFAULTTITLE));
    }

    public Quiz(String title) {
        this.setText(title);
        this.state = (byte)3;
    }

    public Quiz(DataInputStream str, boolean readMG, boolean readResp, boolean readStats, boolean readDate) throws IOException {
        int i;
        this.id = str.readLong();
        this.state = str.readByte();
        this.setText(str.readUTF());
        int count = str.readInt();
        this.questions = new ArrayList(count);
        for (i = 0; i < count; i = (short)(i + 1)) {
            Question q = new Question(str);
            this.questions.add(i, q);
            this.addQuizListener(q);
            q.setParent(this);
            q.setIndex((short)i);
        }
        if (readMG) {
            this.markingGuide = new Responses(str);
        }
        if (readResp) {
            count = str.readInt();
            for (i = 0; i < count; ++i) {
                Responses resp = new Responses(str);
                this.participants.put(resp.getResponseOwner(), resp);
            }
        }
        if (readStats) {
            this.stats = new QuizStats(str);
        }
        if (readDate) {
            this.dateGiven = new Date(str.readLong());
        }
    }

    public void encode(DataOutputStream str, boolean writeMG, boolean writeResp, boolean writeStats, boolean writeDate) throws IOException {
        str.writeLong(this.id);
        str.write(this.state);
        str.writeUTF(this.getText());
        str.writeInt(this.questions.size());
        for (Question q : this.questions) {
            q.encode(str);
        }
        if (writeMG) {
            this.markingGuide.encode(str);
        }
        if (writeResp) {
            str.writeInt(this.getParticipantCount());
            for (String who : this.participants.keySet()) {
                Responses r = this.getResponsesFor(who);
                if (r == null) {
                    new Responses(who).encode(str);
                    continue;
                }
                r.encode(str);
            }
        }
        if (writeStats && this.stats != null) {
            this.stats.encode(str);
        }
        if (writeDate && this.dateGiven != null) {
            str.writeLong(this.dateGiven.getTime());
        }
    }

    public void setMyName(String name) {
        this.me = name;
        this.fireQuizChange((byte)1);
    }

    public String getMyName() {
        return this.me;
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public boolean hasDateGiven() {
        return this.dateGiven != null;
    }

    public Date getDateGiven() {
        return this.dateGiven;
    }

    public void setDateGiven(Date when) {
        this.dateGiven = when;
    }

    public boolean hasStats() {
        return this.stats != null;
    }

    public void computeStats() {
        this.stats = new QuizStats(this);
        this.fireQuizChange((byte)2);
    }

    public void mergeStats(Quiz other) {
        if (other.stats != null) {
            this.stats = other.stats;
            this.fireQuizChange((byte)2);
        }
    }

    @Override
    public short getStatsTotal() {
        if (this.stats == null) {
            return 0;
        }
        return this.stats.getTotal();
    }

    @Override
    public short getStatsCount() {
        short count = 0;
        Iterator i = this.participants.keySet().iterator();
        while (i.hasNext()) {
            if (this.participants.get(i.next()) == null) continue;
            count = (short)(count + 1);
        }
        return count;
    }

    public short getStatsCount(short question) {
        if (this.stats == null) {
            return 0;
        }
        return this.stats.getCount(question);
    }

    public short getStatsCount(short question, short answer) {
        if (this.stats == null) {
            return 0;
        }
        return this.stats.getCount(question, answer);
    }

    public short getQuestionCount() {
        return (short)this.questions.size();
    }

    public Iterator questionIterator() {
        return this.questions.iterator();
    }

    public Question getQuestion(short idx) {
        return (Question)this.questions.get(idx);
    }

    public void add(Question q) {
        this.add(q, this.getQuestionCount());
    }

    public void add(Question q, short idx) {
        this.checkIndicies();
        if (q.getParent() != null) {
            throw new RuntimeException("Add question already part of another quiz.");
        }
        this.questions.add(idx, q);
        q.setParent(this);
        this.addQuizListener(q);
        this.updateIndicies(this.getQuestionCount(), idx);
        this.fireQuizChange((byte)3, (byte)1, idx, (short)-1);
    }

    public void remove(Question q) {
        this.checkIndicies();
        if (q.getParent() != this) {
            throw new RuntimeException("Remove question not part of this quiz.");
        }
        short idx = (short)this.questions.indexOf(q);
        this.remove(idx);
    }

    public void remove(short idx) {
        this.checkIndicies();
        Question q = (Question)this.questions.get(idx);
        if (q.getParent() != this) {
            throw new RuntimeException("Remove question not part of this quiz.");
        }
        q.setParent(null);
        this.questions.remove(idx);
        this.removeQuizListener(q);
        this.updateIndicies(idx, this.getQuestionCount());
        this.fireQuizChange((byte)3, (byte)2, idx, (short)-1);
    }

    public void moveQuestion(short idx, short to) {
        this.checkIndicies();
        if (to < 0 || to >= this.questions.size()) {
            throw new RuntimeException("Destination index of question move(" + to + ") out of range (0.." + (this.questions.size() - 1) + ")");
        }
        if (idx == to) {
            return;
        }
        Question q = (Question)this.questions.get(idx);
        if (q.getParent() != this) {
            throw new RuntimeException("Move question not part of this quiz.");
        }
        this.questions.remove(idx);
        this.questions.add(to, q);
        this.updateIndicies(idx, to);
        this.fireQuizChange((byte)3, idx);
    }

    public boolean hasParticipants() {
        return this.getParticipantCount() > 0;
    }

    public int getParticipantCount() {
        return this.participants.size();
    }

    public Iterator participantIterator() {
        return Collections.unmodifiableSet(this.participants.keySet()).iterator();
    }

    public boolean hasMarkingGuide() {
        return this.markingGuide != null;
    }

    public void mergeCorrectResponses(Quiz other) {
        this.markingGuide = other.markingGuide;
        this.fireQuizChange((byte)1);
    }

    public short getCorrectCount() {
        short nCorrect = 0;
        for (short i = 0; i < this.getQuestionCount(); i = (short)(i + 1)) {
            Response correct = this.getCorrectResponse(i);
            if (correct == null) continue;
            Response mine = this.getResponseFor("  *** ME ***  ", i);
            if (correct.hasSelection()) {
                if (mine == null || mine.getSelection() != correct.getSelection()) continue;
                nCorrect = (short)(nCorrect + 1);
                continue;
            }
            if (mine == null || !mine.getText().equals(correct.getText())) continue;
            nCorrect = (short)(nCorrect + 1);
        }
        return nCorrect;
    }

    public short getIncorrectCount() {
        short nWrong = 0;
        for (short i = 0; i < this.getQuestionCount(); i = (short)(i + 1)) {
            Response correct = this.getCorrectResponse(i);
            Response mine = this.getResponseFor("  *** ME ***  ", i);
            if (correct == null) continue;
            if (correct.hasSelection()) {
                if (mine != null && mine.getSelection() == correct.getSelection()) continue;
                nWrong = (short)(nWrong + 1);
                continue;
            }
            if (mine != null) continue;
            nWrong = (short)(nWrong + 1);
        }
        return nWrong;
    }

    public short getUnmarkedCount() {
        short nUnmarked = 0;
        for (short i = 0; i < this.getQuestionCount(); i = (short)(i + 1)) {
            Response mine;
            Response correct = this.getCorrectResponse(i);
            if (correct != null && correct.hasSelection() || (mine = this.getResponseFor("  *** ME ***  ", i)) == null || mine.getText().equals(correct.getText())) continue;
            nUnmarked = (short)(nUnmarked + 1);
        }
        return nUnmarked;
    }

    public Response getCorrectResponse(short question) {
        if (this.markingGuide == null) {
            return null;
        }
        return this.markingGuide.getResponse(question);
    }

    public void setCorrectResponse(short question, Response resp) {
        if (this.markingGuide == null) {
            this.markingGuide = new Responses("  *** MARKING GUIDE ***  ");
        }
        this.markingGuide.setResponse(question, resp);
        this.fireQuizChange((byte)1, question);
    }

    public boolean hasResponses() {
        return this.getResponseCount() > 0;
    }

    public short getResponseCount() {
        short count = 0;
        Iterator i = this.participants.keySet().iterator();
        while (i.hasNext()) {
            if (this.participants.get(i.next()) == null) continue;
            count = (short)(count + 1);
        }
        return count;
    }

    public boolean isComplete() {
        return this.getCompleteCount() == this.getParticipantCount();
    }

    public short getCompleteCount() {
        short count = 0;
        Iterator i = this.participants.keySet().iterator();
        while (i.hasNext()) {
            Responses resp = (Responses)this.participants.get(i.next());
            if (resp == null || !resp.isComplete()) continue;
            count = (short)(count + 1);
        }
        return count;
    }

    public Response getResponseFor(String userName, short question) {
        Responses resp = this.getResponsesFor(userName);
        if (resp == null) {
            return null;
        }
        return resp.getResponse(question);
    }

    public void setResponseFor(String userName, short question, Response response) {
        Responses resp;
        if (userName.equals("  *** ME ***  ")) {
            if (this.me == null) {
                throw new IllegalStateException("Cant save quiz responses for ME without setting the user name for ME");
            }
            userName = this.me;
        }
        if ((resp = (Responses)this.participants.get(userName)) == null) {
            resp = new Responses(userName);
            this.participants.put(userName, resp);
        }
        resp.setResponse(question, response);
        if (userName.equals(this.me)) {
            this.fireQuizChange((byte)1, question);
        }
    }

    public Responses getResponsesFor(String userName) {
        if (userName.equals("  *** ME ***  ")) {
            userName = this.me;
        }
        return (Responses)this.participants.get(userName);
    }

    public void setResponsesFor(String userName, Responses responses) {
        this.participants.put(userName, responses);
        this.fireQuizChange((byte)1);
    }

    @Override
    public Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean full) {
        Quiz other = (Quiz)super.clone();
        other.questions = new ArrayList();
        for (int i = 0; i < this.questions.size(); ++i) {
            Question q = (Question)this.questions.get(i);
            Question c = (Question)q.clone();
            c.setParent(other);
            other.addQuizListener(c);
            other.questions.add(c);
        }
        if (this.markingGuide != null) {
            other.markingGuide = (Responses)this.markingGuide.clone();
        }
        other.participants = new HashMap();
        if (full) {
            for (String name : this.participants.keySet()) {
                Responses resp = (Responses)this.participants.get(name);
                if (resp == null) {
                    other.participants.put(name, resp);
                    continue;
                }
                other.participants.put(name, resp.clone());
            }
            if (this.stats != null) {
                other.stats = new QuizStats(other);
            }
        } else {
            other.id = 0L;
            other.stats = null;
            other.dateGiven = null;
        }
        return other;
    }

    public String toString() {
        String desc = this.getText();
        desc = this.dateGiven == null ? desc + " [" + i18n.getString((PropertiesEnum)StringsProperties.QUIZ_MASTER) + "]" : desc + " [" + i18n.getString((PropertiesEnum)StringsProperties.QUIZ_WRITTEN, new Object[]{this.dateGiven}) + "]";
        return desc;
    }

    public void checkIndicies() {
        try {
            for (short i = 0; i < this.questions.size(); i = (short)(i + 1)) {
                Question q = this.getQuestion(i);
                q.validate(this, i);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"checkIndicies", (Throwable)ex, (boolean)true);
            this.repair();
        }
    }

    private void repair() {
        for (short i = 0; i < this.questions.size(); i = (short)(i + 1)) {
            Question q = this.getQuestion(i);
            q.repair(this, i);
        }
        try {
            this.markingGuide.validate(this);
        }
        catch (Exception ex) {
            LogSupport.message((Object)this, (String)"checkIndicies", (String)("Marking guide corrupted - " + ex.toString() + "\nmarking guide discarded."));
            this.markingGuide = new Responses("  *** MARKING GUIDE ***  ");
        }
    }

    private void updateIndicies(short from, short to) {
        int delta = from > to ? -1 : 1;
        int max = this.getQuestionCount() - 1;
        Responses newMG = null;
        if (this.markingGuide != null) {
            newMG = (Responses)this.markingGuide.clone();
            newMG.trim(this.getQuestionCount());
        }
        short i = from;
        while (i != to + delta) {
            Question q;
            short old;
            if (i >= 0 && i <= max && (old = (q = this.getQuestion(i)).getIndex()) != i) {
                if (this.markingGuide != null) {
                    Response resp = this.getCorrectResponse(old);
                    newMG.setResponse(i, resp);
                }
                q.setIndex(i);
                this.fireQuizChange((byte)3, i);
            }
            i = (short)(i + delta);
        }
        this.markingGuide = newMG;
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("Quiz ");
        buf.append(this.id);
        buf.append(", nm='");
        buf.append(this.getText());
        buf.append("', me=");
        buf.append(this.getMyName());
        if (this.dateGiven != null) {
            buf.append(", date=");
            buf.append(this.dateGiven);
        }
        buf.append(":\n");
        for (Question q : this.questions) {
            buf.append(q.toString(prefix + "    "));
            buf.append("\n");
        }
        if (this.markingGuide != null) {
            buf.append(prefix);
            buf.append("  Marking Guide:\n");
            buf.append(this.markingGuide.toString(prefix + "    "));
        }
        if (this.participants != null && !this.participants.isEmpty()) {
            buf.append(prefix);
            buf.append("  Participants:\n");
            for (String nm : this.participants.keySet()) {
                Responses resp = (Responses)this.participants.get(nm);
                if (resp == null) {
                    buf.append(prefix);
                    buf.append("    No responses for '");
                    buf.append(nm);
                    buf.append("'\n");
                    continue;
                }
                buf.append(resp.toString(prefix + "    "));
            }
        }
        if (this.stats != null) {
            buf.append(prefix);
            buf.append("  Statistics:\n");
            buf.append(this.stats.toString(prefix + "    "));
        }
        return buf.toString();
    }

    public void validate() throws QuizException {
        String nm = this.getText();
        if (nm == null || nm.equals("")) {
            throw new QuizInvalidException("nullTitle", null);
        }
        if (this.getQuestionCount() == 0) {
            throw new QuizInvalidException("noQuestions", null);
        }
        Iterator q = this.questionIterator();
        while (q.hasNext()) {
            Question question = (Question)q.next();
            boolean hasMC = false;
            boolean hasSA = false;
            String quesTxt = question.getText();
            if (quesTxt == null || quesTxt.equals("")) {
                throw new QuizInvalidException("nullQuestion", null);
            }
            Iterator a = question.iterator();
            while (a.hasNext()) {
                Answer answer = (Answer)a.next();
                if (answer.isSelectable()) {
                    String ansTxt = answer.getText();
                    if (ansTxt == null || ansTxt.equals("")) {
                        throw new QuizInvalidException("nullAnswer", null);
                    }
                    hasMC = true;
                    continue;
                }
                if (hasSA) {
                    throw new QuizInvalidException("oneShortAnswer", quesTxt);
                }
                hasSA = true;
            }
            if (hasSA && hasMC) {
                throw new QuizInvalidException("mixedResponses", quesTxt);
            }
            if (!hasSA && !hasMC) {
                throw new QuizInvalidException("noResponses", quesTxt);
            }
            if (this.getCorrectResponse(question.getIndex()) != null) continue;
            throw new QuizInvalidException("noCorrectResponse", quesTxt);
        }
        this.markingGuide.validate(this);
        for (String name : this.participants.keySet()) {
            Responses resp = (Responses)this.participants.get(name);
            resp.validate(this);
        }
    }

    public void writeXML(Element top) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        top.setAttribute("title", this.getText());
        if (this.dateGiven != null) {
            top.setAttribute("dateGiven", fmt.format(this.dateGiven));
        }
        for (Question q : this.questions) {
            Element e = new Element("question");
            q.writeXML(e);
            top.addContent((Content)e);
        }
        if (this.markingGuide != null) {
            Element e = new Element("markingGuide");
            this.markingGuide.writeXML(e);
            top.addContent((Content)e);
        }
        for (String who : this.participants.keySet()) {
            Responses resp = (Responses)this.participants.get(who);
            Element e = new Element("response");
            if (resp == null) {
                resp = new Responses(who);
            }
            resp.writeXML(e);
            top.addContent((Content)e);
        }
        this.state = (byte)4;
    }

    public void readXML(String src, Element top) throws QuizException {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        Attribute attr = top.getAttribute("title");
        if (attr == null || attr.getValue().equals("")) {
            throw new QuizReadException(src, "noTitle");
        }
        this.setText(attr.getValue());
        attr = top.getAttribute("dateGiven");
        if (attr != null) {
            try {
                this.dateGiven = fmt.parse(attr.getValue());
            }
            catch (ParseException ex) {
                throw new QuizReadException(src, "invalidDate", attr.getValue());
            }
        }
        for (Element e : top.getChildren("question")) {
            Question q = new Question();
            q.readXML(src, e);
            this.add(q);
        }
        Element mg = top.getChild("markingGuide");
        if (mg == null) {
            throw new QuizReadException(src, "noMarkingGuide", this.getText());
        }
        Responses guide = new Responses("  *** MARKING GUIDE ***  ");
        guide.readXML(src, mg);
        this.markingGuide = guide;
        for (Element e : top.getChildren("response")) {
            Responses resp = new Responses("");
            resp.readXML(src, e);
            this.participants.put(resp.getResponseOwner(), resp);
        }
        this.state = 1;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public boolean needsSaving() {
        return this.state != 1 && this.state != 4;
    }
}

