/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.Response;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;

public class Question
extends QuizPart {
    private ArrayList answers = new ArrayList();

    public Question() {
    }

    public Question(String txt) {
        if (txt.equals(this.getText())) {
            return;
        }
        this.setText(txt);
        this.fireQuizChange((byte)4, this.getIndex());
    }

    public Question(DataInputStream str) throws IOException {
        this.setText(str.readUTF());
        int count = str.readInt();
        this.answers.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            Answer a = new Answer(str);
            this.addAnswer(a);
        }
    }

    public short getAnswerCount() {
        return (short)this.answers.size();
    }

    public Answer getAnswer(short idx) {
        return (Answer)this.answers.get(idx);
    }

    public void addAnswer(short idx, Answer answer) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            quiz.checkIndicies();
        }
        if (answer.getParent() != null) {
            throw new RuntimeException("Add answer already part of another question.");
        }
        this.answers.add(idx, answer);
        answer.setParent(this);
        this.addQuizListener(answer);
        this.updateIndicies(this.getAnswerCount(), idx);
        if (quiz != null) {
            short sel;
            Response resp = this.getCorrectResponse();
            if (resp != null && resp.hasSelection() && (sel = resp.getSelection()) >= idx) {
                sel = (short)(sel + 1);
                this.setCorrectResponse(new Response(sel));
            }
            quiz.fireQuizChange((byte)3, (byte)3, this.getIndex(), idx);
        }
    }

    public void addAnswer(Answer answer) {
        this.addAnswer(this.getAnswerCount(), answer);
    }

    public void remove(Answer answer) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            quiz.checkIndicies();
        }
        if (answer.getParent() != this) {
            throw new RuntimeException("Remove answer not part of theis question.");
        }
        short idx = (short)this.answers.indexOf(answer);
        answer.setParent(null);
        this.answers.remove(answer);
        this.removeQuizListener(answer);
        this.updateIndicies(idx, this.getAnswerCount());
        if (quiz != null) {
            Response resp = this.getCorrectResponse();
            if (resp != null) {
                if (resp.hasSelection()) {
                    short sel = resp.getSelection();
                    if (sel == idx) {
                        this.setCorrectResponse(null);
                    } else if (sel > idx) {
                        sel = (short)(sel - 1);
                        this.setCorrectResponse(new Response(sel));
                    }
                } else {
                    this.setCorrectResponse(null);
                }
            }
            quiz.fireQuizChange((byte)3, (byte)4, this.getIndex(), idx);
        }
    }

    public void moveAnswer(short idx, short to) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            quiz.checkIndicies();
        }
        if (to < 0 || to >= this.answers.size()) {
            throw new RuntimeException("Move answer not part of this question.");
        }
        Answer a = (Answer)this.answers.remove(idx);
        this.answers.add(to, a);
        this.updateIndicies(idx, to);
        if (quiz != null) {
            Response resp = this.getCorrectResponse();
            if (resp != null && resp.hasSelection()) {
                short sel = resp.getSelection();
                if (sel == idx) {
                    this.setCorrectResponse(new Response(to));
                } else if (to < idx && sel >= to && sel < idx) {
                    sel = (short)(sel + 1);
                    this.setCorrectResponse(new Response(sel));
                } else if (to > idx && sel <= to && sel > idx) {
                    sel = (short)(sel - 1);
                    this.setCorrectResponse(new Response(sel));
                }
            }
            quiz.fireQuizChange((byte)3, this.getIndex(), idx);
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.answers).iterator();
    }

    public boolean isShortAnswer() {
        if (this.answers.isEmpty()) {
            return false;
        }
        Answer a = (Answer)this.answers.get(0);
        return !a.isSelectable();
    }

    public boolean isMultipleChoice() {
        if (this.answers.isEmpty()) {
            return false;
        }
        Answer a = (Answer)this.answers.get(0);
        return a.isSelectable();
    }

    public Response getResponse() {
        return this.getResponseFor("  *** ME ***  ");
    }

    public Response getResponseFor(String name) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            return quiz.getResponseFor(name, this.getIndex());
        }
        return null;
    }

    public void setResponse(Response r) {
        this.setResponseFor("  *** ME ***  ", r);
    }

    public void setResponseFor(String name, Response r) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            quiz.setResponseFor(name, this.getIndex(), r);
        }
    }

    public Response getCorrectResponse() {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            return quiz.getCorrectResponse(this.getIndex());
        }
        return null;
    }

    public void setCorrectResponse(Response r) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            quiz.setCorrectResponse(this.getIndex(), r);
        }
    }

    @Override
    public short getStatsCount() {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            return quiz.getStatsCount(this.getIndex());
        }
        return 0;
    }

    public short getStatsCount(short answer) {
        Quiz quiz = (Quiz)this.getParent();
        if (quiz != null) {
            return quiz.getStatsCount(this.getIndex(), answer);
        }
        return 0;
    }

    public void validate(Quiz quiz, short idx) {
        if (this.getParent() != quiz) {
            throw new RuntimeException("Quiz tree structure corrupt.\nQuestion " + idx + " of quiz " + quiz.getText() + " has wrong parent.");
        }
        if (this.getIndex() != idx) {
            throw new RuntimeException("Index mismatch in question '" + this.getText() + "' of quiz " + quiz.getText() + "\n  actual=" + idx + ", stored=" + this.getIndex());
        }
        for (short i = 0; i < this.answers.size(); i = (short)(i + 1)) {
            Answer a = this.getAnswer(i);
            a.validate(this, i);
        }
    }

    public void repair(Quiz quiz, short idx) {
        this.setParent(quiz);
        this.setIndex(idx);
        for (short i = 0; i < this.answers.size(); i = (short)(i + 1)) {
            Answer a = this.getAnswer(i);
            a.repair(this, i);
        }
    }

    private void updateIndicies(short from, short to) {
        int delta = from < to ? 1 : -1;
        int max = this.getAnswerCount() - 1;
        short i = from;
        while (i != to + delta) {
            Answer answer;
            short prev;
            if (i >= 0 && i <= max && (prev = (answer = this.getAnswer(i)).getIndex()) != i) {
                this.getAnswer(i).setIndex(i);
                this.fireQuizChange((byte)3, this.getIndex(), prev);
            }
            i = (short)(i + delta);
        }
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 3) {
            return;
        }
        if (e.getQuestionIndex() == this.getIndex() || e.getQuestionIndex() == -1) {
            this.fireQuizChangeLocal(e);
        }
    }

    @Override
    public void fireTextChanged() {
        this.fireQuizChange((byte)4, this.getIndex());
    }

    @Override
    public Object clone() {
        Question other = (Question)super.clone();
        other.answers = new ArrayList();
        for (short i = 0; i < this.getAnswerCount(); i = (short)(i + 1)) {
            Answer a = this.getAnswer(i);
            Answer c = (Answer)a.clone();
            c.setParent(other);
            other.addQuizListener(c);
            other.answers.add(c);
        }
        return other;
    }

    public void encode(DataOutputStream str) throws IOException {
        str.writeUTF(this.getText());
        str.writeInt(this.getAnswerCount());
        for (short i = 0; i < this.getAnswerCount(); i = (short)(i + 1)) {
            this.getAnswer(i).encode(str);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("Question ");
        buf.append(this.getIndex());
        buf.append(": ");
        buf.append(this.getText());
        buf.append("\n");
        for (Answer a : this.answers) {
            buf.append(a.toString(prefix + "    "));
            buf.append("\n");
        }
        return buf.toString();
    }

    public void writeXML(Element top) {
        top.addContent(this.getText());
        for (Answer a : this.answers) {
            Element e = new Element("answer");
            a.writeXML(e);
            top.addContent((Content)e);
        }
    }

    public void readXML(String src, Element top) throws QuizException {
        this.setText(top.getTextTrim());
        for (Element e : top.getChildren("answer")) {
            Answer a = new Answer();
            a.readXML(src, e);
            this.addAnswer(a);
        }
    }
}

