/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.resampler;

import com.elluminate.groupware.audio.resampler.Complex;

public class ButterworthLPF {
    private int cutoffFreq = -1;
    private float dcGain = 0.0f;
    private int order;
    private int sampFreq = -1;
    private Complex[] sPoles;
    private float[] x;
    private float[] xCoeffs;
    private float[] y;
    private float[] yCoeffs;

    public ButterworthLPF(int order) {
        int i;
        if (order < 1) {
            throw new IllegalArgumentException("order (" + order + ") < 1");
        }
        this.order = order;
        this.sPoles = new Complex[order];
        this.x = new float[order + 1];
        this.xCoeffs = new float[order + 1];
        this.y = new float[order + 1];
        this.yCoeffs = new float[order];
        for (i = 0; i < order; ++i) {
            double angle = ((double)i + 0.5 * (double)(order + 1)) * Math.PI / (double)order;
            this.sPoles[i] = new Complex(Math.cos(angle), Math.sin(angle));
        }
        for (i = 0; i <= order; ++i) {
            int j;
            this.xCoeffs[i] = 1.0f;
            for (j = 0; j < i; ++j) {
                int n = i;
                this.xCoeffs[n] = this.xCoeffs[n] * (float)(order - j);
            }
            for (j = 2; j <= i; ++j) {
                int n = i;
                this.xCoeffs[n] = this.xCoeffs[n] / (float)j;
            }
        }
    }

    public void applyFilter(int sampFreq, int cutoffFreq, short[] srcBuf, int srcOff, int srcCnt, short[] resBuf, int resOff) {
        if (srcBuf == null) {
            throw new IllegalArgumentException("srcBuf = null");
        }
        if (srcOff < 0) {
            throw new IllegalArgumentException("srcOff (" + srcOff + ") < 0");
        }
        if (srcCnt < 0) {
            throw new IllegalArgumentException("srcCnt (" + srcCnt + ") < 0");
        }
        if (srcOff + srcCnt > srcBuf.length) {
            throw new IllegalArgumentException("srcOff (" + srcOff + ") + srcCnt (" + srcCnt + ") > srcBuf.length (" + srcBuf.length + ")");
        }
        if (resOff < 0) {
            throw new IllegalArgumentException("resOff (" + resOff + ") < 0");
        }
        if (resOff + srcCnt > resBuf.length) {
            throw new IllegalArgumentException("resOff (" + resOff + ") + srcCnt (" + srcCnt + ") > resBuf.length (" + resBuf.length + ")");
        }
        if (sampFreq != this.sampFreq || cutoffFreq != this.cutoffFreq) {
            this.designFilter(sampFreq, cutoffFreq);
        }
        for (int i = 0; i < srcCnt; ++i) {
            System.arraycopy(this.x, 1, this.x, 0, this.order);
            this.x[this.order] = (float)srcBuf[srcOff + i] / this.dcGain;
            System.arraycopy(this.y, 1, this.y, 0, this.order);
            float sum = 0.0f;
            for (int j = 0; j < this.order; ++j) {
                sum += this.yCoeffs[j] * this.y[j] + this.xCoeffs[j] * this.x[j];
            }
            this.y[this.order] = sum += this.xCoeffs[this.order] * this.x[this.order];
            int iSum = (int)sum;
            int clipper = Short.MIN_VALUE - iSum;
            iSum += clipper & ~(clipper >> 31);
            clipper = Short.MAX_VALUE - iSum;
            resBuf[resOff + i] = (short)(iSum += clipper & clipper >> 31);
        }
    }

    public void designFilter(int sampFreq, int cutoffFreq) {
        int i;
        int i2;
        Complex z;
        if (sampFreq < 1) {
            throw new IllegalArgumentException("Sample frequency (" + sampFreq + ") < 1");
        }
        if (cutoffFreq < 1) {
            throw new IllegalArgumentException("Cutoff frequency (" + cutoffFreq + ") < 1");
        }
        if (2 * cutoffFreq >= sampFreq) {
            throw new IllegalArgumentException("Cutoff frequency (" + cutoffFreq + ") * 2 >= sample frequency (" + sampFreq + ")");
        }
        this.sampFreq = sampFreq;
        this.cutoffFreq = cutoffFreq;
        double c = 1.0 / Math.tan(Math.PI * (double)cutoffFreq / (double)sampFreq);
        Complex[] zPoles = new Complex[this.order];
        for (int i3 = 0; i3 < this.order; ++i3) {
            zPoles[i3] = new Complex(c);
            zPoles[i3].add(this.sPoles[i3]);
            z = new Complex(c);
            z.sub(this.sPoles[i3]);
            zPoles[i3].div(z);
        }
        Complex[] botCoeffs = new Complex[this.order + 1];
        z = new Complex();
        botCoeffs[0] = new Complex(1.0);
        for (i2 = 1; i2 <= this.order; ++i2) {
            botCoeffs[i2] = new Complex(0.0);
        }
        for (i2 = 0; i2 < this.order; ++i2) {
            for (int j = this.order; j > 0; --j) {
                z.set(zPoles[i2]);
                z.mul(botCoeffs[j]);
                botCoeffs[j].set(botCoeffs[j - 1]);
                botCoeffs[j].sub(z);
            }
            z.set(zPoles[i2]);
            z.mul(botCoeffs[0]);
            botCoeffs[0].set(0.0);
            botCoeffs[0].sub(z);
        }
        double xSum = 0.0;
        double ySum = 0.0;
        for (i = 0; i <= this.order; ++i) {
            xSum += (double)this.xCoeffs[i];
            ySum += botCoeffs[i].real();
        }
        this.dcGain = (float)(xSum / ySum);
        for (i = 0; i < this.order; ++i) {
            this.yCoeffs[i] = -((float)botCoeffs[i].real());
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i <= this.order; ++i) {
            this.y[i] = 0.0f;
            this.x[i] = 0.0f;
        }
    }

    public String toString() {
        int i;
        String desc = "order = " + this.order + "; sampFreq = " + this.sampFreq + "; cutoffFreq = " + this.cutoffFreq + "; dcGain = " + this.dcGain + "; xCoeffs = {" + this.xCoeffs[0];
        for (i = 1; i <= this.order; ++i) {
            desc = desc + ", " + this.xCoeffs[i];
        }
        desc = desc + "}; yCoeffs = {" + this.yCoeffs[0];
        for (i = 1; i < this.order; ++i) {
            desc = desc + ", " + this.yCoeffs[i];
        }
        desc = desc + "};";
        return desc;
    }
}

