/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.macosx;

import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.macosx.AudioInputSelectionPanel;
import com.elluminate.groupware.audio.module.macosx.CoreAudioDevice;
import com.elluminate.groupware.audio.module.macosx.CoreAudioUnit;
import com.elluminate.groupware.audio.module.macosx.StringsProperties;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MacOSXAudioSupport
implements AudioSupport,
PropertyChangeListener {
    private Component parent = null;
    private CoreAudioUnit inUnit = null;
    private CoreAudioUnit outUnit = null;
    private I18n i18n = I18n.create((Object)this);

    public MacOSXAudioSupport() {
        this.inUnit = new CoreAudioUnit(true, "Microphone");
        this.outUnit = new CoreAudioUnit(false, "Speaker");
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getSource() == AudioDebug.NATIVE) {
            boolean debug = AudioDebug.NATIVE.show();
            if (this.inUnit != null) {
                this.inUnit.setDebugFlag(debug);
            }
            if (this.outUnit != null) {
                this.outUnit.setDebugFlag(debug);
            }
        }
    }

    @Override
    public void initialize() {
        boolean debug = AudioDebug.NATIVE.show();
        AudioDebug.NATIVE.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.inUnit != null) {
            this.inUnit.setDebugFlag(debug);
        }
        if (this.outUnit != null) {
            this.outUnit.setDebugFlag(debug);
        }
        this.inUnit.setDevice(null);
    }

    @Override
    public void setOwner(Component owner) {
        this.parent = owner;
    }

    @Override
    public boolean supportsFullDuplex() {
        return true;
    }

    @Override
    public void terminate() {
        AudioDebug.NATIVE.removePropertyChangeListener((PropertyChangeListener)this);
        if (this.inUnit != null) {
            this.inUnit.dispose();
        }
        this.inUnit = null;
        if (this.outUnit != null) {
            this.outUnit.dispose();
        }
        this.outUnit = null;
    }

    @Override
    public int openSpkr(int desiredRate) {
        return this.outUnit.open(desiredRate);
    }

    @Override
    public void closeSpkr() {
        if (this.outUnit != null && this.outUnit.getPendingSamples() == 0) {
            this.outUnit.close();
            return;
        }
        WorkerThread waiter = new WorkerThread("Speaker Terminator"){

            public void run() {
                long t0 = System.currentTimeMillis();
                while (MacOSXAudioSupport.this.outUnit != null && MacOSXAudioSupport.this.outUnit.getPendingSamples() > 0) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException intx) {
                        LogSupport.message((Object)((Object)this), (String)"run(forMacOSXAudioSupport.closeSpkr)", (String)("Interrupted while waiting for channel to quiesce.\n" + Debug.getStackTrace((Throwable)intx)));
                        break;
                    }
                    long elapsed = System.currentTimeMillis() - t0;
                    if (elapsed <= 15000L) continue;
                    LogSupport.message((Object)((Object)this), (String)"run(forMacOSXAudioSupport.closeSpkr)", (String)"Audio output channel failed to quiesce, closing anyway.");
                    break;
                }
                if (MacOSXAudioSupport.this.outUnit != null) {
                    MacOSXAudioSupport.this.outUnit.close();
                }
            }
        };
        waiter.start();
    }

    @Override
    public int getSpkrVolume() {
        int result = 0;
        try {
            result = Math.round(this.outUnit.getVolume() * 100.0f);
        }
        catch (Throwable t) {
            result = -1;
        }
        return result;
    }

    @Override
    public void setSpkrVolume(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("Invalid speaker volume: " + percent);
        }
        this.outUnit.setVolume((double)percent / 100.0);
    }

    @Override
    public void writeSpkr(short[] samples, int samplesOff, int samplesCnt) {
        block7: {
            long elapsed;
            if (samples == null) {
                throw new IllegalArgumentException("Null sample data");
            }
            if (samplesOff < 0 || samplesOff >= samples.length) {
                throw new IllegalArgumentException("Invalid samples offset: " + samplesOff + " / " + (samples.length - 1));
            }
            if (samplesCnt < 0 || samplesOff + samplesCnt > samples.length) {
                throw new IllegalArgumentException("Invalid samples count: " + samplesCnt + " / " + (samples.length - samplesOff));
            }
            int nWritten = 0;
            long t0 = System.currentTimeMillis();
            do {
                int n;
                if ((n = this.outUnit.writeAudioData(samples, samplesOff + nWritten, samplesCnt - nWritten)) < 0) {
                    throw new RuntimeException("Invalid return from CoreAudioUnit.writeAudioData: " + n);
                }
                if ((nWritten += n) >= samplesCnt) break block7;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException intx) {
                    break block7;
                }
            } while ((elapsed = System.currentTimeMillis() - t0) <= 2000L);
            throw new RuntimeException("Timeout waiting for audio to drain: " + elapsed + " ms");
        }
    }

    @Override
    public void flushSpkr() {
        if (this.outUnit != null) {
            this.outUnit.flushData();
        }
    }

    @Override
    public int openMike(int desiredRate) {
        int result = -1;
        if (this.inUnit.getDevice() == null) {
            this.inUnit.setDevice(null);
        }
        result = this.inUnit.open(desiredRate);
        return result;
    }

    @Override
    public void closeMike() {
        this.inUnit.close();
    }

    @Override
    public int getMikeBoost() {
        return -1;
    }

    @Override
    public void setMikeBoost(int percent) {
    }

    @Override
    public int getMikeGain() {
        int result = 0;
        try {
            result = Math.round(this.inUnit.getVolume() * 100.0f);
        }
        catch (Throwable t) {
            result = -1;
        }
        return result;
    }

    @Override
    public void setMikeGain(int percent) {
        try {
            this.inUnit.setVolume((double)percent / 100.0);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"setMikeGain", (String)("gain=" + percent + "%: " + t));
        }
    }

    @Override
    public void readMike(short[] samples, int samplesOff, int samplesCnt) {
        if (samples == null) {
            throw new IllegalArgumentException("Null sample data");
        }
        if (samplesOff < 0 || samplesOff >= samples.length) {
            throw new IllegalArgumentException("Invalid samples offset: " + samplesOff + " / " + (samples.length - 1));
        }
        if (samplesCnt < 0 || samplesOff + samplesCnt > samples.length) {
            throw new IllegalArgumentException("Invalid samples count: " + samplesCnt + " / " + (samples.length - samplesOff));
        }
        long startTime = System.currentTimeMillis();
        while (this.inUnit.getPendingSamples() < samplesCnt) {
            long dt = System.currentTimeMillis() - startTime;
            if (dt > 2000L) {
                throw new RuntimeException("Audio input has stalled, no new data in " + dt + " milliseconds on " + this.inUnit.getDevice());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException intx) {}
        }
        this.inUnit.readAudioData(samples, samplesOff, samplesCnt);
    }

    @Override
    public int getLatentInputSamplesCount() {
        return this.inUnit.getPendingSamples();
    }

    @Override
    public int getLatentOutputSamplesCount() {
        return this.outUnit.getPendingSamples();
    }

    @Override
    public void flushMike() {
    }

    @Override
    public String getInputDevice() {
        CoreAudioDevice dev = this.inUnit.getDevice();
        if (dev == null) {
            return null;
        }
        return dev.getPersistentUID();
    }

    @Override
    public String[] getInputDeviceList() {
        CoreAudioDevice[] choices = CoreAudioDevice.enumerateInputDevices();
        String[] list = new String[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            list[i] = choices[i].getPersistentUID();
        }
        return list;
    }

    @Override
    public String getInputDeviceDisplayName(String deviceHnd) {
        return deviceHnd;
    }

    @Override
    public DeviceSelectionPanel getInputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            private AudioInputSelectionPanel inputSelectionPanel;

            @Override
            public void apply() {
                this.inputSelectionPanel.apply();
            }

            @Override
            public void setup(JButton okBtn, ActionListener selectionAL) {
                this.inputSelectionPanel = new AudioInputSelectionPanel(MacOSXAudioSupport.this.inUnit, okBtn, selectionAL);
                this.selectionPanel = this.inputSelectionPanel;
            }
        };
        return panel;
    }

    @Override
    public boolean isInputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public void setInputDevice(String src) {
        CoreAudioDevice dev = null;
        if (src != null && (dev = CoreAudioDevice.getPersistentInputDevice(src)) == null) {
            LogSupport.message((Object)this, (String)"setSource", (String)("Cannot locate device " + src + ", using default."));
        }
        this.inUnit.setDevice(dev);
    }

    @Override
    public String getOutputDevice() {
        return null;
    }

    @Override
    public String[] getOutputDeviceList() {
        String[] empty = new String[]{};
        return empty;
    }

    @Override
    public String getOutputDeviceDisplayName(String deviceHnd) {
        return deviceHnd;
    }

    @Override
    public DeviceSelectionPanel getOutputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){

            @Override
            public void apply() {
            }

            @Override
            public void setup(JButton okBtn, ActionListener selectionAL) {
                String msgText = MacOSXAudioSupport.this.i18n.getString((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTMESSAGE);
                MultilineLabel message = new MultilineLabel(msgText);
                message.setOpaque(true);
                message.setLineWrap(false);
                JButton prefsBtn = new JButton();
                ImageIcon prefsIcon = null;
                try {
                    Image img = MacOSXAudioSupport.this.i18n.getImage((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTPREFSBTNICON);
                    if (img != null && !MacOSXAudioSupport.this.i18n.isDummyImage(img)) {
                        prefsIcon = new ImageIcon(img);
                    }
                }
                catch (Throwable t) {
                    prefsIcon = null;
                    LogSupport.exception((Object)this, (String)"getOutputDeviceSelectionPanel", (Throwable)t, (boolean)true, (String)("Loading image resource: " + (Object)((Object)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTPREFSBTNICON)));
                }
                if (prefsIcon != null) {
                    prefsBtn.setIcon(prefsIcon);
                    prefsBtn.putClientProperty("JButton.buttonType", "icon");
                } else {
                    prefsBtn.setText(MacOSXAudioSupport.this.i18n.getString((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTPREFSBTNNAME));
                    prefsBtn.putClientProperty("JButton.buttonType", null);
                }
                AccessibleContext ax = prefsBtn.getAccessibleContext();
                ax.setAccessibleName(MacOSXAudioSupport.this.i18n.getString((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTPREFSBTNNAME));
                ax.setAccessibleDescription(MacOSXAudioSupport.this.i18n.getString((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_OUTPUTSELECTPREFSBTNDESC));
                ActionListener prefsAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        MacOSXAudioSupport.revealSoundOutputPrefs();
                    }
                };
                prefsBtn.addActionListener(prefsAction);
                JPanel messagePanel = new JPanel(new GridBagLayout());
                messagePanel.add((Component)message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
                messagePanel.add((Component)prefsBtn, new GridBagConstraints(0, 1, 3, 3, 0.0, 0.0, 10, 0, new Insets(4, 0, 4, 0), 0, 0));
                JPanel outer = new JPanel(new BorderLayout());
                outer.add((Component)messagePanel, "North");
                outer.add(Box.createVerticalGlue(), "Center");
                this.selectionPanel = outer;
            }
        };
        return panel;
    }

    private static void revealSoundOutputPrefs() {
        String asTell = "tell application \"System Preferences\" to ";
        String[] command = new String[]{"osascript", "-e", null, "-e", asTell + "activate"};
        command[2] = Platform.checkOSVersion((int)202, (String)"10.4+") ? asTell + "tell pane id \"com.apple.preference.sound\" to reveal anchor \"output\"" : asTell + "set current pane to pane id \"com.apple.preference.sound\"";
        try {
            ProcessUtils.exec((String[])command);
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    @Override
    public boolean isOutputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public void setOutputDevice(String deviceDesc) {
    }
}

