/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.macosx;

import com.elluminate.groupware.audio.module.macosx.CoreAudioDevice;
import com.elluminate.platform.Platform;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CoreAudioUnit {
    private String info;
    private boolean disposed;
    private boolean devOpen;
    private boolean inputMode;
    private int openRate;
    private float volume;
    private CoreAudioDevice dev;
    private long unit;
    private long cbData;
    private static final boolean IS_JAGUAR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreAudioUnit(boolean isInput, String description) {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            this.info = description;
            this.disposed = false;
            this.devOpen = false;
            this.inputMode = isInput;
            this.openRate = 0;
            this.volume = 0.0f;
            this.dev = null;
            this.unit = 0L;
            this.cbData = 0L;
            this.unit = this.initializeNative(this.inputMode);
        }
    }

    public String toString() {
        return super.toString() + ",dev={" + this.dev + "},unit=" + this.unit + ",cbData=" + this.cbData + ",vol=" + this.volume + ",open=" + this.devOpen + (this.devOpen ? "@" + this.openRate : "") + ",info='" + this.info + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (this.devOpen) {
                this.close();
            }
            this.disposeNative(this.unit, this.cbData);
            this.unit = 0L;
            this.cbData = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugFlag(boolean debug) {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            this.setDebugNative(this.cbData, debug);
        }
    }

    public String getDescription() {
        return this.info;
    }

    public boolean isInputMode() {
        return this.inputMode;
    }

    public boolean isOpen() {
        return this.devOpen;
    }

    public int getSampleRate() {
        return this.openRate;
    }

    public float getVolume() {
        return this.volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(double val) {
        int id = 0;
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.dev != null) {
                id = this.dev.getDeviceID();
            }
            if (val < 0.0 || val > 1.0) {
                throw new IllegalArgumentException("Audio device volume outside range 0.0 .. 1.0: " + val);
            }
            this.volume = this.setVolumeNative(this.unit, id, this.inputMode, this.cbData, (float)val);
        }
    }

    public CoreAudioDevice getDevice() {
        return this.dev;
    }

    public String getDeviceInfo() {
        CoreAudioDevice dev = this.dev;
        return dev != null ? dev.toString() : "<default>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevice(CoreAudioDevice d) {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                throw new RuntimeException("AudioUnit not yet created: " + this);
            }
            if (this.devOpen) {
                throw new RuntimeException("AudioUnit is open: " + this);
            }
            if (!this.inputMode) {
                throw new RuntimeException("AudioUnit configured for output: " + this);
            }
            this.dev = d;
            int devID = 0;
            if (this.dev != null) {
                devID = this.dev.getDeviceID();
            }
            this.setDeviceNative(this.unit, devID, this.inputMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(int sampleRate) {
        int id = 0;
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                throw new RuntimeException("AudioUnit not yet created: " + this);
            }
            if (this.devOpen) {
                throw new RuntimeException("AudioUnit is already open: " + this);
            }
            if (this.dev != null) {
                if (!this.dev.isCurrentlyValid(this.inputMode)) {
                    String uid = this.dev.getPersistentUID();
                    CoreAudioDevice d2 = CoreAudioDevice.getPersistentInputDevice(uid);
                    if (d2 == null || !d2.isCurrentlyValid(this.inputMode)) {
                        throw new RuntimeException("Audio device not found: " + this.dev);
                    }
                    this.dev = d2;
                    id = this.dev.getDeviceID();
                    this.setDeviceNative(this.unit, id, this.inputMode);
                } else {
                    id = this.dev.getDeviceID();
                }
            }
            this.devOpen = true;
            boolean openedOK = false;
            try {
                this.openRate = this.openNative(this.unit, id, this.inputMode, this.cbData, sampleRate, 16, 1, this.volume);
                openedOK = this.openRate > 0;
            }
            finally {
                if (!openedOK) {
                    this.devOpen = false;
                }
            }
        }
        return this.openRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (!this.devOpen) {
                return;
            }
            this.devOpen = false;
            this.closeNative(this.unit, this.inputMode, this.cbData);
            this.openRate = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableSamples() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                return 0;
            }
            if (!this.devOpen) {
                return 0;
            }
            return this.getAvailableNative(this.cbData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingSamples() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                return 0;
            }
            if (!this.devOpen) {
                return 0;
            }
            return this.getPendingNative(this.cbData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                throw new RuntimeException("AudioUnit not yet created: " + this);
            }
            if (!this.devOpen) {
                throw new RuntimeException("AudioUnit not open: " + this);
            }
            return this.getBufferSizeNative(this.cbData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readAudioData(short[] samples, int pos, int len) {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                throw new RuntimeException("AudioUnit not yet created: " + this);
            }
            if (!this.devOpen) {
                throw new RuntimeException("AudioUnit not open: " + this);
            }
            if (!this.inputMode) {
                throw new RuntimeException("AudioUnit configured for output: " + this);
            }
            return this.readNative(this.cbData, samples, pos, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeAudioData(short[] samples, int pos, int len) {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                throw new RuntimeException("AudioUnit not yet created: " + this);
            }
            if (!this.devOpen) {
                throw new RuntimeException("AudioUnit not open: " + this);
            }
            if (this.inputMode) {
                throw new RuntimeException("AudioUnit configured for input: " + this);
            }
            return this.writeNative(this.cbData, samples, pos, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushData() {
        CoreAudioUnit coreAudioUnit = this;
        synchronized (coreAudioUnit) {
            if (this.unit == 0L) {
                return;
            }
            if (!this.devOpen) {
                return;
            }
            this.flushDataNative(this.cbData);
        }
    }

    private static native int getVersionNative();

    private native long initializeNative(boolean var1);

    private native void disposeNative(long var1, long var3);

    private native void setDeviceNative(long var1, int var3, boolean var4);

    private native float setVolumeNative(long var1, int var3, boolean var4, long var5, float var7);

    private native void setDebugNative(long var1, boolean var3);

    private native int openNative(long var1, int var3, boolean var4, long var5, int var7, int var8, int var9, float var10);

    private native void closeNative(long var1, boolean var3, long var4);

    private native int getPendingNative(long var1);

    private native int getAvailableNative(long var1);

    private native int getBufferSizeNative(long var1);

    private native int readNative(long var1, short[] var3, int var4, int var5);

    private native int writeNative(long var1, short[] var3, int var4, int var5);

    private native void flushDataNative(long var1);

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final CoreAudioUnit speaker = new CoreAudioUnit(false, "Speaker");
                JFrame frm = new JFrame("Audio Unit Test");
                final JSlider vol = new JSlider();
                final JToggleButton btn = new JToggleButton("Tone");
                vol.setValue((int)(speaker.getVolume() * 100.0f));
                vol.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ev) {
                        speaker.setVolume((float)vol.getValue() / 100.0f);
                    }
                });
                btn.addActionListener(new ActionListener(){
                    Thread source = null;

                    @Override
                    public void actionPerformed(ActionEvent aev) {
                        if (speaker.isOpen()) {
                            System.err.println("Closing: " + speaker);
                            speaker.close();
                            if (this.source != null) {
                                this.source.interrupt();
                            }
                            this.source = null;
                            btn.setSelected(false);
                        } else {
                            btn.setSelected(true);
                            System.err.println("Opening: " + speaker);
                            speaker.open(8000);
                            this.source = new Thread("SineSource"){

                                @Override
                                public void run() {
                                    int pos = 0;
                                    int lowerBound = (speaker.getBufferSize() + 2) / 5;
                                    int upperBound = speaker.getBufferSize() - lowerBound;
                                    boolean generating = true;
                                    short[] buf = new short[512];
                                    double period = 18.181818181818183;
                                    double period5 = period / 1.5;
                                    System.err.println("Thread starting: " + this);
                                    while (speaker.isOpen()) {
                                        for (int ix = 0; ix < buf.length; ++ix) {
                                            double cur = pos++;
                                            buf[ix] = (short)Math.round(Math.sin(2.0 * cur * Math.PI / period) * 32767.0 / 2.0);
                                            if (!(cur % 16384.0 >= 8192.0)) continue;
                                            int n = ix;
                                            buf[n] = (short)(buf[n] + (short)Math.round(Math.sin(2.0 * cur * Math.PI / period5) * 32767.0 / 3.0));
                                        }
                                        try {
                                            speaker.writeAudioData(buf, 0, buf.length);
                                            int pending = speaker.getPendingSamples();
                                            if (pending > upperBound) {
                                                generating = false;
                                            }
                                            if (generating || pending <= lowerBound) continue;
                                            Thread.sleep(125L);
                                        }
                                        catch (Throwable ignored) {}
                                    }
                                    System.err.println("Thread terminating: " + this);
                                }
                            };
                            this.source.start();
                        }
                    }
                });
                JPanel btnPane = new JPanel(new FlowLayout());
                btnPane.add(btn);
                frm.getContentPane().setLayout(new BorderLayout());
                frm.getContentPane().add((Component)vol, "Center");
                frm.getContentPane().add((Component)btnPane, "South");
                frm.pack();
                frm.show();
            }
        });
    }

    static {
        System.loadLibrary("vcCoreAudio");
        int vers = CoreAudioUnit.getVersionNative();
        LogSupport.message((String)("Loaded native library vcCoreAudio, version: " + (vers >> 16) + "." + (vers >> 8 & 0xFF) + "." + (vers & 0xFF)));
        IS_JAGUAR = Platform.checkOSVersion((int)202, (String)"10.2*");
    }
}

