/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.macosx;

import com.elluminate.groupware.audio.module.macosx.CoreAudioDevice;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CList;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AudioSelectDialog
extends EasyDialog {
    static final int MOD_KEYS_MASK = 15;
    private static I18n i18n = I18n.create(AudioSelectDialog.class);
    private CoreAudioDevice[] choices = null;
    private JList list = null;
    private CellRenderer renderer = null;
    private JScrollPane scrollPane = null;
    private JCheckBox useDefaultBtn = null;
    private JButton okBtn = null;
    private Icon firewireIcon = AudioSelectDialog.checkAndLoadIcon("AudioSelectDialog.firewireIcon");
    private Icon usbIcon = AudioSelectDialog.checkAndLoadIcon("AudioSelectDialog.USBIcon");
    private Icon wirelessIcon = AudioSelectDialog.checkAndLoadIcon("AudioSelectDialog.bluetoothIcon");

    private static Icon checkAndLoadIcon(String key) {
        ImageIcon result = null;
        try {
            result = i18n.getIcon(key);
        }
        catch (Throwable t) {
            LogSupport.message(AudioSelectDialog.class, (String)"checkAndLoadIcon", (String)("Error loading " + key + ": " + Debug.getStackTrace((Throwable)t)));
            result = null;
        }
        return result;
    }

    public AudioSelectDialog(Component parent, CoreAudioDevice curDev) {
        super(parent, i18n.getStringLegacy("AudioSelectDialog.title"));
        this.choices = CoreAudioDevice.enumerateInputDevices();
        this.list = new CList((Object[])this.choices);
        this.scrollPane = new JScrollPane(this.list, 22, 30);
        this.useDefaultBtn = new JCheckBox(i18n.getStringLegacy("AudioInputSelectionPanel.useDefaultBtnName"));
        this.useDefaultBtn.setSelected(curDev == null);
        this.okBtn = this.makeButton(1);
        int nRows = Math.max(this.list.getVisibleRowCount(), this.choices.length);
        this.scrollPane.setPreferredSize(new Dimension(275, nRows * 18 + 5));
        this.renderer = new CellRenderer();
        this.list.setCellRenderer(this.renderer);
        this.list.clearSelection();
        this.list.setSelectionMode(0);
        this.selectDevice(curDev);
        this.okBtn.setEnabled(this.useDefaultBtn.isSelected() || this.list.getSelectedIndex() >= 0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lev) {
                if (AudioSelectDialog.this.list.getSelectedIndex() >= 0) {
                    AudioSelectDialog.this.useDefaultBtn.setSelected(false);
                    AudioSelectDialog.this.okBtn.setEnabled(true);
                } else {
                    AudioSelectDialog.this.okBtn.setEnabled(AudioSelectDialog.this.useDefaultBtn.isSelected());
                }
            }
        });
        this.useDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aev) {
                if (AudioSelectDialog.this.useDefaultBtn.isSelected()) {
                    if (AudioSelectDialog.this.list.getSelectedIndex() >= 0) {
                        AudioSelectDialog.this.list.clearSelection();
                    }
                    AudioSelectDialog.this.okBtn.setEnabled(true);
                } else {
                    if (AudioSelectDialog.this.list.getSelectedIndex() < 0) {
                        AudioSelectDialog.this.selectDevice(CoreAudioDevice.getDefaultInputDevice());
                    }
                    AudioSelectDialog.this.okBtn.setEnabled(AudioSelectDialog.this.list.getSelectedIndex() >= 0);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mev) {
                if (mev.isConsumed()) {
                    return;
                }
                if ((mev.getModifiers() & 0xF) != 0) {
                    return;
                }
                if (AudioSelectDialog.this.list.getSelectedIndex() < 0) {
                    return;
                }
                if (mev.getClickCount() == 2) {
                    AudioSelectDialog.this.dispose();
                }
            }
        });
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)this.scrollPane, "Center");
        mainPane.add((Component)this.useDefaultBtn, "South");
        this.setContent(mainPane);
        this.addActionButton(this.okBtn, true);
        this.addCancelButton(this.makeButton(0));
        this.setInitialFocus(this.list);
    }

    private void selectDevice(CoreAudioDevice dev) {
        if (this.choices == null) {
            return;
        }
        if (dev == null) {
            return;
        }
        for (int ix = 0; ix < this.choices.length; ++ix) {
            if (this.choices[ix] == null || this.choices[ix].getDeviceID() != dev.getDeviceID()) continue;
            this.list.setSelectedValue(this.choices[ix], true);
            break;
        }
    }

    public CoreAudioDevice getSelectedDevice() {
        if (this.wasCanceled()) {
            return null;
        }
        if (this.useDefaultBtn.isSelected()) {
            return null;
        }
        return (CoreAudioDevice)this.list.getSelectedValue();
    }

    public boolean isDefaultDeviceSelected() {
        return !this.wasCanceled() && this.useDefaultBtn.isSelected();
    }

    private static void revealSoundInputPrefs() {
        String asTell = "tell application \"System Preferences\" to ";
        String[] command = new String[]{"osascript", "-e", null, "-e", asTell + "activate"};
        command[2] = Platform.checkOSVersion((int)202, (String)"10.4+") ? asTell + "tell pane id \"com.apple.preference.sound\" to reveal anchor \"input\"" : asTell + "set current pane to pane id \"com.apple.preference.sound\"";
        try {
            ProcessUtils.exec((String[])command);
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    class CellRenderer
    extends DefaultListCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (result instanceof JLabel && value instanceof CoreAudioDevice) {
                JLabel label = (JLabel)result;
                CoreAudioDevice dev = (CoreAudioDevice)value;
                label.setHorizontalTextPosition(10);
                switch (dev.getDeviceType()) {
                    case 4: {
                        label.setIcon(AudioSelectDialog.this.firewireIcon);
                        break;
                    }
                    case 3: {
                        label.setIcon(AudioSelectDialog.this.usbIcon);
                        break;
                    }
                    case 5: {
                        label.setIcon(AudioSelectDialog.this.wirelessIcon);
                        break;
                    }
                    default: {
                        label.setIcon(null);
                    }
                }
            }
            return result;
        }
    }
}

