/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.SetMaximumTalkersCommand;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class SetMaximumTalkersCmd
extends AbstractCommand
implements SetMaximumTalkersCommand {
    private int maximumTalkerCount = 1;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<AudioBean> beanProvider;

    @Inject
    public void initAudioBeanProvider(Provider<AudioBean> bp) {
        this.beanProvider = bp;
    }

    public void setTalkerCount(int talkerCount) {
        this.maximumTalkerCount = talkerCount;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.maximumTalkerCount < 1 || this.maximumTalkerCount > 6) {
            throw new CommandParameterException("Invalid maximum talkers: " + this.maximumTalkerCount, this.i18n.getString((PropertiesEnum)StringsProperties.SETMAXIMUMTALKERSCMD_BADPARAMTALKERCOUNTINVALID, new Object[]{this.maximumTalkerCount}));
        }
        AudioBean bean = (AudioBean)this.beanProvider.get();
        if (!bean.setMaximumTalkersCmd(this.maximumTalkerCount)) {
            throw new CommandContextException("Cannot set maximum talkers to " + this.maximumTalkerCount, this.i18n.getString((PropertiesEnum)StringsProperties.SETMAXIMUMTALKERSCMD_BADRESULTERROROCCURRED, new Object[]{this.maximumTalkerCount}));
        }
    }
}

