/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.module.SpkrVUMeter;
import com.elluminate.platform.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;

public class RemoteMikeAdjustMenu {
    ActionListener actionListener = null;
    JFrame frame;
    Component glassPane = null;
    int highlightIdx = -1;
    KeyListener keyListener;
    JPanel menu;
    MouseListener mouseListener;
    JWindow window;

    RemoteMikeAdjustMenu(Frame frame) {
        this.frame = (JFrame)frame;
        this.window = new JWindow(frame);
        this.menu = (JPanel)this.window.getContentPane();
        this.menu.setLayout(new BoxLayout(this.menu, 1));
        if (Platform.getLAF() != 502) {
            this.menu.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        this.menu.setBackground(UIManager.getColor("Menu.background"));
        this.menu.setForeground(UIManager.getColor("Menu.foreground"));
        this.menu.setFont(UIManager.getFont("Menu.font"));
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                switch (ke.getKeyCode()) {
                    case 40: {
                        MenuItem menuItem;
                        if (RemoteMikeAdjustMenu.this.highlightIdx >= 0) {
                            menuItem = (MenuItem)RemoteMikeAdjustMenu.this.menu.getComponent(RemoteMikeAdjustMenu.this.highlightIdx);
                            menuItem.setBackground(UIManager.getColor("MenuItem.background"));
                            menuItem.setForeground(UIManager.getColor("MenuItem.foreground"));
                        }
                        ++RemoteMikeAdjustMenu.this.highlightIdx;
                        if (RemoteMikeAdjustMenu.this.highlightIdx >= RemoteMikeAdjustMenu.this.menu.getComponentCount()) {
                            RemoteMikeAdjustMenu.this.highlightIdx = 0;
                        }
                        menuItem = (MenuItem)RemoteMikeAdjustMenu.this.menu.getComponent(RemoteMikeAdjustMenu.this.highlightIdx);
                        menuItem.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                        menuItem.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
                        break;
                    }
                    case 10: 
                    case 32: {
                        if (RemoteMikeAdjustMenu.this.highlightIdx < 0) break;
                        RemoteMikeAdjustMenu.this.callActionListener(RemoteMikeAdjustMenu.this.highlightIdx);
                        RemoteMikeAdjustMenu.this.hide();
                        break;
                    }
                    case 27: {
                        RemoteMikeAdjustMenu.this.hide();
                        break;
                    }
                    case 38: {
                        MenuItem menuItem;
                        if (RemoteMikeAdjustMenu.this.highlightIdx >= 0) {
                            menuItem = (MenuItem)RemoteMikeAdjustMenu.this.menu.getComponent(RemoteMikeAdjustMenu.this.highlightIdx);
                            menuItem.setBackground(UIManager.getColor("MenuItem.background"));
                            menuItem.setForeground(UIManager.getColor("MenuItem.foreground"));
                        }
                        --RemoteMikeAdjustMenu.this.highlightIdx;
                        if (RemoteMikeAdjustMenu.this.highlightIdx < 0) {
                            RemoteMikeAdjustMenu.this.highlightIdx = RemoteMikeAdjustMenu.this.menu.getComponentCount() - 1;
                        }
                        menuItem = (MenuItem)RemoteMikeAdjustMenu.this.menu.getComponent(RemoteMikeAdjustMenu.this.highlightIdx);
                        menuItem.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                        menuItem.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
                    }
                }
            }
        };
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                RemoteMikeAdjustMenu.this.hide();
            }
        };
    }

    public void add(String name, SpkrVUMeter vuMeter) {
        MenuItem menuItem = new MenuItem(name, vuMeter);
        menuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                RemoteMikeAdjustMenu.this.callActionListener(RemoteMikeAdjustMenu.this.getMenuItemIndex(me.getSource()));
                RemoteMikeAdjustMenu.this.hide();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                MenuItem menuItem = (MenuItem)me.getSource();
                menuItem.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                menuItem.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
                RemoteMikeAdjustMenu.this.highlightIdx = RemoteMikeAdjustMenu.this.getMenuItemIndex(menuItem);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MenuItem menuItem = (MenuItem)me.getSource();
                menuItem.setBackground(UIManager.getColor("MenuItem.background"));
                menuItem.setForeground(UIManager.getColor("MenuItem.foreground"));
                RemoteMikeAdjustMenu.this.highlightIdx = -1;
            }
        });
        this.menu.add(menuItem);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListener != null && this.actionListener != l) {
            throw new IllegalArgumentException("Too many listeners");
        }
        this.actionListener = l;
    }

    private void callActionListener(int menuIdx) {
        if (this.actionListener != null) {
            MenuItem menuItem = (MenuItem)this.menu.getComponent(menuIdx);
            String name = menuItem.getName();
            ActionEvent ae = new ActionEvent(menuItem, menuIdx, name);
            this.actionListener.actionPerformed(ae);
        }
    }

    private int getMenuItemIndex(Object menuItem) {
        int menuItemCnt = this.menu.getComponentCount();
        for (int i = 0; i < menuItemCnt; ++i) {
            if (this.menu.getComponent(i) != menuItem) continue;
            return i;
        }
        return -1;
    }

    public void hide() {
        if (this.window.isVisible()) {
            this.window.hide();
        }
        if (this.glassPane != null) {
            this.glassPane.removeKeyListener(this.keyListener);
            this.glassPane.removeMouseListener(this.mouseListener);
            this.glassPane.setVisible(false);
            this.glassPane = null;
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListener == l) {
            this.actionListener = null;
        }
    }

    public void show(Component parent) {
        int y;
        this.window.pack();
        Dimension windowSize = this.window.getSize();
        Point parentLoc = parent.getLocationOnScreen();
        Dimension parentSize = parent.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = parentLoc.x + parentSize.width / 2;
        if (x + windowSize.width > screen.width) {
            x -= windowSize.width;
        }
        if ((y = parentLoc.y + parentSize.height / 2 - windowSize.height) < 0) {
            y += windowSize.height;
        }
        this.show(parent, x - parentLoc.x, y - parentLoc.y);
    }

    public void show(Component parent, int x, int y) {
        Point parentLoc = parent.getLocationOnScreen();
        this.window.setLocation(parentLoc.x + x, parentLoc.y + y);
        this.glassPane = this.frame.getGlassPane();
        this.glassPane.addKeyListener(this.keyListener);
        this.glassPane.addMouseListener(this.mouseListener);
        this.glassPane.setVisible(true);
        this.glassPane.requestFocus();
        this.window.pack();
        this.window.show();
    }

    private static class MenuItem
    extends JPanel {
        private static LayoutManager layout = new FlowLayout(0, 0, 0);
        private JLabel label = null;

        public MenuItem(String name, SpkrVUMeter vuMeter) {
            super(layout);
            this.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
            this.setBackground(UIManager.getColor("MenuItem.background"));
            this.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.setFont(UIManager.getFont("MenuItem.font"));
            this.add(vuMeter);
            vuMeter.setValue(0);
            vuMeter.setOpaque(false);
            this.add(Box.createHorizontalStrut(6));
            this.label = new JLabel(name);
            this.label.setOpaque(false);
            this.add(this.label);
        }

        @Override
        public String getName() {
            return this.label.getText();
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            if (this.label != null) {
                this.label.setForeground(color);
            }
        }
    }
}

