/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.ecelp.ECELPCodec;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.InputEvent;
import com.elluminate.groupware.audio.module.InputListener;
import com.elluminate.groupware.audio.module.SpkrVUMeter;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.groupware.audio.module.VUMeter;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.NullableActionButton;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioSetupWizard
extends EasyDialog
implements InputListener {
    private static final int EV_MIKE_SAMPLES = 0;
    private static final int EV_MIKE_STARTED = 1;
    private static final int EV_MIKE_STOPPED = 2;
    private static final int EV_PLAYING_DONE = 3;
    private static final int EV_START_PLAYING = 4;
    private static final int EV_START_RECORDING = 5;
    private static final int EV_START_REPLAYING = 6;
    private static final int EV_STOP_PLAYING = 7;
    private static final int EV_STOP_RECORDING = 8;
    private static final int EV_STOP_REPLAYING = 9;
    private static final int EV_TERMINATE = 10;
    private static final int EV_TIMEOUT = 11;
    private static final String[] DECODE_EVENT = new String[]{"EV_MIKE_SAMPLES", "EV_MIKE_STARTED", "EV_MIKE_STOPPED", "EV_PLAYING_DONE", "EV_START_PLAYING", "EV_START_RECORDING", "EV_START_REPLAYING", "EV_STOP_PLAYING", "EV_STOP_RECORDING", "EV_STOP_REPLAYING", "EV_TERMINATE", "EV_TIMEOUT"};
    private static final int ST_IDLE = 0;
    private static final int ST_AWAITING_MIKE = 1;
    private static final int ST_PLAYING = 2;
    private static final int ST_RECORDING = 3;
    private static final int ST_RELEASING_MIKE = 4;
    private static final int ST_REPLAYING = 5;
    private static final String[] DECODE_STATE = new String[]{"ST_IDLE", "ST_AWAITING_MIKE", "ST_PLAYING", "ST_RECORDING", "ST_RELEASING_MIKE", "ST_REPLAYING"};
    private static I18n i18n = I18n.create(AudioSetupWizard.class);
    private static final String CANCEL_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_CANCELBTNLABEL);
    private static final String NO_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_NOBTNLABEL);
    private static final String OK_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_OKBTNLABEL);
    private static final ImageIcon PLAY_BTN_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_PLAYBTNICON);
    private static final String PLAY_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_PLAYBTNLABEL);
    private static final ImageIcon RECORD_BTN_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_RECORDBTNICON);
    private static final String RECORD_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_RECORDBTNLABEL);
    private static final String RECORD_BTN_WAIT_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_RECORDBTNWAITLABEL);
    private static final ImageIcon StopBtnIcon = i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_STOPBTNICON);
    private static final String STOP_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_STOPBTNLABEL);
    private static final String TRY_AGAIN_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_TRYAGAINBTNLABEL);
    private static final String YES_BTN_LABEL = i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_YESBTNLABEL);
    private static final int EVENT_HIST_LEN = 100;
    private static final long LOAD_TIME = Platform.currentTimeMillis();
    private static final int MAX_RECORD_MILLIS = 10000;
    private static final int SAMPS_PER_MILLI = 8;
    private static final int SPKR_CHN = 0;
    private static final int WATCHDOG_DELAY = 5000;
    private static final int WIZARD_AUDIO_PACKET_MILLIS = 240;
    private static final int TEXT_RESIZE = 10;
    private static final int MAX_TEXT_WIDTH = 400;
    private static final double SAMPLE_RATE = 8000.0;
    private static final int RECORDING_SECS_DEFAULT = 12;
    private volatile int msgNumber = 1;
    private volatile boolean playTimerTaskActive = false;
    private volatile boolean playingTestAudio = false;
    private volatile boolean recordingTestAudio = false;
    private volatile boolean terminating = false;
    private volatile boolean timedOutReleasingMike = false;
    private volatile boolean timedOutRequestingMike = false;
    private boolean acceptLateMikeSamples = false;
    private AudioBean audioBean = null;
    private LinkedList audioInQueue = new LinkedList();
    private LinkedList audioOutQueue = new LinkedList();
    private LinkedList<AbstractButton> buttonList = new LinkedList();
    private CardLayout cardLayout;
    private ECELPCodec codec = new ECELPCodec();
    private Container content;
    private ButtonGroup dynamicRangeButtonGroup = new ButtonGroup();
    private AudioEngine engine = null;
    private int eventHistCnt = 0;
    private int[] eventHistEvents = new int[100];
    private int[] eventHistStates = new int[100];
    private long[] eventHistTimes = new long[100];
    private JPanel helpPlayCardBody = null;
    private JPanel helpPlayTextDynamic = null;
    private JPanel helpPlayTextStatic = null;
    private JPanel helpRecordCardBody = null;
    private JPanel helpRecordTextDynamic = null;
    private JPanel helpRecordTextStatic = null;
    private boolean ignoreTimeOut = false;
    private DeviceSelectionPanel inputSelectionPanel = null;
    private JButton inputSelectionPanelOkBtn = null;
    private JPanel inputSelectionPanelParent = null;
    private boolean inputSelectionSupported = false;
    private int mikeFinalGain = 0;
    private JSlider mikeGainSlider = null;
    private JLabel mikeTitle = null;
    private VUMeter mikeVUMeter = null;
    private JRadioButton narrowRangeRadioButton;
    private DeviceSelectionPanel outputSelectionPanel = null;
    private JButton outputSelectionPanelOkBtn = null;
    private JPanel outputSelectionPanelParent = null;
    private boolean outputSelectionSupported = false;
    private Frame parent = null;
    private boolean playComplete = true;
    private int playSampleCnt = 0;
    private JToggleButton playStartBtn = null;
    private long playStartTime = 0L;
    private NullableActionButton playStopBtn = null;
    private LightweightTimer playTimer = null;
    private SpkrVUMeter playVUMeter = null;
    private Dimension preferredBtnSize = new Dimension(0, 0);
    private JToggleButton recordStartBtn = null;
    private NullableActionButton recordStopBtn = null;
    private int recordingLength = 0;
    private JToggleButton replayStartBtn = null;
    private NullableActionButton replayStopBtn = null;
    private SpkrVUMeter replayVUMeter = null;
    private LinkedList setupAudio = null;
    private int spkrFinalVol = 0;
    private JSlider spkrVolSlider = null;
    private JLabel spkrTitle = null;
    private volatile int state = 0;
    private Object stateLock = new Object();
    private LightweightTimer watchdogTimer = null;
    private JRadioButton wideRangeRadioButton;
    private boolean isSetup = false;

    public AudioSetupWizard(Frame parent) {
        super((Component)parent, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_TITLE));
        this.parent = parent;
        super.setResizable(true);
    }

    public void setupWizard() {
        if (this.isSetup) {
            return;
        }
        this.initPanelLayout();
        for (AbstractButton button : this.buttonList) {
            button.setPreferredSize(this.preferredBtnSize);
        }
        int preferredWidth = 2 * this.preferredBtnSize.width;
        Dimension prefSize = new Dimension(preferredWidth, this.spkrTitle.getPreferredSize().height);
        this.spkrTitle.setPreferredSize(prefSize);
        this.spkrTitle.setMaximumSize(prefSize);
        prefSize = new Dimension(preferredWidth, this.spkrVolSlider.getPreferredSize().height);
        this.spkrVolSlider.setPreferredSize(prefSize);
        this.spkrVolSlider.setMaximumSize(prefSize);
        prefSize = new Dimension(preferredWidth, this.playVUMeter.getPreferredSize().height);
        this.playVUMeter.setPreferredSize(prefSize);
        this.playVUMeter.setMaximumSize(prefSize);
        this.replayVUMeter.setPreferredSize(prefSize);
        this.replayVUMeter.setMaximumSize(prefSize);
        prefSize = new Dimension(preferredWidth, this.mikeTitle.getPreferredSize().height);
        this.mikeTitle.setPreferredSize(prefSize);
        this.mikeTitle.setMaximumSize(prefSize);
        prefSize = new Dimension(preferredWidth, this.mikeGainSlider.getPreferredSize().height);
        this.mikeGainSlider.setPreferredSize(prefSize);
        this.mikeGainSlider.setMaximumSize(prefSize);
        prefSize = new Dimension(preferredWidth, this.mikeVUMeter.getPreferredSize().height);
        this.mikeVUMeter.setPreferredSize(prefSize);
        this.mikeVUMeter.setMaximumSize(prefSize);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        this.setEscapeAction(new AbstractAction("terminate-audio-wizard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        this.playTimer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                AudioSetupWizard.this.playTimerTask();
            }
        });
        this.watchdogTimer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                AudioSetupWizard.this.updateState(11, null);
            }
        });
        this.isSetup = true;
    }

    private void initPanelLayout() {
        this.content = new JPanel();
        this.cardLayout = new CardLayout();
        this.content.setLayout(this.cardLayout);
        this.setContent(this.content);
        this.content.add((Component)this.createSelectOutputCard(), "SelectOutput");
        this.content.add((Component)this.createPlayCard(), "Play");
        this.content.add((Component)this.createCheckPlayCard(), "CheckPlay");
        this.content.add((Component)this.createHelpPlayCard(), "HelpPlay");
        this.content.add((Component)this.createSelectInputCard(), "SelectInput");
        this.content.add((Component)this.createRecordCard(), "Record");
        this.content.add((Component)this.createReplayCard(), "Replay");
        this.content.add((Component)this.createCheckReplayCard(), "CheckReplay");
        this.content.add((Component)this.createHelpRecordCard(), "HelpRecord");
        this.content.add((Component)this.createFinaleCard(), "Finale");
    }

    private JPanel createRecordCard() {
        JPanel recordCard = new JPanel();
        recordCard.setLayout(new BorderLayout(0, 6));
        recordCard.add((Component)this.createCenteredLabel("AudioSetupWizard.recordTitle"), "North");
        final JPanel body = this.createCenterPanel();
        recordCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        recordCard.add((Component)buttonPanel, "South");
        final JPanel recordCardText = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_RECORDTEXT), true);
        body.add(recordCardText);
        final JPanel legacyAdditionText = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_RECORDTEXTLEGACYADDITION), true);
        body.add(legacyAdditionText);
        legacyAdditionText.setVisible(this.engine.useLegacy());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        final JPanel rangePanel = new JPanel(new GridBagLayout());
        this.narrowRangeRadioButton = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_NARROWRANGE));
        this.narrowRangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.audioBean.setEnableBoostRestore(!AudioSetupWizard.this.narrowRangeRadioButton.isSelected());
            }
        });
        this.wideRangeRadioButton = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_WIDERANGE));
        this.wideRangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.audioBean.setEnableBoostRestore(AudioSetupWizard.this.wideRangeRadioButton.isSelected());
            }
        });
        rangePanel.add((Component)this.narrowRangeRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        rangePanel.add((Component)this.wideRangeRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dynamicRangeButtonGroup.add(this.narrowRangeRadioButton);
        this.dynamicRangeButtonGroup.add(this.wideRangeRadioButton);
        controlPanel.add(rangePanel);
        rangePanel.setVisible(this.engine.useLegacy());
        AudioDebug.LEGACYOVERRIDE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                legacyAdditionText.setVisible(AudioSetupWizard.this.engine.useLegacy());
                rangePanel.setVisible(AudioSetupWizard.this.engine.useLegacy());
            }
        });
        this.mikeTitle = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_MIKEBORDER), 0);
        this.mikeTitle.setAlignmentX(0.5f);
        controlPanel.add(this.mikeTitle);
        controlPanel.add(Box.createVerticalStrut(6));
        this.mikeVUMeter = new VUMeter();
        controlPanel.add(this.mikeVUMeter);
        this.mikeVUMeter.setRange(32768);
        controlPanel.add(Box.createVerticalStrut(6));
        this.mikeGainSlider = new JSlider();
        controlPanel.add(this.mikeGainSlider);
        this.mikeGainSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioSetupWizard.this.engine.setMikeGain(AudioSetupWizard.this.mikeGainSlider.getValue());
            }
        });
        body.add(Box.createGlue());
        body.add(controlPanel);
        body.add(Box.createGlue());
        this.recordStartBtn = new JToggleButton(RECORD_BTN_LABEL);
        buttonPanel.add(this.recordStartBtn);
        this.buttonList.add(this.recordStartBtn);
        this.recordStartBtn.setIcon(RECORD_BTN_ICON);
        this.updatePreferredBtnSize(this.recordStartBtn);
        this.recordStartBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AudioSetupWizard.this.recordStartBtn.isSelected()) {
                    AudioSetupWizard.this.recordStartBtn.setEnabled(false);
                    AudioSetupWizard.this.recordStartBtn.setText(RECORD_BTN_WAIT_LABEL);
                    AudioSetupWizard.this.updateState(5, null);
                    AudioSetupWizard.this.recordStopBtn.setFocusable(true);
                    AudioSetupWizard.this.recordStopBtn.setActionEnabled(true);
                    AudioSetupWizard.this.mikeGainSlider.requestFocus();
                }
            }
        });
        this.recordStopBtn = new NullableActionButton(STOP_BTN_LABEL);
        buttonPanel.add((Component)this.recordStopBtn);
        this.buttonList.add((AbstractButton)this.recordStopBtn);
        this.recordStopBtn.setIcon((Icon)StopBtnIcon);
        this.updatePreferredBtnSize((AbstractButton)this.recordStopBtn);
        this.recordStopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(8, null);
                AudioSetupWizard.this.recordStopBtn.setActionEnabled(false);
            }
        });
        recordCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AudioSetupWizard.this.codec.resetEncoder();
                AudioSetupWizard.this.recordStartBtn.requestFocus();
                AudioSetupWizard.this.recordStartBtn.setEnabled(true);
                AudioSetupWizard.this.recordStartBtn.setSelected(false);
                AudioSetupWizard.this.recordStartBtn.setText(RECORD_BTN_LABEL);
                AudioSetupWizard.this.recordStopBtn.setFocusable(false);
                AudioSetupWizard.this.recordStopBtn.setActionEnabled(false);
            }
        });
        recordCardText.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (recordCardText.getSize().width < body.getSize().width) {
                    recordCardText.setSize(new Dimension(body.getSize().width - 10, recordCardText.getSize().height));
                }
            }
        });
        ActionListener enterAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (AudioSetupWizard.this.recordStartBtn.isEnabled()) {
                    AudioSetupWizard.this.recordStartBtn.doClick();
                } else {
                    AudioSetupWizard.this.recordStopBtn.doClick();
                }
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        recordCard.registerKeyboardAction(enterAction, enterKey, 1);
        return recordCard;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(""));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 6, 10));
        panel.setBorder(new TitledBorder(""));
        return panel;
    }

    private JPanel createCenteredLabel(String labelI18nTag) {
        JLabel label = new JLabel(i18n.getStringLegacy(labelI18nTag), 0);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)label, "Center");
        return panel;
    }

    private JPanel createCheckPlayCard() {
        JPanel checkPlayCard = new JPanel();
        checkPlayCard.setLayout(new BorderLayout(0, 6));
        checkPlayCard.add((Component)this.createCenteredLabel("AudioSetupWizard.checkPlayTitle"), "North");
        JPanel body = this.createCenterPanel();
        checkPlayCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        checkPlayCard.add((Component)buttonPanel, "South");
        JPanel text = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_CHECKPLAYTEXT));
        body.add(text);
        final JButton yesBtn = new JButton(YES_BTN_LABEL);
        buttonPanel.add(yesBtn);
        this.buttonList.add(yesBtn);
        this.updatePreferredBtnSize(yesBtn);
        yesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.spkrFinalVol = AudioSetupWizard.this.spkrVolSlider.getValue();
                AudioSetupWizard.this.mikeVUMeter.clearValue();
                AudioSetupWizard.this.showCard0(AudioSetupWizard.this.inputSelectionSupported ? "SelectInput" : "Record");
            }
        });
        JButton noBtn = new JButton(NO_BTN_LABEL);
        buttonPanel.add(noBtn);
        this.buttonList.add(noBtn);
        this.updatePreferredBtnSize(noBtn);
        noBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.showCard0("HelpPlay");
            }
        });
        checkPlayCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                yesBtn.requestFocus();
                yesBtn.getRootPane().setDefaultButton(yesBtn);
            }
        });
        return checkPlayCard;
    }

    private JPanel createCheckReplayCard() {
        JPanel checkReplayCard = new JPanel();
        checkReplayCard.setLayout(new BorderLayout(0, 6));
        checkReplayCard.add((Component)this.createCenteredLabel("AudioSetupWizard.checkReplayTitle"), "North");
        JPanel body = this.createCenterPanel();
        checkReplayCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        checkReplayCard.add((Component)buttonPanel, "South");
        JPanel text = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_CHECKREPLAYTEXT));
        body.add(text);
        final JButton yesBtn = new JButton(YES_BTN_LABEL);
        buttonPanel.add(yesBtn);
        this.buttonList.add(yesBtn);
        this.updatePreferredBtnSize(yesBtn);
        yesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.mikeFinalGain = AudioSetupWizard.this.mikeGainSlider.getValue();
                AudioSetupWizard.this.showCard0("Finale");
            }
        });
        JButton noBtn = new JButton(NO_BTN_LABEL);
        buttonPanel.add(noBtn);
        this.buttonList.add(noBtn);
        this.updatePreferredBtnSize(noBtn);
        noBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.showCard0("HelpRecord");
            }
        });
        checkReplayCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                yesBtn.requestFocus();
                yesBtn.getRootPane().setDefaultButton(yesBtn);
            }
        });
        return checkReplayCard;
    }

    private JPanel createFinaleCard() {
        JPanel finaleCard = new JPanel();
        finaleCard.setLayout(new BorderLayout(0, 6));
        finaleCard.add((Component)this.createCenteredLabel("AudioSetupWizard.finaleTitle"), "North");
        JPanel body = this.createCenterPanel();
        finaleCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        finaleCard.add((Component)buttonPanel, "South");
        JPanel text = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_FINALETEXT));
        body.add(text);
        final JButton okBtn = new JButton(OK_BTN_LABEL);
        buttonPanel.add(okBtn);
        this.buttonList.add(okBtn);
        this.updatePreferredBtnSize(okBtn);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.setVisible(false);
            }
        });
        finaleCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                okBtn.requestFocus();
                okBtn.getRootPane().setDefaultButton(okBtn);
            }
        });
        return finaleCard;
    }

    private JPanel createHelpPlayCard() {
        JPanel helpPlayCard = new JPanel();
        helpPlayCard.setLayout(new BorderLayout(0, 6));
        helpPlayCard.add((Component)this.createCenteredLabel("AudioSetupWizard.helpPlayTitle"), "North");
        this.helpPlayCardBody = this.createCenterPanel();
        helpPlayCard.add((Component)this.helpPlayCardBody, "Center");
        this.helpPlayCardBody.setLayout(new BoxLayout(this.helpPlayCardBody, 1));
        JPanel buttonPanel = this.createButtonPanel();
        helpPlayCard.add((Component)buttonPanel, "South");
        this.helpPlayTextDynamic = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_HELPPLAYTEXTDYNAMIC));
        this.helpPlayTextStatic = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_HELPPLAYTEXTSTATIC));
        final JButton tryAgainBtn = new JButton(TRY_AGAIN_BTN_LABEL);
        buttonPanel.add(tryAgainBtn);
        this.buttonList.add(tryAgainBtn);
        this.updatePreferredBtnSize(tryAgainBtn);
        tryAgainBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.showCard0(AudioSetupWizard.this.outputSelectionSupported ? "SelectOutput" : "Play");
            }
        });
        JButton cancelBtn = new JButton(CANCEL_BTN_LABEL);
        buttonPanel.add(cancelBtn);
        this.buttonList.add(cancelBtn);
        this.updatePreferredBtnSize(cancelBtn);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        helpPlayCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                tryAgainBtn.requestFocus();
                tryAgainBtn.getRootPane().setDefaultButton(tryAgainBtn);
            }
        });
        return helpPlayCard;
    }

    private JPanel createHelpRecordCard() {
        JPanel helpRecordCard = new JPanel();
        helpRecordCard.setLayout(new BorderLayout(0, 6));
        helpRecordCard.add((Component)this.createCenteredLabel("AudioSetupWizard.helpRecordTitle"), "North");
        this.helpRecordCardBody = this.createCenterPanel();
        helpRecordCard.add((Component)this.helpRecordCardBody, "Center");
        this.helpRecordCardBody.setLayout(new BoxLayout(this.helpRecordCardBody, 1));
        JPanel buttonPanel = this.createButtonPanel();
        helpRecordCard.add((Component)buttonPanel, "South");
        this.helpRecordTextDynamic = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_HELPRECORDTEXTDYNAMIC));
        this.helpRecordTextStatic = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_HELPRECORDTEXTSTATIC));
        final JButton tryAgainBtn = new JButton(TRY_AGAIN_BTN_LABEL);
        buttonPanel.add(tryAgainBtn);
        this.buttonList.add(tryAgainBtn);
        this.updatePreferredBtnSize(tryAgainBtn);
        tryAgainBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.mikeVUMeter.clearValue();
                AudioSetupWizard.this.showCard0(AudioSetupWizard.this.inputSelectionSupported ? "SelectInput" : "Record");
            }
        });
        JButton cancelBtn = new JButton(CANCEL_BTN_LABEL);
        buttonPanel.add(cancelBtn);
        this.buttonList.add(cancelBtn);
        this.updatePreferredBtnSize(cancelBtn);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        helpRecordCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                tryAgainBtn.requestFocus();
                tryAgainBtn.getRootPane().setDefaultButton(tryAgainBtn);
            }
        });
        return helpRecordCard;
    }

    private JPanel createPlayCard() {
        final JPanel playCard = new JPanel();
        playCard.setLayout(new BorderLayout(0, 6));
        playCard.add((Component)this.createCenteredLabel("AudioSetupWizard.playTitle"), "North");
        final JPanel body = this.createCenterPanel();
        body.setLayout(new BoxLayout(body, 1));
        playCard.add((Component)body, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        playCard.add((Component)buttonPanel, "South");
        final JPanel text = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_PLAYTEXT));
        body.add(text);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        this.spkrTitle = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SPEAKERBORDER), 0);
        this.spkrTitle.setAlignmentX(0.5f);
        controlPanel.add(this.spkrTitle);
        controlPanel.add(Box.createVerticalStrut(6));
        this.playVUMeter = new SpkrVUMeter(1);
        controlPanel.add(this.playVUMeter);
        this.playVUMeter.setRange(32768);
        controlPanel.add(Box.createVerticalStrut(6));
        this.spkrVolSlider = new JSlider();
        controlPanel.add(this.spkrVolSlider);
        this.spkrVolSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AudioSetupWizard.this.engine.setSpkrVolume(AudioSetupWizard.this.spkrVolSlider.getValue());
            }
        });
        this.spkrTitle.setLabelFor(this.spkrVolSlider);
        body.add(Box.createGlue());
        body.add(controlPanel);
        body.add(Box.createGlue());
        this.playStartBtn = new JToggleButton(PLAY_BTN_LABEL);
        buttonPanel.add(this.playStartBtn);
        this.buttonList.add(this.playStartBtn);
        this.playStartBtn.setIcon(PLAY_BTN_ICON);
        this.updatePreferredBtnSize(this.playStartBtn);
        this.playStartBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AudioSetupWizard.this.playStartBtn.isSelected()) {
                    AudioSetupWizard.this.playStartBtn.setEnabled(false);
                    AudioSetupWizard.this.updateState(4, null);
                    AudioSetupWizard.this.playStopBtn.setFocusable(true);
                    AudioSetupWizard.this.playStopBtn.setActionEnabled(true);
                    AudioSetupWizard.this.spkrVolSlider.requestFocus();
                }
            }
        });
        this.playStopBtn = new NullableActionButton(STOP_BTN_LABEL);
        buttonPanel.add((Component)this.playStopBtn);
        this.buttonList.add((AbstractButton)this.playStopBtn);
        this.playStopBtn.setIcon((Icon)StopBtnIcon);
        this.updatePreferredBtnSize((AbstractButton)this.playStopBtn);
        this.playStopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(7, null);
                AudioSetupWizard.this.playStopBtn.setActionEnabled(false);
            }
        });
        playCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AudioSetupWizard.this.codec.resetDecoder();
                AudioSetupWizard.this.playStartBtn.setEnabled(true);
                AudioSetupWizard.this.playStartBtn.setSelected(false);
                AudioSetupWizard.this.playStopBtn.setActionEnabled(false);
                AudioSetupWizard.this.playStopBtn.setFocusable(false);
                AudioSetupWizard.this.playVUMeter.clearValue();
                AudioSetupWizard.this.playStartBtn.requestFocus();
            }
        });
        text.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (text.getSize().width < body.getSize().width) {
                    text.setSize(new Dimension(body.getSize().width - 10, text.getSize().height));
                }
            }
        });
        if (!Platform.checkJavaVersion((String)"1.5+")) {
            playCard.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent he) {
                    long flags = he.getChangeFlags();
                    if ((flags & 4L) != 0L && playCard.isShowing()) {
                        AudioSetupWizard.this.playStartBtn.requestFocus();
                    }
                }
            });
        }
        ActionListener enterAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (AudioSetupWizard.this.playStartBtn.isEnabled()) {
                    AudioSetupWizard.this.playStartBtn.doClick();
                } else {
                    AudioSetupWizard.this.playStopBtn.doClick();
                }
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        playCard.registerKeyboardAction(enterAction, enterKey, 1);
        return playCard;
    }

    private JPanel createReplayCard() {
        JPanel replayCard = new JPanel();
        replayCard.setLayout(new BorderLayout(0, 6));
        replayCard.add((Component)this.createCenteredLabel("AudioSetupWizard.replayTitle"), "North");
        final JPanel body = this.createCenterPanel();
        body.setLayout(new BoxLayout(body, 1));
        replayCard.add((Component)body, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        replayCard.add((Component)buttonPanel, "South");
        final JPanel text = this.createTextPanel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_REPLAYTEXT));
        body.add(text);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        this.spkrTitle = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_SPEAKERBORDER), 0);
        this.spkrTitle.setAlignmentX(0.5f);
        controlPanel.add(this.spkrTitle);
        controlPanel.add(Box.createVerticalStrut(6));
        this.replayVUMeter = new SpkrVUMeter(1);
        controlPanel.add(this.replayVUMeter);
        this.replayVUMeter.setRange(32768);
        body.add(Box.createGlue());
        body.add(controlPanel);
        body.add(Box.createGlue());
        this.replayStartBtn = new JToggleButton(PLAY_BTN_LABEL);
        buttonPanel.add(this.replayStartBtn);
        this.buttonList.add(this.replayStartBtn);
        this.replayStartBtn.setIcon(PLAY_BTN_ICON);
        this.updatePreferredBtnSize(this.replayStartBtn);
        this.replayStartBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AudioSetupWizard.this.replayStartBtn.isSelected()) {
                    AudioSetupWizard.this.replayStartBtn.setEnabled(false);
                    AudioSetupWizard.this.updateState(6, null);
                    AudioSetupWizard.this.replayStopBtn.setFocusable(true);
                    AudioSetupWizard.this.replayStopBtn.setActionEnabled(true);
                    AudioSetupWizard.this.replayStopBtn.requestFocus();
                }
            }
        });
        this.replayStopBtn = new NullableActionButton(STOP_BTN_LABEL);
        buttonPanel.add((Component)this.replayStopBtn);
        this.buttonList.add((AbstractButton)this.replayStopBtn);
        this.replayStopBtn.setIcon((Icon)StopBtnIcon);
        this.updatePreferredBtnSize((AbstractButton)this.replayStopBtn);
        this.replayStopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(9, null);
                AudioSetupWizard.this.replayStopBtn.setActionEnabled(false);
            }
        });
        replayCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AudioSetupWizard.this.codec.resetDecoder();
                AudioSetupWizard.this.replayStartBtn.setEnabled(true);
                AudioSetupWizard.this.replayStartBtn.setSelected(false);
                AudioSetupWizard.this.replayStopBtn.setFocusable(false);
                AudioSetupWizard.this.replayStopBtn.setActionEnabled(false);
                AudioSetupWizard.this.replayVUMeter.clearValue();
                AudioSetupWizard.this.replayStartBtn.requestFocus();
            }
        });
        text.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (text.getSize().width < body.getSize().width) {
                    text.setSize(new Dimension(body.getSize().width - 10, text.getSize().height));
                }
            }
        });
        ActionListener enterAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (AudioSetupWizard.this.replayStartBtn.isEnabled()) {
                    AudioSetupWizard.this.replayStartBtn.doClick();
                } else {
                    AudioSetupWizard.this.replayStopBtn.doClick();
                }
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        replayCard.registerKeyboardAction(enterAction, enterKey, 1);
        return replayCard;
    }

    private JPanel createSelectInputCard() {
        JPanel selectInputCard = new JPanel();
        selectInputCard.setLayout(new BorderLayout(0, 6));
        selectInputCard.add((Component)this.createCenteredLabel("AudioSetupWizard.selectInputTitle"), "North");
        JPanel body = this.createCenterPanel();
        selectInputCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        selectInputCard.add((Component)buttonPanel, "South");
        final JButton okBtn = new JButton(OK_BTN_LABEL);
        buttonPanel.add(okBtn);
        this.buttonList.add(okBtn);
        this.updatePreferredBtnSize(okBtn);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.showCard0("Record");
            }
        });
        JButton cancelBtn = new JButton(CANCEL_BTN_LABEL);
        buttonPanel.add(cancelBtn);
        this.buttonList.add(cancelBtn);
        this.updatePreferredBtnSize(cancelBtn);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        selectInputCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AudioSetupWizard.this.inputSelectionPanel.getSelectionPanel().requestFocus();
                okBtn.getRootPane().setDefaultButton(okBtn);
            }
        });
        this.inputSelectionPanelOkBtn = okBtn;
        this.inputSelectionPanelParent = body;
        return selectInputCard;
    }

    private JPanel createSelectOutputCard() {
        JPanel selectOutputCard = new JPanel();
        selectOutputCard.setLayout(new BorderLayout(0, 6));
        selectOutputCard.add((Component)this.createCenteredLabel("AudioSetupWizard.selectOutputTitle"), "North");
        JPanel body = this.createCenterPanel();
        selectOutputCard.add((Component)body, "Center");
        body.setLayout(new BoxLayout(body, 1));
        JPanel buttonPanel = this.createButtonPanel();
        selectOutputCard.add((Component)buttonPanel, "South");
        final JButton okBtn = new JButton(OK_BTN_LABEL);
        buttonPanel.add(okBtn);
        this.buttonList.add(okBtn);
        this.updatePreferredBtnSize(okBtn);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.engine.resumeSpkr();
                AudioSetupWizard.this.showCard0("Play");
            }
        });
        JButton cancelBtn = new JButton(CANCEL_BTN_LABEL);
        buttonPanel.add(cancelBtn);
        this.buttonList.add(cancelBtn);
        this.updatePreferredBtnSize(cancelBtn);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSetupWizard.this.engine.resumeSpkr();
                AudioSetupWizard.this.updateState(10, null);
            }
        });
        selectOutputCard.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AudioSetupWizard.this.outputSelectionPanel.getSelectionPanel().requestFocus();
                okBtn.getRootPane().setDefaultButton(okBtn);
            }
        });
        this.outputSelectionPanelOkBtn = okBtn;
        this.outputSelectionPanelParent = body;
        return selectOutputCard;
    }

    private JPanel createTextPanel(String text) {
        return this.createTextPanel(text, false);
    }

    private JPanel createTextPanel(String text, boolean wrap) {
        MultilineLabel label = new MultilineLabel(text, 400);
        if (Platform.usingScreenReader() == 1 || Platform.usingScreenReader() == -1) {
            label.setFocusable(true);
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new FlowLayout(1, 0, 0));
        innerPanel.add((Component)label);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.add(Box.createGlue());
        outerPanel.add(innerPanel);
        outerPanel.add(Box.createGlue());
        return outerPanel;
    }

    private void adjustMikePeak(short[] samples) {
        if (!this.audioBean.getEnablePeakLimiter()) {
            return;
        }
        int peakedCount = 0;
        short peakLimit = 32112;
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] < 0) {
                if (-samples[i] <= peakLimit) continue;
                ++peakedCount;
                continue;
            }
            if (-samples[i] <= peakLimit) continue;
            ++peakedCount;
        }
        if (peakedCount > 5) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.mikeGainSlider.setValue(AudioSetupWizard.this.mikeGainSlider.getValue() - 2);
                }
            });
        }
    }

    private String formatEventHistory() {
        String msg = "Recent Event History:\n";
        int oldestIdx = 0;
        long prevTime = 0L;
        int retainedCnt = this.eventHistCnt;
        if (retainedCnt > 100) {
            oldestIdx = this.eventHistCnt % 100;
            retainedCnt = 100;
        }
        int histIdx = oldestIdx;
        for (int retainedIdx = 0; retainedIdx < retainedCnt; ++retainedIdx) {
            msg = msg + "  ";
            msg = retainedIdx == 0 ? msg + (this.eventHistTimes[histIdx] - LOAD_TIME) : msg + "+" + (this.eventHistTimes[histIdx] - prevTime);
            msg = msg + ": " + this.getEventName(this.eventHistEvents[histIdx]) + " in " + this.getStateName(this.eventHistStates[histIdx]) + "\n";
            prevTime = this.eventHistTimes[histIdx];
            histIdx = (histIdx + 1) % 100;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAudioOutQueue() {
        Debug.lockEnter((Object)this, (String)"flushAudioOutQueue", (String)"audioOutQueue", (Object)this.audioOutQueue);
        LinkedList linkedList = this.audioOutQueue;
        synchronized (linkedList) {
            this.audioOutQueue.clear();
        }
        Debug.lockLeave((Object)this, (String)"flushAudioOutQueue", (String)"audioOutQueue", (Object)this.audioOutQueue);
    }

    private String getEventName(int event) {
        return event >= 0 && event < DECODE_EVENT.length ? DECODE_EVENT[event] : "Event #" + event;
    }

    private String getStateName(int state) {
        return state >= 0 && state < DECODE_STATE.length ? DECODE_STATE[state] : "State #" + state;
    }

    private void loadSetupAudio() {
        if (this.setupAudio == null) {
            this.setupAudio = new LinkedList();
            try {
                byte[] audio = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIO)).load();
                if (audio == null) {
                    audio = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIOBACKUP)).load();
                }
                if (audio == null) {
                    throw new RuntimeException("Cannot find setup prerecorded audio");
                }
                int MaxPieceSize = 216;
                for (int i = 0; i < audio.length; i += 216) {
                    int pieceSize = audio.length - i;
                    if (pieceSize > 216) {
                        pieceSize = 216;
                    }
                    byte[] piece = new byte[pieceSize];
                    System.arraycopy(audio, i, piece, 0, pieceSize);
                    this.setupAudio.addLast(piece);
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"loadSetupAudio", (Throwable)t, (boolean)false);
            }
        }
        this.audioOutQueue.clear();
        Iterator iterator = this.setupAudio.iterator();
        while (iterator.hasNext()) {
            this.audioOutQueue.addLast(iterator.next());
        }
    }

    @Override
    public void onInput(InputEvent ie) {
        switch (ie.getKind()) {
            case 4: {
                if (this.recordingTestAudio) break;
                this.updateState(1, ie);
                break;
            }
            case 5: {
                if (this.recordingTestAudio) break;
                this.updateState(2, ie);
                break;
            }
            case 3: {
                if (!this.recordingTestAudio) {
                    this.updateState(0, ie);
                    break;
                }
                this.recordSamples(ie);
                break;
            }
            default: {
                String msg = "Invalid InputEvent kind: " + ie.getKind();
                LogSupport.exception((Object)this, (String)"onInput", (Throwable)new RuntimeException(msg), (boolean)false);
            }
        }
    }

    private void playAudioQueue(boolean flushOutput) {
        this.playComplete = false;
        this.playSampleCnt = 0;
        this.playStartTime = 0L;
        if (flushOutput) {
            this.engine.flushOutput();
        }
        this.playTimer.scheduleIn(120L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playTimerTask() {
        if (this.playTimerTaskActive) {
            LogSupport.message((Object)this, (String)"playTimerTask", (String)"Already playing");
            return;
        }
        this.playTimerTaskActive = true;
        Debug.lockEnter((Object)this, (String)"playTimerTask", (String)"audioOutQueue", (Object)this.audioOutQueue);
        LinkedList linkedList = this.audioOutQueue;
        synchronized (linkedList) {
            if (!this.codec.isDecoderOpen()) {
                LogSupport.error((Object)this, (String)"playTimerTask", (String)"Decoder is not open?");
                this.playTimerTaskActive = false;
                if (this.playingTestAudio) {
                    this.playbackCleanup();
                }
                return;
            }
            if (this.playStartTime == 0L) {
                this.playStartTime = Platform.currentTimeMillis();
                if (this.playingTestAudio) {
                    LogSupport.message((Object)this, (String)"playTimerTask", (String)"Starting playback");
                }
            }
            while (!this.audioOutQueue.isEmpty() && this.playStartTime + (long)(this.playSampleCnt / 8) <= Platform.currentTimeMillis() + 500L) {
                byte[] ecelpData = (byte[])this.audioOutQueue.removeFirst();
                short[] samples = this.codec.decode(ecelpData);
                if (!this.playingTestAudio && this.state == 2) {
                    this.playVUMeter.processSamples(0, samples);
                } else if (!this.playingTestAudio && this.state == 5) {
                    this.replayVUMeter.processSamples(0, samples);
                }
                this.engine.playCustomSound(samples);
                this.playSampleCnt += samples.length;
            }
            if (this.audioOutQueue.isEmpty()) {
                this.playComplete = Platform.currentTimeMillis() > this.playStartTime + (long)(this.playSampleCnt / 8) + 500L;
            }
        }
        Debug.lockLeave((Object)this, (String)"playTimerTask", (String)"audioOutQueue", (Object)this.audioOutQueue);
        if (this.playingTestAudio && this.playComplete) {
            LogSupport.message((Object)this, (String)"playTimerTask", (String)"Done playing");
            this.playbackCleanup();
        } else if (this.playComplete) {
            this.ignoreTimeOut = false;
            this.updateState(3, null);
        } else {
            this.playTimer.scheduleIn(120L);
        }
        this.playTimerTaskActive = false;
    }

    private void quenchWatchdog() {
        this.ignoreTimeOut = true;
        if (this.watchdogTimer.cancel()) {
            this.stateMessage("Watchdog timer quenched");
        } else {
            this.stateMessage("Unable to quench watchdog timer");
        }
    }

    private void releaseMike() {
        this.timedOutReleasingMike = false;
        if (AudioDebug.SUPPRESS_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing engine.forceStopInput()");
        } else if (AudioDebug.STALL_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.stateMessage("Calling engine.forceStopInput()");
                    AudioSetupWizard.this.engine.forceStopInput();
                }
            }).scheduleIn(5100L);
        } else if (AudioDebug.DELAY_MIKE_RELEASE.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.stateMessage("Calling engine.forceStopInput()");
                    AudioSetupWizard.this.engine.forceStopInput();
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Calling engine.forceStopInput()");
            this.engine.forceStopInput();
        }
    }

    private void requestMike() {
        this.timedOutRequestingMike = false;
        if (AudioDebug.SUPPRESS_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            this.stateMessage("Suppressing engine.startInput()");
        } else if (AudioDebug.DENY_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.stateMessage("Faking mike request denial");
                    AudioSetupWizard.this.updateState(2, null);
                }
            }).scheduleIn(2500L);
        } else if (AudioDebug.STALL_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(5000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.stateMessage("Calling engine.startInput()");
                    AudioSetupWizard.this.engine.startInput();
                }
            }).scheduleIn(5100L);
        } else if (AudioDebug.DELAY_MIKE_REQUEST.isEnabled()) {
            this.startWatchdog(10000);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.stateMessage("Calling engine.startInput()");
                    AudioSetupWizard.this.engine.startInput();
                }
            }).scheduleIn(5000L);
        } else {
            this.startWatchdog(5000);
            this.stateMessage("Calling engine.startInput()");
            this.engine.startInput();
        }
    }

    public void playAudio(AudioEngine engine, AudioBean audioBean, boolean useCannedAudio) {
        if (this.playingTestAudio || this.playTimerTaskActive) {
            LogSupport.message((Object)this, (String)"playAudio", (String)"Already playing audio");
            return;
        }
        if (!useCannedAudio && this.recordingTestAudio) {
            LogSupport.message((Object)this, (String)"playAudio", (String)"Still recording. Press play first, THEN record.");
            return;
        }
        this.playingTestAudio = true;
        if (useCannedAudio) {
            this.loadSetupAudio();
        } else {
            this.loadDynamicAudio();
        }
        this.playTimer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                AudioSetupWizard.this.playTimerTask();
            }
        });
        try {
            if (!this.codec.openDecoder()) {
                throw new RuntimeException("Cannot open decoder");
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"playAudio", (Throwable)t, (boolean)true);
            this.playbackCleanup();
        }
        this.engine = engine;
        this.audioBean = audioBean;
        this.playAudioQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playbackCleanup() {
        LinkedList linkedList = this.audioOutQueue;
        synchronized (linkedList) {
            this.codec.closeDecoder();
        }
        this.playingTestAudio = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordAudio(AudioEngine engine, AudioBean audioBean) {
        if (this.recordingTestAudio) {
            LogSupport.message((Object)this, (String)"recordAudio", (String)"Already recording audio");
            return false;
        }
        LogSupport.message((Object)this, (String)"recordAudio", (String)"Now recording audio. Make sure the MICROPHONE is ON!");
        this.recordingTestAudio = true;
        this.recordingLength = 0;
        this.engine = engine;
        this.audioBean = audioBean;
        try {
            if (!this.codec.openEncoder()) {
                throw new RuntimeException("Cannot open encoder");
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"recordAudio", (Throwable)t, (boolean)true);
            this.recordCleanup();
            return false;
        }
        LinkedList linkedList = this.audioInQueue;
        synchronized (linkedList) {
            this.audioInQueue.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordSamples(InputEvent ie) {
        short[] samples = ie.getData();
        if (!this.recordingTestAudio) {
            final int level = AudioBean.volumeLevel(samples);
            this.adjustMikePeak(samples);
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioSetupWizard.this.mikeVUMeter.setValue(level);
                }
            });
            LinkedList linkedList = this.audioOutQueue;
            synchronized (linkedList) {
                byte[] ecelpData = this.codec.encode(samples);
                this.audioOutQueue.addLast(ecelpData);
            }
        }
        LinkedList linkedList = this.audioInQueue;
        synchronized (linkedList) {
            byte[] ecelpData = this.codec.encode(samples);
            this.audioInQueue.addLast(ecelpData);
        }
        this.recordingLength += samples.length;
        if ((double)this.recordingLength > 96000.0) {
            LogSupport.message((Object)this, (String)"recordAudio", (String)("...  ENOUGH RECORDING:  (" + (double)this.recordingLength / 8000.0 + " secs)..."));
            this.recordCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDynamicAudio() {
        LinkedList linkedList = this.audioInQueue;
        synchronized (linkedList) {
            this.audioOutQueue.clear();
            Iterator iterator = this.audioInQueue.iterator();
            while (iterator.hasNext()) {
                this.audioOutQueue.addLast(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordCleanup() {
        LinkedList linkedList = this.audioInQueue;
        synchronized (linkedList) {
            this.codec.closeEncoder();
        }
        this.audioBean.recordingComplete();
        this.recordingTestAudio = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(AudioEngine engine, AudioBean audioBean) {
        if (this.playingTestAudio || this.playTimerTaskActive || this.recordingTestAudio) {
            LogSupport.message((Object)this, (String)"run", (String)"Audio is already being handled (if recording, MAKE SURE THE MICROPHONE IS ON)");
            return;
        }
        this.engine = engine;
        this.audioBean = audioBean;
        this.setupWizard();
        boolean wideRange = audioBean.getEnableBoostRestore();
        if (wideRange) {
            if (!this.wideRangeRadioButton.isSelected()) {
                this.wideRangeRadioButton.doClick();
            }
        } else if (!this.narrowRangeRadioButton.isSelected()) {
            this.narrowRangeRadioButton.doClick();
        }
        try {
            audioBean.setAudioSetupAwayProperty(true);
            this.eventHistCnt = 0;
            this.terminating = false;
            this.timedOutReleasingMike = false;
            this.timedOutRequestingMike = false;
            this.setState(0);
            if (!this.codec.openDecoder()) {
                throw new RuntimeException("Cannot open decoder");
            }
            if (!this.codec.openEncoder()) {
                throw new RuntimeException("Cannot open encoder");
            }
            this.mikeFinalGain = engine.getMikeGain();
            if (this.mikeFinalGain >= 0) {
                this.mikeGainSlider.setEnabled(true);
                this.mikeGainSlider.setValue(this.mikeFinalGain);
            } else {
                this.mikeGainSlider.setEnabled(false);
                this.mikeGainSlider.setValue(0);
            }
            this.spkrFinalVol = engine.getSpkrVolume();
            if (this.spkrFinalVol >= 0) {
                this.spkrVolSlider.setEnabled(true);
                this.spkrVolSlider.setValue(this.spkrFinalVol);
            } else {
                this.spkrVolSlider.setEnabled(false);
                this.spkrVolSlider.setValue(0);
            }
            this.inputSelectionPanel = engine.getInputDeviceSelectionPanel(this.inputSelectionPanelOkBtn, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.inputSelectionPanelOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioSetupWizard.this.inputSelectionPanel.apply();
                }
            });
            if (this.inputSelectionPanel == null || this.inputSelectionPanel.getSelectionPanel() == null) {
                this.inputSelectionSupported = false;
                this.helpRecordCardBody.removeAll();
                this.helpRecordCardBody.add(this.helpRecordTextStatic);
            } else {
                this.inputSelectionSupported = true;
                this.inputSelectionPanelParent.add(this.inputSelectionPanel.getSelectionPanel());
                this.inputSelectionPanelParent.revalidate();
                this.inputSelectionPanelParent.repaint();
                this.helpRecordCardBody.removeAll();
                this.helpRecordCardBody.add(this.helpRecordTextDynamic);
            }
            this.outputSelectionPanel = engine.getOutputDeviceSelectionPanel(this.outputSelectionPanelOkBtn, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.outputSelectionPanelOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioSetupWizard.this.outputSelectionPanel.apply();
                }
            });
            if (this.outputSelectionPanel == null || this.outputSelectionPanel.getSelectionPanel() == null) {
                this.outputSelectionSupported = false;
                this.helpPlayCardBody.removeAll();
                this.helpPlayCardBody.add(this.helpPlayTextStatic);
            } else {
                this.outputSelectionSupported = true;
                this.outputSelectionPanelParent.add(this.outputSelectionPanel.getSelectionPanel());
                this.outputSelectionPanelParent.revalidate();
                this.outputSelectionPanelParent.repaint();
                this.helpPlayCardBody.removeAll();
                this.helpPlayCardBody.add(this.helpPlayTextDynamic);
            }
            engine.addInputListener(this);
            this.showCard0("Finale");
            if (this.outputSelectionSupported) {
                engine.suspendSpkr();
                this.showCard("SelectOutput");
            } else {
                this.showCard("Play");
            }
            this.setVisible(true);
            if (this.outputSelectionSupported) {
                engine.resumeSpkr();
            }
            if (this.inputSelectionSupported) {
                this.inputSelectionPanelParent.remove(this.inputSelectionPanel.getSelectionPanel());
            }
            if (this.outputSelectionSupported) {
                this.outputSelectionPanelParent.remove(this.outputSelectionPanel.getSelectionPanel());
            }
            if (this.mikeFinalGain >= 0) {
                engine.setMikeGain(this.mikeFinalGain);
                audioBean.setAudioSetupMicLevel(this.mikeFinalGain);
            }
            if (this.spkrFinalVol >= 0) {
                engine.setSpkrVolume(this.spkrFinalVol);
                audioBean.setAudioSetupSpkrLevel(this.spkrFinalVol);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
        }
        finally {
            engine.removeInputListener(this);
            LinkedList linkedList = this.audioOutQueue;
            synchronized (linkedList) {
                this.codec.closeDecoder();
                this.codec.closeEncoder();
            }
            audioBean.setAudioSetupAwayProperty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        Debug.lockEnter((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateMessage(this.getStateName(this.state) + " -> " + this.getStateName(newState));
            this.state = newState;
        }
        Debug.lockLeave((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
    }

    public void showCard(final String cardName) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AudioSetupWizard.this.showCard0(cardName);
            }
        };
        SwingRunnerSupport.invokeLater((Runnable)r);
    }

    private void showCard0(String cardName) {
        this.cardLayout.show(this.content, cardName);
    }

    private void startWatchdog(int delay) {
        if (delay <= 0 || this.watchdogTimer.isScheduled()) {
            return;
        }
        this.ignoreTimeOut = false;
        this.watchdogTimer.scheduleIn((long)delay);
        this.stateMessage("Watchdog timer set at " + delay);
    }

    private int stateMessage(String msg) {
        int msgNum = 0;
        if (AudioDebug.STATE.show()) {
            msgNum = this.msgNumber++;
            LogSupport.message((String)("AudioSetupWizard." + msgNum + ": " + msg));
        }
        return msgNum;
    }

    private void updatePreferredBtnSize(AbstractButton button) {
        Dimension buttonSize = button.getPreferredSize();
        if (this.preferredBtnSize.width < buttonSize.width) {
            this.preferredBtnSize.width = buttonSize.width;
        }
        if (this.preferredBtnSize.height < buttonSize.height) {
            this.preferredBtnSize.height = buttonSize.height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(int eventCode, InputEvent ie) {
        Debug.lockEnter((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            String operation = "Got " + this.getEventName(eventCode) + " in " + this.getStateName(this.state);
            this.stateMessage(operation);
            int histIdx = this.eventHistCnt++ % 100;
            this.eventHistEvents[histIdx] = eventCode;
            this.eventHistStates[histIdx] = this.state;
            this.eventHistTimes[histIdx] = Platform.currentTimeMillis();
            block2 : switch (eventCode) {
                case 0: {
                    switch (this.state) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 5: {
                            this.engine.forceStopInput();
                            break;
                        }
                        case 4: {
                            if (!this.acceptLateMikeSamples) break;
                            this.acceptLateMikeSamples = false;
                        }
                        case 3: {
                            this.recordSamples(ie);
                            break;
                        }
                        default: {
                            this.engine.forceStopInput();
                            LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.timedOutRequestingMike) {
                        this.stateMessage("Ignoring EV_MIKE_STARTED due to mike request timeout");
                        break;
                    }
                    if (AudioDebug.IGNORE_MIKE_GRANT.isEnabled()) {
                        this.stateMessage("Ignoring EV_MIKE_STARTED");
                        break;
                    }
                    switch (this.state) {
                        case 1: {
                            this.quenchWatchdog();
                            if (this.terminating) {
                                this.setState(4);
                                this.releaseMike();
                                break block2;
                            }
                            this.setState(3);
                            this.startWatchdog(10000);
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AudioSetupWizard.this.recordStartBtn.setText(RECORD_BTN_LABEL);
                                    AudioSetupWizard.this.recordStopBtn.setEnabled(true);
                                }
                            });
                            break block2;
                        }
                        case 4: {
                            break block2;
                        }
                    }
                    this.engine.forceStopInput();
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 2: {
                    if (this.timedOutReleasingMike) {
                        this.stateMessage("Ignoring EV_MIKE_STOPPED due to mike release timeout");
                        break;
                    }
                    if (AudioDebug.IGNORE_MIKE_REVOKE.isEnabled()) {
                        this.stateMessage("Ignoring EV_MIKE_STOPPED");
                        break;
                    }
                    switch (this.state) {
                        case 1: {
                            this.quenchWatchdog();
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            this.showCard("HelpRecord");
                            break block2;
                        }
                        case 0: 
                        case 2: 
                        case 5: {
                            break block2;
                        }
                        case 3: {
                            this.quenchWatchdog();
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            this.showCard("HelpRecord");
                            break block2;
                        }
                        case 4: {
                            this.quenchWatchdog();
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            if (this.timedOutRequestingMike) {
                                this.showCard("HelpRecord");
                                break block2;
                            }
                            this.showCard("Replay");
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 3: {
                    switch (this.state) {
                        case 2: {
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            this.showCard("CheckPlay");
                            break block2;
                        }
                        case 5: {
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            this.showCard("CheckReplay");
                            break block2;
                        }
                    }
                    this.engine.forceStopInput();
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 4: {
                    switch (this.state) {
                        case 0: {
                            this.setState(2);
                            this.loadSetupAudio();
                            this.playAudioQueue(true);
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 5: {
                    switch (this.state) {
                        case 0: {
                            this.setState(1);
                            this.requestMike();
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 6: {
                    switch (this.state) {
                        case 0: {
                            this.setState(5);
                            this.playAudioQueue(true);
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 7: {
                    switch (this.state) {
                        case 2: {
                            this.flushAudioOutQueue();
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 8: {
                    switch (this.state) {
                        case 3: {
                            this.acceptLateMikeSamples = true;
                            this.quenchWatchdog();
                            this.setState(4);
                            this.releaseMike();
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 9: {
                    switch (this.state) {
                        case 5: {
                            this.flushAudioOutQueue();
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 10: {
                    switch (this.state) {
                        case 1: 
                        case 4: {
                            this.terminating = true;
                            break block2;
                        }
                        case 3: {
                            this.terminating = true;
                            this.quenchWatchdog();
                            this.setState(4);
                            this.releaseMike();
                            break block2;
                        }
                        case 0: {
                            if (SwingUtilities.isEventDispatchThread()) {
                                this.setVisible(false);
                                break block2;
                            }
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AudioSetupWizard.this.setVisible(false);
                                }
                            });
                            break block2;
                        }
                        case 2: 
                        case 5: {
                            this.terminating = true;
                            this.flushAudioOutQueue();
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                case 11: {
                    if (this.ignoreTimeOut) {
                        this.stateMessage("Ignoring false time-out");
                        break;
                    }
                    switch (this.state) {
                        case 1: {
                            this.timedOutRequestingMike = true;
                            this.setState(4);
                            this.releaseMike();
                            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parent, (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_MIKEREQFAILMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_ERRORCAP), (int)0);
                            break block2;
                        }
                        case 3: {
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (AudioSetupWizard.this.recordStopBtn.isEnabled()) {
                                        AudioSetupWizard.this.recordStopBtn.doClick();
                                    }
                                }
                            });
                            break block2;
                        }
                        case 4: {
                            this.timedOutReleasingMike = true;
                            if (!this.timedOutRequestingMike) {
                                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parent, (Object)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_MIKERELFAILMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_ERRORCAP), (int)0);
                            }
                            this.setState(0);
                            if (this.terminating) {
                                this.updateState(10, null);
                                break block2;
                            }
                            this.showCard("HelpRecord");
                            break block2;
                        }
                    }
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalStateException(operation), (boolean)false, (String)this.formatEventHistory());
                    break;
                }
                default: {
                    String diagnostic = "Invalid event index: " + eventCode;
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalArgumentException(diagnostic), (boolean)false, (String)this.formatEventHistory());
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
    }
}

