/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class AudioPublisher {
    private final String UNIQUE_NAME = "AudioPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String MIC_ON = "mic-on";
    public static final String MIC_OFF = "mic-off";
    public static final String TALK_ENABLED = "talk-enabled";
    public static final String TALK_DISABLED = "talk-disabled";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public AudioPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendMicOnMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(MIC_ON), isMe);
    }

    public void sendMicOffMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(MIC_OFF), isMe);
    }

    public void sendTalkEnabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TALK_ENABLED_MESSAGE);
        this.sendRouterMsg(message, this.msgTypes.get(TALK_ENABLED), false);
    }

    public void sendTalkDisabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TALK_DISABLED_MESSAGE);
        this.sendRouterMsg(message, this.msgTypes.get(TALK_DISABLED), false);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("AudioPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(MIC_ON, new MessageType(MIC_ON, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TYPE_MIC_ON), 7));
        this.msgTypes.put(MIC_OFF, new MessageType(MIC_OFF, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TYPE_MIC_OFF), 7));
        this.msgTypes.put(TALK_ENABLED, new MessageType(TALK_ENABLED, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TYPE_TALK_ENABLED), 4));
        this.msgTypes.put(TALK_DISABLED, new MessageType(TALK_DISABLED, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOPUBLISHER_TYPE_TALK_DISABLED), 4));
    }
}

