/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.ImageNote;
import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.NotesBean;
import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.NotesEditor;
import com.elluminate.groupware.notes.module.StringsProperties;
import com.elluminate.groupware.notes.module.TextNote;
import com.elluminate.groupware.notes.module.util.NotesListUtilFactory;
import com.elluminate.gui.textparser.HyperlinkMouseHandler;
import com.elluminate.gui.textparser.TextParserStyledDocument;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class NoteComponent
extends JComponent
implements DocumentListener,
Accessible {
    private AccessibleContext accessibleContext = null;
    private static I18n i18n = I18n.create(NotesBean.class);
    private static final int[] IGNORED_KEYS = new int[]{10, 27, 127, 18, 38, 224, 40, 225, 8};
    private static final int ARC_SIZE = 8;
    private static final int ARROW_SIZE = 16;
    private static final int LEFT_MARGIN = 23;
    private Note note = null;
    private JLabel authorLabel = null;
    private JLabel imagePane = null;
    private JEditorPane editorPane = null;
    private Point oldLocation = null;
    private Point dragAnchor = null;
    private boolean removeOnFocusLoss = false;
    private int fontSize = 12;
    private boolean playedNoteComponent = false;
    private boolean uniqueAuthor = false;
    private Cursor grabCursor = null;
    private Cursor handCursor = null;
    private static final Action boldAction;
    private static final Action italicAction;
    private static final Action underlineAction;
    private static final Action increaseFontSizeAction;
    private static final Action decreaseFontSizeAction;

    public NoteComponent(Note note, Cursor handCursor, Cursor grabCursor, int fontSize, boolean uniqueAuthor) {
        this.note = note;
        this.fontSize = fontSize;
        this.grabCursor = grabCursor;
        this.handCursor = handCursor;
        this.uniqueAuthor = uniqueAuthor;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 24, 2, 2));
        this.setCursor(this.handCursor);
        this.authorLabel = new JLabel();
        Font font = this.authorLabel.getFont();
        this.authorLabel.setFont(font.deriveFont(this.fontSize));
        this.authorLabel.setForeground(Color.GRAY);
        this.add((Component)this.authorLabel, "North");
        String auth = note.getAuthor();
        if (auth != null && auth.length() != 0) {
            this.authorLabel.setText(auth);
        }
        this.authorLabel.setVisible(uniqueAuthor);
        if (note instanceof ImageNote) {
            this.addImageNote((ImageNote)note);
        } else if (note instanceof TextNote) {
            this.addTextNote((TextNote)note);
        }
        this.enableEvents(60L);
    }

    private void addTextNote(TextNote tnote) {
        this.editorPane = new JEditorPane();
        if (tnote.getDocument() instanceof TextParserStyledDocument) {
            HyperlinkMouseHandler hyperlinkMouseHandler = new HyperlinkMouseHandler();
            this.editorPane.addMouseMotionListener((MouseMotionListener)hyperlinkMouseHandler);
            this.editorPane.addMouseListener((MouseListener)hyperlinkMouseHandler);
        }
        this.editorPane.setOpaque(false);
        this.editorPane.setFocusTraversalKeys(0, null);
        this.editorPane.setFocusTraversalKeys(1, null);
        InputMap imap = this.editorPane.getInputMap();
        imap.put(KeyStroke.getKeyStroke(10, 8), "insert-break");
        this.editorPane.setContentType(tnote.getContentType());
        Document doc = tnote.getDocument();
        doc.addDocumentListener(this);
        this.editorPane.setDocument(doc);
        this.editorPane.setCaretPosition(doc.getLength());
        EditorKit kit = this.editorPane.getEditorKit();
        if (kit instanceof StyledEditorKit && doc instanceof StyledDocument) {
            if (tnote.isEmpty()) {
                StyledEditorKit skit = (StyledEditorKit)kit;
                StyledDocument sdoc = (StyledDocument)doc;
                MutableAttributeSet attrs = skit.getInputAttributes();
                Font font = this.editorPane.getFont();
                StyleConstants.setFontFamily(attrs, font.getFamily());
                StyleConstants.setFontSize(attrs, this.fontSize);
                StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
                StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
                StyleConstants.setForeground(attrs, this.editorPane.getForeground());
                sdoc.setCharacterAttributes(0, sdoc.getLength() + 1, attrs, false);
            }
            ActionMap amap = this.editorPane.getActionMap();
            int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            Action act = boldAction;
            String actName = (String)act.getValue("Name");
            imap.put(KeyStroke.getKeyStroke(66, mask), actName);
            amap.put(actName, act);
            act = italicAction;
            actName = (String)act.getValue("Name");
            imap.put(KeyStroke.getKeyStroke(73, mask), actName);
            amap.put(actName, act);
            act = underlineAction;
            actName = (String)act.getValue("Name");
            imap.put(KeyStroke.getKeyStroke(85, mask), actName);
            amap.put(actName, act);
            act = increaseFontSizeAction;
            actName = (String)act.getValue("Name");
            imap.put(KeyStroke.getKeyStroke(93, mask), actName);
            imap.put(KeyStroke.getKeyStroke(61, mask), actName);
            imap.put(KeyStroke.getKeyStroke(107, mask), actName);
            amap.put(actName, act);
            act = decreaseFontSizeAction;
            actName = (String)act.getValue("Name");
            imap.put(KeyStroke.getKeyStroke(91, mask), actName);
            imap.put(KeyStroke.getKeyStroke(45, mask), actName);
            imap.put(KeyStroke.getKeyStroke(109, mask), actName);
            amap.put(actName, act);
        }
        this.add((Component)this.editorPane, "Center");
    }

    public Note getNote() {
        return this.note;
    }

    private boolean handleArrowKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 39: 
                case 227: {
                    if (this.setPositionOnNote(CURSOR_POSITION.TRAILING)) {
                        this.requestFocusInEditor();
                    }
                    return true;
                }
                case 37: 
                case 226: {
                    if (this.setPositionOnNote(CURSOR_POSITION.LEADING)) {
                        this.requestFocusInEditor();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean setPositionOnNote(CURSOR_POSITION pos) {
        Document doc = this.editorPane.getDocument();
        if (doc == null || doc.getLength() <= 0) {
            return false;
        }
        if (pos == CURSOR_POSITION.LEADING) {
            this.editorPane.setCaretPosition(doc.getStartPosition().getOffset());
        } else if (pos == CURSOR_POSITION.TRAILING) {
            this.editorPane.setCaretPosition(doc.getEndPosition().getOffset() - 1);
        }
        return true;
    }

    public void insert(KeyEvent e) {
        if (this.editorPane != null) {
            this.editorPane.dispatchEvent(e);
            if (e.getID() == 400) {
                this.requestFocusInEditor();
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 400 && !this.ignoredKeyCodes(e.getKeyChar())) {
            if (!e.isAltDown()) {
                this.insert(e);
                return;
            }
        } else if (e.getID() == 401 && this.handleArrowKeyEvent(e)) {
            return;
        }
        super.processKeyEvent(e);
    }

    private boolean ignoredKeyCodes(char key) {
        return Arrays.binarySearch(IGNORED_KEYS, (int)key) >= 0;
    }

    private void addImageNote(ImageNote note) {
        ImageNote inote = note;
        this.imagePane = new JLabel();
        Image im = inote.getImage();
        if (im != null) {
            this.imagePane.setIcon(new ImageIcon(im));
        }
        this.add((Component)this.imagePane, "Center");
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        if (this.editorPane != null) {
            this.editorPane.addMouseListener(l);
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        if (this.editorPane != null) {
            this.editorPane.addKeyListener(l);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.editorPane != null) {
            this.editorPane.addFocusListener(l);
        }
    }

    public void requestFocusInEditor() {
        if (this.editorPane != null) {
            this.editorPane.requestFocus();
        }
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void setIsPlayedNoteComponent(boolean toggle) {
        this.playedNoteComponent = toggle;
    }

    public boolean isPlayedNoteComponent() {
        return this.playedNoteComponent;
    }

    public boolean isRemoveOnFocusLoss() {
        return this.removeOnFocusLoss;
    }

    @Override
    protected void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle b = this.getBounds();
        if (this.isPlayedNoteComponent()) {
            int[] ys;
            int[] xs;
            if (b.height > 32) {
                int x0 = 0;
                int x3 = 23 - b.x - 4;
                int x1 = x0 + 2;
                int x2 = x3 / 2;
                int y0 = 0;
                int y4 = 16;
                int y2 = y4 / 2;
                int y1 = y0 + 4;
                int y3 = y4 - 4;
                int y5 = b.height - 1;
                xs = new int[]{x0, x2, x2, x3, x2, x2, x1, x1, x0};
                ys = new int[]{y1, y1, y0, y2, y4, y3, y3, y5, y5};
            } else {
                int x0 = 0;
                int x2 = 23 - b.x - 4;
                int x1 = x2 / 2;
                int y0 = 0;
                int y4 = 16;
                int y2 = y4 / 2;
                int y1 = y0 + 4;
                int y3 = y4 - 4;
                xs = new int[]{x0, x1, x1, x2, x1, x1, x0};
                ys = new int[]{y1, y1, y0, y2, y4, y3, y3};
            }
            if (this.isFocusOwner()) {
                g.setColor(UIManager.getColor("EditorPane.selectionBackground"));
            } else {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.fillPolygon(xs, ys, xs.length);
            g.setColor(Color.GRAY);
            g.drawPolygon(xs, ys, xs.length);
        } else if (this.isFocusOwner()) {
            g.setColor(UIManager.getColor("EditorPane.selectionBackground"));
            g.fillRoundRect(0, 0, 23 - b.x - 4, b.height - 1, 8, 8);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRoundRect(0, 0, 23 - b.x - 4, b.height - 1, 8, 8);
        } else if (this.editorPane != null && this.editorPane.isFocusOwner()) {
            g.setColor(Color.LIGHT_GRAY);
            g.drawRoundRect(0, 0, b.width - 1, b.height - 1, 8, 8);
        } else {
            g.setColor(Color.LIGHT_GRAY);
            g.drawRoundRect(0, 0, 23 - b.x - 4, b.height - 1, 8, 8);
        }
    }

    public void setIsUniqueAuthor(boolean isUniqueAuthor) {
        this.uniqueAuthor = isUniqueAuthor;
        this.authorLabel.setVisible(this.uniqueAuthor);
    }

    public boolean isUniqueAuthor() {
        return this.uniqueAuthor;
    }

    public void resetAuthorLabel() {
        if (this.isUniqueAuthor()) {
            this.authorLabel.setVisible(true);
        } else {
            this.authorLabel.setVisible(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dm = super.getPreferredSize();
        if (this.note.isEmpty()) {
            dm = !this.uniqueAuthor ? new Dimension(dm.width, 8) : new Dimension(dm.width, this.authorLabel.getHeight());
        }
        return dm;
    }

    public void clear() {
        if (this.editorPane != null) {
            try {
                Document doc = this.editorPane.getDocument();
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                LogSupport.error((Object)this, (String)"clear", (String)ex.toString());
            }
        } else if (this.imagePane != null) {
            this.imagePane.setIcon(null);
        }
        this.authorLabel.setVisible(false);
    }

    public boolean isEnteringList(int keyEventID) {
        String txt;
        if (this.editorPane == null) {
            return false;
        }
        try {
            Document doc = this.editorPane.getDocument();
            txt = doc.getText(0, doc.getLength());
            if (txt == null) {
                return false;
            }
        }
        catch (BadLocationException ex) {
            return false;
        }
        int endIndex = this.editorPane.getSelectionStart();
        return NotesListUtilFactory.getInstance(keyEventID).isEnteringList(txt.substring(0, endIndex));
    }

    public void removeOnFocusLoss() {
        this.removeOnFocusLoss(true);
    }

    public void removeOnFocusLoss(boolean toRemove) {
        this.removeOnFocusLoss = toRemove;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.requestFocus();
                this.oldLocation = this.getLocation();
                this.dragAnchor = e.getPoint();
                this.setCursor(this.grabCursor);
                break;
            }
            case 502: {
                this.setCursor(this.handCursor);
                Point loc = this.getLocation();
                if (loc.y == this.oldLocation.y) break;
                this.oldLocation = null;
                this.dragAnchor = null;
                ((NotesEditor)this.getParent()).calculateTimeAndOffset(this.getNote(), loc.y);
            }
        }
        super.processMouseEvent(e);
    }

    protected Point getDragAnchor() {
        return this.dragAnchor;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        NotesEditor notesEditor = (NotesEditor)this.getParent();
        NotesDocument document = notesEditor.getDocument();
        int noteCount = document.getNoteCount();
        if (this.isNewNote() && this.isAtEnd(document, this.getNote())) {
            long sessionTime = notesEditor.getTimeProvider().getTime();
            if (noteCount > 1) {
                Note prevNote = document.getNote(noteCount - 2);
                long prevNoteTimestamp = prevNote.getTime();
                if (sessionTime == Long.MIN_VALUE || sessionTime <= prevNoteTimestamp) {
                    sessionTime = prevNoteTimestamp + 1000L;
                }
            }
            this.getNote().setTime(sessionTime);
        }
    }

    private boolean isNewNote() {
        if (this.editorPane == null) {
            return false;
        }
        return this.editorPane.getDocument().getLength() == 1;
    }

    private boolean isAtEnd(NotesDocument doc, Note theNote) {
        int lastNoteIndex = doc.getNoteCount() - 1;
        int currentNoteIndex = doc.getNoteIndex(theNote);
        return currentNoteIndex == lastNoteIndex;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNoteComponent();
        }
        return this.accessibleContext;
    }

    static {
        Arrays.sort(IGNORED_KEYS);
        boldAction = new StyledEditorKit.BoldAction();
        italicAction = new StyledEditorKit.ItalicAction();
        underlineAction = new StyledEditorKit.UnderlineAction();
        increaseFontSizeAction = new ChangeFontSizeAction("font-size-increase", 1);
        decreaseFontSizeAction = new ChangeFontSizeAction("font-size-decrease", 2);
    }

    class AccessibleNoteComponent
    extends JComponent.AccessibleJComponent {
        AccessibleNoteComponent() {
            super(NoteComponent.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public String getAccessibleName() {
            try {
                NotesEditor editor = (NotesEditor)NoteComponent.this.getParent();
                int idx = editor.getDocument().getNoteIndex(NoteComponent.this.note);
                AccessibleNoteComponent accessibleNoteComponent = this;
                String cmpName = i18n.getString((PropertiesEnum)StringsProperties.NOTECOMPONENT_ACCESSIBLENAME, new Object[]{idx + 1});
                return cmpName;
            }
            catch (NullPointerException npe) {
                return null;
            }
        }

        @Override
        public AccessibleText getAccessibleText() {
            try {
                try {
                    String allText = NoteComponent.this.editorPane.getDocument().getText(0, NoteComponent.this.editorPane.getDocument().getLength());
                    allText = allText.replace('\n', ' ');
                    return new NoteComponentAccessibleText(allText);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return NoteComponent.this.editorPane.getAccessibleContext().getAccessibleText();
                }
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                return null;
            }
        }
    }

    private static enum CURSOR_POSITION {
        LEADING,
        TRAILING;

    }

    private static class ChangeFontSizeAction
    extends StyledEditorKit.StyledTextAction {
        public static final int INCREASE = 1;
        public static final int DECREASE = 2;
        private int change;

        public ChangeFontSizeAction(String name, int change) {
            super(name);
            this.change = change;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                int size = StyleConstants.getFontSize(attr);
                switch (this.change) {
                    case 1: {
                        ++size;
                        break;
                    }
                    case 2: {
                        if (size > 1) {
                            --size;
                            break;
                        }
                    }
                    default: {
                        return;
                    }
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setFontSize(sas, size);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class NoteComponentAccessibleText
    implements AccessibleText {
        private String text;

        public NoteComponentAccessibleText(String text) {
            this.text = text;
        }

        @Override
        public String getAfterIndex(int part, int index) {
            return this.text;
        }

        @Override
        public String getAtIndex(int part, int index) {
            return this.text;
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            return this.text;
        }

        @Override
        public int getCaretPosition() {
            return 0;
        }

        @Override
        public int getCharCount() {
            return this.text.length();
        }

        @Override
        public AttributeSet getCharacterAttribute(int i) {
            return null;
        }

        @Override
        public Rectangle getCharacterBounds(int i) {
            return null;
        }

        @Override
        public int getIndexAtPoint(Point p) {
            return 0;
        }

        @Override
        public String getSelectedText() {
            return this.text;
        }

        @Override
        public int getSelectionEnd() {
            return this.text.length();
        }

        @Override
        public int getSelectionStart() {
            return 0;
        }
    }
}

