/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;

abstract class Note {
    public static final String AUTHOR_PROPERTY = "author";
    public static final String TIME_PROPERTY = "time";
    public static final String OFFSET_PROPERTY = "offset";
    private String contentType;
    private long time = 0L;
    private int offset = 0;
    private String author;
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public Note(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        String oldAuthor = this.author;
        this.author = author;
        this.changeSupport.firePropertyChange(AUTHOR_PROPERTY, oldAuthor, author);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long newTime) {
        long oldTime = this.time;
        this.time = newTime;
        this.changeSupport.firePropertyChange(TIME_PROPERTY, new Long(oldTime), new Long(newTime));
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        int oldOffset = this.offset;
        this.offset = offset;
        this.changeSupport.firePropertyChange(OFFSET_PROPERTY, oldOffset, offset);
    }

    public abstract byte[] getData() throws IOException;

    public abstract void setData(byte[] var1) throws IOException;

    public abstract String getDataAsText();

    public abstract boolean isEmpty();

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }
}

