/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.NotesDocument;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;

class CompoundNotesDocument
extends NotesDocument {
    private ArrayList documents = new ArrayList();
    private NotesDocument authoredDocument;
    private ArrayList cachedNotes = new ArrayList();
    private Comparator noteComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            long t2;
            long t1 = ((Note)obj1).getTime();
            if (t1 < (t2 = ((Note)obj2).getTime())) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };

    public CompoundNotesDocument(String sessionID, Date sessionDate, String sessionName, String author) {
        super(null, null, sessionID, sessionDate, sessionName, author);
    }

    public void addDocument(NotesDocument document) {
        this.documents.add(document);
    }

    public void removeDocument(NotesDocument document) {
        this.documents.remove(document);
    }

    public NotesDocument removeDocument(int index) {
        return (NotesDocument)this.documents.remove(index);
    }

    public int getDocumentCount() {
        return this.documents.size();
    }

    public NotesDocument[] getDocuments() {
        return this.documents.toArray(new NotesDocument[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotesDocument getAuthoredDocument() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            String auth = this.getAuthor();
            for (NotesDocument ndoc : this.documents) {
                if (!ndoc.getAuthor().equals(auth)) continue;
                return ndoc;
            }
            if (this.documents.size() > 0) {
                return (NotesDocument)this.documents.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadHeader() throws IOException {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (ndoc.isIdentified()) continue;
                ndoc.loadHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadNotes() throws IOException {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (ndoc.isLoaded()) continue;
                ndoc.loadNotes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadNotes() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (!ndoc.isLoaded()) continue;
                ndoc.unloadNotes();
            }
        }
        this.cachedNotes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (!ndoc.isModified()) continue;
                ndoc.save();
            }
        }
    }

    @Override
    public void saveCopy(File file) throws IOException {
        this.writeNotesFile(this.getNotes(), file);
    }

    @Override
    public void saveCopyAsText(File file) throws IOException {
        this.writeTextFile(this.getNotes(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (ndoc.delete()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                if (ndoc.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNote(Note note) {
        NotesDocument ndoc = this.getAuthoredDocument();
        if (ndoc != null) {
            ndoc.addNote(note);
        }
        ArrayList arrayList = this.cachedNotes;
        synchronized (arrayList) {
            this.cachedNotes.add(note);
            Collections.sort(this.cachedNotes, this.noteComparator);
        }
    }

    @Override
    public void removeNote(Note note) {
        NotesDocument ndoc = this.getAuthoredDocument();
        if (ndoc != null) {
            ndoc.removeNote(note);
        }
        this.cachedNotes.remove(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllNotes() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                ndoc.removeAllNotes();
            }
        }
        this.cachedNotes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Note[] getNotes() {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            for (NotesDocument ndoc : this.documents) {
                Note[] nts = ndoc.getNotes();
                for (int i = 0; i < nts.length; ++i) {
                    notes.add(nts[i]);
                }
            }
        }
        Collections.sort(notes, this.noteComparator);
        this.cachedNotes = notes;
        return notes.toArray(new Note[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNoteCount() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            int count = 0;
            for (NotesDocument ndoc : this.documents) {
                count += ndoc.getNoteCount();
            }
            return count;
        }
    }

    @Override
    public int getNoteIndex(Note note) {
        return this.cachedNotes.indexOf(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Note getNote(int index) {
        ArrayList arrayList = this.cachedNotes;
        synchronized (arrayList) {
            if (index < this.cachedNotes.size()) {
                return (Note)this.cachedNotes.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdentified() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            Iterator itr = this.documents.iterator();
            while (itr.hasNext()) {
                if (((NotesDocument)itr.next()).isIdentified()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoaded() {
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            Iterator itr = this.documents.iterator();
            while (itr.hasNext()) {
                if (((NotesDocument)itr.next()).isLoaded()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            Iterator itr = this.documents.iterator();
            while (itr.hasNext()) {
                if (!((NotesDocument)itr.next()).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            Iterator itr = this.documents.iterator();
            while (itr.hasNext()) {
                ((NotesDocument)itr.next()).addPropertyChangeListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        ArrayList arrayList = this.documents;
        synchronized (arrayList) {
            Iterator itr = this.documents.iterator();
            while (itr.hasNext()) {
                ((NotesDocument)itr.next()).removePropertyChangeListener(l);
            }
        }
    }
}

