/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.windows;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.platform.Platform;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.event.KeyEvent;

public class WinHotKey
implements HotKey,
Runnable {
    private static final boolean CTRL_PRSCRN_FAILS = Platform.getOS() == 401;
    private static final int ST_SETUP = 0;
    private static final int ST_RUN = 1;
    private static final int ST_STOP = 2;
    private static final int ST_DISPOSED = 3;
    private static final String LIB_NAME = "WinPlatform";
    private static final boolean ALIAS_CANCEL = true;
    private Thread messageThread = null;
    private int displayKey;
    private int keyCode;
    private int modifiers;
    private Runnable action;
    private boolean enabled = true;
    private volatile int state = 0;

    private native int nativeHotKeyListener(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinHotKey(int key, int mod, Runnable run) {
        this.displayKey = key;
        this.keyCode = key;
        this.modifiers = mod;
        this.action = run;
        if (this.displayKey == 3) {
            this.displayKey = 19;
        }
        if (this.keyCode == 19) {
            this.keyCode = 3;
        }
        this.messageThread = new WorkerThread((Runnable)this, "HotKey Handler");
        this.messageThread.setDaemon(true);
        this.messageThread.start();
        WinHotKey winHotKey = this;
        synchronized (winHotKey) {
            while (this.state == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
        if (this.state == 3) {
            throw new RuntimeException("Requested hotkey is unavailable.");
        }
        if (GUIDebug.HOT_KEYS.show()) {
            LogSupport.message((Object)this, (String)"<init>", (String)("registered hot key: " + this));
        }
        Runtime.getRuntime().addShutdownHook(new Thread("Hotkey-Shutdown-Hook"){

            @Override
            public void run() {
                try {
                    WinHotKey.this.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public int getKeyCode() {
        return this.keyCode;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getKeyDesc() {
        return GuiUtils.getKeystrokeText(this.displayKey, this.modifiers);
    }

    @Override
    public boolean hasAction() {
        return this.action != null;
    }

    @Override
    public void setAction(Runnable run) {
        this.action = run;
    }

    @Override
    public void runAction() {
        if (this.enabled && this.action != null) {
            if (GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"runAction", (String)("firing hot key: " + this.toString()));
            }
            try {
                this.action.run();
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"runAction", (Throwable)t, (boolean)true);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.hashCode() + ": key=" + KeyEvent.getKeyText(this.keyCode) + " mod=" + KeyEvent.getKeyModifiersText(this.modifiers) + " display=" + KeyEvent.getKeyText(this.displayKey) + " state=" + this.getStateName() + " enabled=" + this.enabled + " action=" + this.action;
    }

    private String getStateName() {
        switch (this.state) {
            case 0: {
                return "setup(" + this.state + ")";
            }
            case 1: {
                return "running(" + this.state + ")";
            }
            case 2: {
                return "stopped(" + this.state + ")";
            }
            case 3: {
                return "disposed(" + this.state + ")";
            }
        }
        return "unknown(" + this.state + ")";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        WinHotKey winHotKey = this;
        synchronized (winHotKey) {
            if (this.state != 3) {
                this.state = 2;
                this.notify();
            }
            for (int i = 0; i < 10 && this.state != 3; ++i) {
                try {
                    this.wait(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.state = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        boolean disposed;
        WinHotKey winHotKey = this;
        synchronized (winHotKey) {
            disposed = this.state == 3;
        }
        return disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int result = 0;
        try {
            if (CTRL_PRSCRN_FAILS && this.modifiers == 2 && this.keyCode == 154) {
                return;
            }
            result = this.nativeHotKeyListener(this.keyCode, this.modifiers);
            if (result != 0 && GUIDebug.HOT_KEYS.show()) {
                LogSupport.message((Object)this, (String)"run", (String)("nativeHotKeyListener failed: " + result));
            }
        }
        finally {
            WinHotKey winHotKey = this;
            synchronized (winHotKey) {
                this.state = 3;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRunning() {
        WinHotKey winHotKey = this;
        synchronized (winHotKey) {
            this.state = 1;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDone() {
        boolean done;
        WinHotKey winHotKey = this;
        synchronized (winHotKey) {
            done = this.state == 2 || this.state == 3;
        }
        return done;
    }

    static {
        System.loadLibrary(LIB_NAME);
    }
}

